/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.servlet;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.ChartType;
import com.jidesoft.chart.Orientation;
import com.jidesoft.chart.PointShape;
import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.axis.CategoryAxis;
import com.jidesoft.chart.axis.NumericAxis;
import com.jidesoft.chart.model.ChartCategory;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.render.LineRenderer;
import com.jidesoft.chart.render.Pie3DRenderer;
import com.jidesoft.chart.render.PointRenderer;
import com.jidesoft.chart.render.SmoothLineRenderer;
import com.jidesoft.chart.render.SphericalPointRenderer;
import com.jidesoft.chart.servlet.HttpComponentFactory;
import com.jidesoft.chart.servlet.ServletUtils;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.Category;
import com.jidesoft.range.CategoryRange;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class DefaultHttpChartFactory
implements HttpComponentFactory<Chart> {
    private static final Logger \u0101 = Logger.getLogger(DefaultHttpChartFactory.class.getName());
    private static final int \u0104 = 400;
    private static final int \u0103 = 300;
    private List<Axis> \u0102 = new ArrayList<Axis>();

    Dimension \u0101(String string) {
        Integer n2;
        Object object;
        String[] stringArray = string == null ? new String[]{} : string.split("x");
        try {
            object = stringArray.length == 0 ? "" : stringArray[0];
            n2 = Integer.valueOf((String)object);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 400;
        }
        try {
            String string2 = stringArray.length < 2 ? "" : stringArray[1];
            object = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = 300;
        }
        return new Dimension(n2, (Integer)object);
    }

    void \u0107(Chart chart, String string) {
        if (string == null) {
            string = "xy";
        }
        if (string.startsWith("p")) {
            chart.setChartType(ChartType.PIE);
            if ("p3".equals(string)) {
                chart.setPieSegmentRenderer(new Pie3DRenderer());
            }
        } else {
            chart.setChartType(ChartType.XY);
        }
    }

    void \u0103(Chart chart, String string) {
        String[] stringArray;
        if (string == null) {
            string = "[0,0,0,0]";
        }
        int n2 = "".equals((stringArray = string.split("(\\[|\\])"))[0]) ? 1 : 0;
        String[] stringArray2 = stringArray[n2].split(",");
        String string2 = stringArray2.length > 0 ? stringArray2[0] : "";
        String string3 = stringArray2.length > 1 ? stringArray2[1] : "";
        String string4 = stringArray2.length > 2 ? stringArray2[2] : "";
        String string5 = stringArray2.length > 3 ? stringArray2[3] : "";
        int n3 = DefaultHttpChartFactory.\u0102("marg", string2);
        int n4 = DefaultHttpChartFactory.\u0102("marg", string3);
        int n5 = DefaultHttpChartFactory.\u0102("marg", string4);
        int n6 = DefaultHttpChartFactory.\u0102("marg", string5);
        EmptyBorder emptyBorder = new EmptyBorder(n3, n4, n5, n6);
        chart.setBorder(emptyBorder);
    }

    void \u0102(Chart chart, String string) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("(\\[|\\])");
        int n2 = "".equals(stringArray[0]) ? 1 : 0;
        String string2 = stringArray[n2];
        chart.setTitle(string2);
    }

    void \u0108(Chart chart, String string) {
        String[] stringArray;
        this.\u0102.clear();
        boolean bl = true;
        if (string == null) {
            string = "x[0,100,x];y[0,100,y]";
        }
        for (String string2 : stringArray = string.split(";")) {
            if (string2.contains("{") && string2.contains("}")) {
                bl |= this.\u0101(chart, string2, bl);
                continue;
            }
            bl |= this.\u0102(chart, string2, bl);
        }
    }

    boolean \u0101(Chart chart, String string, boolean bl) {
        String[] stringArray = string.split("(\\{|\\})");
        boolean bl2 = false;
        if (stringArray.length >= 2) {
            String[] stringArray2 = stringArray[1].split(",");
            String string2 = stringArray2[0];
            CategoryRange<String> categoryRange = new CategoryRange<String>();
            for (int i2 = 1; i2 < stringArray2.length; ++i2) {
                ChartCategory<String> chartCategory = new ChartCategory<String>(stringArray2[i2]);
                categoryRange.add(chartCategory);
            }
            CategoryAxis categoryAxis = new CategoryAxis(categoryRange);
            if (!"".equals(string2.trim())) {
                categoryAxis.setLabel(string2);
            }
            if ("x".equals(stringArray[0])) {
                chart.setXAxis(categoryAxis);
            } else if ("y".equals(stringArray[0])) {
                bl2 = true;
                if (bl) {
                    chart.setYAxis(categoryAxis);
                } else {
                    chart.addYAxis(categoryAxis);
                }
            } else if ("t".equals(stringArray[0])) {
                categoryAxis.setPlacement(AxisPlacement.TRAILING);
                chart.setXAxis(categoryAxis);
            } else if ("r".equals(stringArray[0])) {
                bl2 = true;
                categoryAxis.setPlacement(AxisPlacement.TRAILING);
                if (bl) {
                    chart.setYAxis(categoryAxis);
                } else {
                    chart.addYAxis(categoryAxis);
                }
            }
        }
        return bl2;
    }

    boolean \u0102(Chart chart, String string, boolean bl) {
        String[] stringArray = string.split("(\\[|\\])");
        boolean bl2 = false;
        if (stringArray.length >= 2) {
            String[] stringArray2 = stringArray[1].split(",");
            String string2 = stringArray2[0];
            double d2 = DefaultHttpChartFactory.\u0101(string, stringArray2[1]);
            double d3 = DefaultHttpChartFactory.\u0101(string, stringArray2[2]);
            NumericAxis numericAxis = new NumericAxis(d2, d3);
            if (!"".equals(string2.trim())) {
                numericAxis.setLabel(string2);
            }
            if ("x".equals(stringArray[0])) {
                chart.setXAxis(numericAxis);
            } else if ("y".equals(stringArray[0])) {
                bl2 = true;
                if (bl) {
                    chart.setYAxis(numericAxis);
                } else {
                    chart.addYAxis(numericAxis);
                }
            } else if ("t".equals(stringArray[0])) {
                numericAxis.setPlacement(AxisPlacement.TRAILING);
                chart.setXAxis(numericAxis);
            } else if ("r".equals(stringArray[0])) {
                bl2 = true;
                numericAxis.setPlacement(AxisPlacement.TRAILING);
                if (bl) {
                    chart.setYAxis(numericAxis);
                } else {
                    chart.addYAxis(numericAxis);
                }
            }
        }
        return bl2;
    }

    void \u0103(Chart chart, String string, String string2) {
        int n2;
        DefaultChartModel defaultChartModel = new DefaultChartModel(string);
        String[] stringArray = string2.split("(\\[|\\])");
        int n3 = n2 = "".equals(stringArray[0]) ? 1 : 0;
        if (chart.getXAxis() instanceof CategoryAxis) {
            CategoryAxis categoryAxis = (CategoryAxis)chart.getXAxis();
            String[] stringArray2 = stringArray[n2].split(",");
            CategoryRange categoryRange = (CategoryRange)categoryAxis.getRange();
            List list = categoryRange.getCategoryValues();
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String string3 = stringArray2[i2];
                Category category = list.get(i2);
                double d2 = DefaultHttpChartFactory.\u0101(string, string3);
                defaultChartModel.addPoint(category, d2);
            }
        } else if (chart.getYAxis() instanceof CategoryAxis) {
            CategoryAxis categoryAxis = (CategoryAxis)chart.getYAxis();
            String[] stringArray3 = stringArray[n2].split(",");
            CategoryRange categoryRange = (CategoryRange)categoryAxis.getRange();
            List list = categoryRange.getCategoryValues();
            for (int i3 = 0; i3 < stringArray3.length; ++i3) {
                String string4 = stringArray3[i3];
                Category category = list.get(i3);
                double d3 = DefaultHttpChartFactory.\u0101(string, string4);
                defaultChartModel.addPoint(d3, category);
            }
        } else {
            String[] stringArray4;
            for (String string5 : stringArray4 = stringArray[n2].split(";")) {
                String[] stringArray5 = string5.split(",");
                double d4 = DefaultHttpChartFactory.\u0101(string, stringArray5[0]);
                double d5 = DefaultHttpChartFactory.\u0101(string, stringArray5[1]);
                defaultChartModel.addPoint(d4, d5);
            }
        }
        chart.addModel(defaultChartModel);
    }

    void \u0102(Chart chart, String string, String string2) {
        Integer n2;
        String[] stringArray;
        ChartModel chartModel = chart.getModel(string);
        if (chartModel == null) {
            chartModel = new DefaultChartModel(string);
        }
        int n3 = "".equals((stringArray = string2.split("(\\[|\\])"))[0]) ? 1 : 0;
        String[] stringArray2 = stringArray[n3].split(",");
        String string3 = stringArray2.length > 0 ? stringArray2[0] : "";
        String string4 = stringArray2.length > 1 ? stringArray2[1] : "";
        String string5 = stringArray2.length > 2 ? stringArray2[2] : "";
        String string6 = stringArray2.length > 3 ? stringArray2[3] : "";
        String string7 = stringArray2.length > 4 ? stringArray2[4] : "";
        String string8 = stringArray2.length > 5 ? stringArray2[5] : "";
        Color color = ServletUtils.hexToColor(string3, Color.black);
        ChartStyle chartStyle = new ChartStyle(color);
        PointShape pointShape = PointShape.DISC;
        try {
            pointShape = PointShape.valueOf(string4.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        chartStyle.setPointShape(pointShape);
        chartStyle.setPointsVisible(!"".equals(string5.trim()));
        try {
            n2 = Integer.valueOf(string5);
            chartStyle.setPointSize(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        chartStyle.setLinesVisible(!"".equals(string6.trim()));
        try {
            n2 = Integer.valueOf(string6);
            chartStyle.setLineWidth(n2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        chartStyle.setBarsVisible(!"".equals(string7));
        if ("h".equals(string7.trim().toLowerCase())) {
            chartStyle.setBarOrientation(Orientation.horizontal);
        } else {
            chartStyle.setBarOrientation(Orientation.vertical);
        }
        if (!"".equals(string8)) {
            n2 = null;
            try {
                n2 = Integer.valueOf(string8);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            chartStyle.setBarWidth(n2);
        }
        chart.setStyle(chartModel, chartStyle);
    }

    void \u0104(Chart chart, String string) {
        if (string == null || chart == null) {
            return;
        }
        Color color = ServletUtils.hexToColor(string, new Color(255, 255, 255, 0));
        chart.setPanelBackground(color);
    }

    void \u0106(Chart chart, String string) {
        if (string == null || chart == null) {
            return;
        }
        Color color = ServletUtils.hexToColor(string, new Color(255, 255, 255, 0));
        chart.setChartBackground(color);
    }

    void \u0101(Chart chart, String string, String string2) {
        String[] stringArray;
        ChartModel chartModel = chart.getModel(string);
        if (chartModel == null) {
            chartModel = new DefaultChartModel(string);
        }
        int n2 = "".equals((stringArray = string2.split("(\\[|\\])"))[0]) ? 1 : 0;
        String[] stringArray2 = stringArray[n2].split(",");
        String string3 = stringArray2.length > 0 ? stringArray2[0] : "";
        String string4 = stringArray2.length > 1 ? stringArray2[1] : "";
        String string5 = stringArray2.length > 2 ? stringArray2[2] : "";
        Color color = ServletUtils.hexToColor(string3, Color.black);
        ChartStyle chartStyle = chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle(color);
        } else {
            chartStyle.setLineColor(color);
        }
        chartStyle.setLinesVisible(!"".equals(string4.trim()));
        chartStyle.setLineWidth(DefaultHttpChartFactory.\u0102("line", string4));
        if (!"".equals(string5)) {
            try {
                Class clazz = "smooth".equals(string5) ? SmoothLineRenderer.class : Class.forName(string5);
                LineRenderer lineRenderer = null;
                try {
                    lineRenderer = (LineRenderer)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                try {
                    if (lineRenderer == null) {
                        Constructor constructor = clazz.getConstructor(Chart.class);
                        lineRenderer = (LineRenderer)constructor.newInstance(chart);
                    }
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
                if (lineRenderer != null) {
                    chart.setLineRenderer(chartModel, lineRenderer);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                \u0101.warning("Line Renderer Class not found: " + string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        chart.setStyle(chartModel, chartStyle);
    }

    void \u0105(Chart chart, String string) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        Font font = ServletUtils.parseFont(string);
        if (font != null) {
            chart.setTickFont(font);
        }
    }

    void \u0101(Chart chart, String string) {
        if (string == null || "".equals(string.trim())) {
            return;
        }
        Font font = ServletUtils.parseFont(string);
        if (font != null) {
            chart.setFont(font);
            UIManager.getDefaults().put("Chart.font", font);
        }
    }

    void \u0104(Chart chart, String string, String string2) {
        String[] stringArray;
        ChartModel chartModel = chart.getModel(string);
        if (chartModel == null) {
            chartModel = new DefaultChartModel(string);
        }
        int n2 = "".equals((stringArray = string2.split("(\\[|\\])"))[0]) ? 1 : 0;
        String[] stringArray2 = stringArray[n2].split(",");
        String string3 = stringArray2.length > 0 ? stringArray2[0] : "";
        String string4 = stringArray2.length > 1 ? stringArray2[1] : "";
        String string5 = stringArray2.length > 2 ? stringArray2[2] : "";
        Color color = ServletUtils.hexToColor(string3, Color.black);
        ChartStyle chartStyle = chart.getStyle(chartModel);
        if (chartStyle == null) {
            chartStyle = new ChartStyle(color);
        } else {
            chartStyle.setPointColor(color);
        }
        chartStyle.setPointsVisible(!"".equals(string4.trim()));
        chartStyle.setPointSize(DefaultHttpChartFactory.\u0102("point", string4));
        if (!"".equals(string5)) {
            Class clazz = null;
            try {
                clazz = "sphere".equals(string5) ? SphericalPointRenderer.class : Class.forName(string5);
                PointRenderer pointRenderer = null;
                try {
                    pointRenderer = (PointRenderer)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
                try {
                    if (pointRenderer == null) {
                        Constructor constructor = clazz.getConstructor(Chart.class);
                        pointRenderer = (PointRenderer)constructor.newInstance(chart);
                    }
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (ClassCastException classCastException) {
                    classCastException.printStackTrace();
                }
                if (pointRenderer != null) {
                    chart.setPointRenderer(chartModel, pointRenderer);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                \u0101.warning("Point Renderer Class not found: " + string5);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        chart.setStyle(chartModel, chartStyle);
    }

    @Override
    public Chart getInstance(HttpServletRequest httpServletRequest) {
        Chart chart = new Chart();
        chart.setAnimateOnShow(false);
        Dimension dimension = this.\u0101(httpServletRequest.getParameter("size"));
        chart.setSize(dimension);
        chart.setPreferredSize(dimension);
        this.\u0104(chart, httpServletRequest.getParameter("bg"));
        this.\u0106(chart, httpServletRequest.getParameter("cbg"));
        this.\u0107(chart, httpServletRequest.getParameter("type"));
        this.\u0108(chart, httpServletRequest.getParameter("axes"));
        this.\u0103(chart, httpServletRequest.getParameter("marg"));
        this.\u0102(chart, httpServletRequest.getParameter("title"));
        this.\u0105(chart, httpServletRequest.getParameter("tickFont"));
        this.\u0101(chart, httpServletRequest.getParameter("font"));
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String[] stringArray;
            String string2 = enumeration.nextElement().toString();
            if ("shadow".equals(string2) || "shadows".equals(string2)) {
                chart.setShadowVisible(true);
                continue;
            }
            if (string2.startsWith("xyd")) {
                stringArray = string2.split("(\\[|\\])");
                string = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "data";
                this.\u0103(chart, string, httpServletRequest.getParameter(string2));
                continue;
            }
            if (string2.startsWith("style")) {
                stringArray = string2.split("(\\[|\\])");
                string = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "data";
                this.\u0102(chart, string, httpServletRequest.getParameter(string2));
                continue;
            }
            if (string2.startsWith("line")) {
                stringArray = string2.split("(\\[|\\])");
                string = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "data";
                this.\u0101(chart, string, httpServletRequest.getParameter(string2));
                continue;
            }
            if (!string2.startsWith("point")) continue;
            stringArray = string2.split("(\\[|\\])");
            string = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "data";
            this.\u0104(chart, string, httpServletRequest.getParameter(string2));
        }
        return chart;
    }

    private static int \u0102(String string, String string2) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            \u0101.severe("In parameter '" + string + "', '" + string2 + "' could not be converted to a number");
        }
        return n2;
    }

    private static double \u0101(String string, String string2) {
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            \u0101.severe("In parameter '" + string + "', '" + string2 + "' could not be converted to a number");
        }
        return d2;
    }
}

