/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.chart.render;

import com.jidesoft.chart.Chart;
import com.jidesoft.chart.event.PointDescriptor;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.render.AbstractRenderer;
import com.jidesoft.chart.render.LinePieLabelRenderer;
import com.jidesoft.chart.render.PieLabelRenderer;
import com.jidesoft.chart.render.PieSegmentRenderer;
import com.jidesoft.chart.render.PointLabeler;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.chart.util.ChartUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ListSelectionModel;

public abstract class AbstractPieSegmentRenderer
extends AbstractRenderer
implements PieSegmentRenderer {
    public static final String PROPERTY_ALWAYS_SHOW_OUTLINES = "Always Show Outlines";
    public static final String PROPERTY_PIE_LABEL_RENDERER = "Pie Label Renderer";
    public static final String PROPERTY_POINT_LABELER = "Point Labeler";
    public static final String PROPERTY_TICK_LENGTH = "Tick Length";
    public static final double maxExplode = 0.2;
    private final Map<Shape, PointDescriptor> \u012a = new HashMap<Shape, PointDescriptor>();
    private PieLabelRenderer \u012b = new LinePieLabelRenderer();
    private Graphics \u0129;

    public AbstractPieSegmentRenderer() {
        this.setAlwaysShowOutlines(true);
    }

    @Override
    public void clearShapes() {
        this.\u012a.clear();
    }

    protected void recordSegment(Shape shape, PointDescriptor pointDescriptor) {
        pointDescriptor.setShape(shape);
        this.\u012a.put(shape, pointDescriptor);
    }

    public Graphics getLabelGraphics() {
        return this.\u0129;
    }

    @Override
    public void setLabelGraphics(Graphics graphics) {
        this.\u0129 = graphics;
    }

    @Override
    public int getTickLength() {
        return this.\u012b == null ? 0 : this.\u012b.getTickLength();
    }

    @Override
    public void setTickLength(int n2) {
        int n3;
        int n4 = n3 = this.\u012b == null ? 0 : this.\u012b.getTickLength();
        if (this.\u012b != null) {
            this.\u012b.setTickLength(n2);
        }
        this.support.firePropertyChange(PROPERTY_TICK_LENGTH, n3, n2);
    }

    @Override
    public PointLabeler getPointLabeler() {
        return this.\u012b.getPointLabeler();
    }

    @Override
    public void setPointLabeler(PointLabeler pointLabeler) {
        PointLabeler pointLabeler2 = this.\u012b.getPointLabeler();
        this.\u012b.setPointLabeler(pointLabeler);
        this.support.firePropertyChange(PROPERTY_POINT_LABELER, pointLabeler2, pointLabeler);
    }

    @Override
    public PieLabelRenderer getPieLabelRenderer() {
        return this.\u012b;
    }

    public void setPieLabelRenderer(PieLabelRenderer pieLabelRenderer) {
        PieLabelRenderer pieLabelRenderer2 = this.\u012b;
        this.\u012b = pieLabelRenderer;
        this.support.firePropertyChange(PROPERTY_PIE_LABEL_RENDERER, pieLabelRenderer2, this.\u012b);
    }

    protected Paint createSegmentPaint(Chart chart, Chartable chartable, ChartStyle chartStyle, boolean bl, boolean bl2, Shape shape) {
        return null;
    }

    public void renderLabels(Graphics graphics, Chart chart, ChartModel chartModel, Point point, int n2, int n3, int[] nArray, ChartStyle chartStyle) {
        if (this.\u012b != null) {
            this.\u012b.renderLabels(graphics, chart, chartModel, point, n2, n3, nArray, chartStyle);
        }
    }

    @Override
    public PointDescriptor containingSegment(Point point) {
        for (Map.Entry<Shape, PointDescriptor> entry : this.\u012a.entrySet()) {
            Shape shape = entry.getKey();
            if (!shape.contains(point)) continue;
            return entry.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PointDescriptor rendered(Chartable chartable) {
        Map<Shape, PointDescriptor> map = this.\u012a;
        synchronized (map) {
            for (PointDescriptor pointDescriptor : this.\u012a.values()) {
                if (!chartable.equals(pointDescriptor.getChartable())) continue;
                return pointDescriptor;
            }
        }
        return null;
    }

    protected void renderOutlines(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point point, int n2, int[] nArray, ChartStyle chartStyle) {
        int n3 = point.x;
        int n4 = point.y;
        int n5 = 2 * n2;
        int n6 = (int)(0.2 * (double)n2);
        int n7 = n3 - n2;
        int n8 = n4 - n2;
        float f2 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            float f3 = f2 + (float)nArray[i2] / 2.0f;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i2);
            int n9 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)((double)n6 * Math.cos(Math.toRadians(f3))) : 0;
            int n10 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)((double)n6 * Math.sin(Math.toRadians(f3)))) : 0;
            graphics2D.translate(n9, n10);
            if (this.alwaysShowOutlines && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 && bl ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                graphics2D.drawLine(n3, n4, (int)Math.round((double)n3 + (double)n2 * Math.cos(Math.toRadians(f2))), (int)Math.round((double)n4 - (double)n2 * Math.sin(Math.toRadians(f2))));
                graphics2D.drawArc(n7, n8, n5, n5, (int)f2, nArray[i2]);
                graphics2D.drawLine(n3, n4, (int)Math.round((double)n3 + (double)n2 * Math.cos(Math.toRadians(f2 += (float)nArray[i2]))), (int)Math.round((double)n4 - (double)n2 * Math.sin(Math.toRadians(f2))));
            } else {
                f2 += (float)nArray[i2];
            }
            graphics2D.translate(-n9, -n10);
        }
    }

    protected void renderOutlines2D(boolean bl, Graphics2D graphics2D, Chart chart, ChartModel chartModel, Point2D point2D, float f2, float[] fArray, ChartStyle chartStyle) {
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = 2.0 * (double)f2;
        double d5 = 0.2 * (double)f2;
        double d6 = d2 - (double)f2;
        double d7 = d3 - (double)f2;
        double d8 = chartStyle.getPieOffsetAngle();
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            double d9 = d8 + (double)fArray[i2] / 2.0;
            ListSelectionModel listSelectionModel = chart.getSelectionsForModel(chartModel);
            boolean bl2 = listSelectionModel.isSelectedIndex(i2);
            int n2 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? (int)(d5 * Math.cos(Math.toRadians(d9))) : 0;
            int n3 = chartStyle.isPieSegmentsAlwaysExploded() || bl2 && chart.isSelectionShowsExplodedSegments() ? -((int)(d5 * Math.sin(Math.toRadians(d9)))) : 0;
            graphics2D.translate(n2, n3);
            if (this.alwaysShowOutlines && !bl || bl2 && chart.isSelectionShowsOutline()) {
                Color color = bl2 && bl ? this.getSelectionColor() : this.getOutlineColor();
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke(this.getOutlineWidth(), 0, 1));
                Line2D.Double double_ = new Line2D.Double(d2, d3, d2 + (double)f2 * Math.cos(Math.toRadians(d8)), d3 - (double)f2 * Math.sin(Math.toRadians(d8)));
                graphics2D.draw(double_);
                Arc2D.Double double_2 = new Arc2D.Double(d6, d7, d4, d4, d8, fArray[i2], 0);
                graphics2D.draw(double_2);
                Line2D.Double double_3 = new Line2D.Double(d2, d3, d2 + (double)f2 * Math.cos(Math.toRadians(d8 += (double)fArray[i2])), d3 - (double)f2 * Math.sin(Math.toRadians(d8)));
                graphics2D.draw(double_3);
            } else {
                d8 += (double)fArray[i2];
            }
            graphics2D.translate(-n2, -n3);
        }
    }

    protected TexturePaint modify(TexturePaint texturePaint) {
        BufferedImage bufferedImage = texturePaint.getImage();
        A a2 = new A();
        BufferedImage bufferedImage2 = a2.filter(bufferedImage, null);
        return new TexturePaint(bufferedImage2, new Rectangle(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight()));
    }

    static class A
    implements BufferedImageOp {
        A() {
        }

        @Override
        public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
            if (colorModel == null) {
                colorModel = bufferedImage.getColorModel();
            }
            return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(bufferedImage.getWidth(), bufferedImage.getHeight()), colorModel.isAlphaPremultiplied(), null);
        }

        @Override
        public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
            if (bufferedImage2 == null) {
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
            int n2 = bufferedImage.getWidth();
            int n3 = bufferedImage.getHeight();
            int[] nArray = new int[n2 * n3];
            ChartUtils.getPixels(bufferedImage, 0, 0, n2, n3, nArray);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                Color color = new Color(nArray[i2], true);
                nArray[i2] = color.brighter().getRGB();
            }
            ChartUtils.setPixels(bufferedImage2, 0, 0, n2, n3, nArray);
            return bufferedImage2;
        }

        @Override
        public Rectangle2D getBounds2D(BufferedImage bufferedImage) {
            return new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        }

        @Override
        public Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
            return (Point2D)point2D.clone();
        }

        @Override
        public RenderingHints getRenderingHints() {
            return null;
        }
    }
}

