/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.ApplicationRegistry;
import com.install4j.api.UiUtil;
import com.install4j.api.Util;
import com.install4j.api.context.ControlButtonType;
import com.install4j.api.context.WizardContext;
import com.install4j.runtime.filechooser.DirectoryChooser;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.frontend.components.AbstractFileSelector;
import com.install4j.runtime.installer.frontend.components.FileValidator;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.AbstractTextAndButtonPanel;
import com.install4j.runtime.util.FileDrop;
import com.install4j.runtime.util.KeyboardUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileSystemView;

public class DirectorySelector
extends AbstractTextAndButtonPanel
implements AbstractFileSelector {
    public static final String PROPERTY_SELECTED_PATH = "selectedPath";
    private static final String BAD_CHARS = ";:*?\"<>|%" + (InstallerUtil.isWindows() ? "/" : "\\");
    private static File lastDirectory = null;
    private String standardDirectoryName;
    private boolean noStandardDirectoryNameForUpdate;
    private InternalValidator internalValidator;
    private WizardContext wizardContext;
    private JTextField txtDirectory;
    private JButton btnBrowse;
    private String directoryDescription;
    private boolean allowSpacesOnUnix = false;
    private boolean allowEmpty = false;
    private boolean standardValidation = true;
    private boolean designTime;
    private String focusInText = "";
    private FileValidator validator;
    private boolean alreadyValidated;
    private String initialBrowserDirectory;

    public DirectorySelector(String directoryDescription, boolean designTime) {
        this.directoryDescription = directoryDescription;
        this.designTime = designTime;
        this.setupControls();
        this.setupComponent();
        this.setupEventHandlers();
    }

    public void setInternalValidator(InternalValidator internalValidator) {
        this.internalValidator = internalValidator;
    }

    public void setAllowSpacesOnUnix(boolean allowSpacesOnUnix) {
        this.allowSpacesOnUnix = allowSpacesOnUnix;
    }

    public void activateNextScreenOnEnter(WizardContext wizardContext) {
        this.wizardContext = wizardContext;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.txtDirectory.setEnabled(enabled);
        this.btnBrowse.setEnabled(enabled);
    }

    public void initDirectory(File initialParentDirectory, String standardDirectoryName) {
        this.standardDirectoryName = standardDirectoryName;
        this.txtDirectory.setText(this.getSuggestedPath(initialParentDirectory));
    }

    public void setDirectory(File directory) {
        if (!Objects.equals(this.txtDirectory.getText(), directory.getPath())) {
            this.txtDirectory.setText(directory.getPath());
        }
    }

    public void setNoStandardDirectoryNameForUpdate(boolean noStandardDirectoryNameForUpdate) {
        this.noStandardDirectoryNameForUpdate = noStandardDirectoryNameForUpdate;
    }

    @Override
    public void setSelectedFile(File file) {
        this.initDirectory(file, "");
    }

    @Override
    public File getSelectedFile() {
        return new File(InstallerUtil.replaceHomeDir(this.getSelectedDirectoryName()));
    }

    @Override
    public JTextField getTextField() {
        return this.txtDirectory;
    }

    @Override
    public JButton getButton() {
        return this.btnBrowse;
    }

    @Override
    public void setManualEntryAllowed(boolean manualEntryAllowed) {
        this.txtDirectory.setEditable(manualEntryAllowed);
    }

    public void setAllowEmpty(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    public void setStandardValidation(boolean standardValidation) {
        this.standardValidation = standardValidation;
    }

    @Override
    public void setValidator(FileValidator validator) {
        this.validator = validator;
    }

    @Override
    public boolean checkSelectedFile() {
        return this.alreadyValidated || this.checkDirectory(this.getSelectedDirectoryName());
    }

    @Override
    public void setInitialBrowserDirectory(String initialBrowserDirectory) {
        this.initialBrowserDirectory = initialBrowserDirectory;
    }

    public boolean checkDirectory(String directory) {
        File file;
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        if (directory.length() == 0) {
            if (this.allowEmpty) {
                return true;
            }
            GUIHelper.showMessage(parent, Messages.getString(".MustEnterDirectory"), 2);
            return false;
        }
        if (this.standardValidation) {
            char[] badChars;
            if (!new File(directory).isAbsolute()) {
                GUIHelper.showMessage(parent, Messages.format(Messages.getString(".InvalidDirectory"), directory), 2);
                return false;
            }
            if (!(InstallerUtil.isWindows() || InstallerUtil.isMacOS() || directory.indexOf(32) <= -1 || this.allowSpacesOnUnix)) {
                GUIHelper.showMessage(parent, Messages.getString(".NoDirNameWithSpace"), 2);
                return false;
            }
            for (char badChar : badChars = BAD_CHARS.toCharArray()) {
                int index = directory.indexOf(badChar);
                if (index < 0 || badChar == ':' && index == 1 && directory.lastIndexOf(58) == index && InstallerUtil.isWindows()) continue;
                GUIHelper.showMessage(parent, Messages.format(Messages.getString(".BadDirName32"), BAD_CHARS), 2);
                return false;
            }
            if (InstallerUtil.isWindows() && directory.lastIndexOf(58) == 1 && !new File(directory.substring(0, 2)).exists()) {
                GUIHelper.showMessage(parent, Messages.getString(".InvalidDrive"), 2);
                return false;
            }
            if (InstallerUtil.isWindows() && directory.startsWith("\\\\")) {
                int index = directory.indexOf(92, 2);
                if (index > 0) {
                    index = directory.indexOf(92, index + 1);
                }
                if (index < 0) {
                    index = directory.length();
                }
                if (!new File(directory.substring(0, index)).exists()) {
                    GUIHelper.showMessage(parent, Messages.getString(".InvalidDrive"), 2);
                    return false;
                }
            }
            try {
                file = new File(directory).getCanonicalFile();
            }
            catch (IOException e) {
                GUIHelper.showMessage(parent, Messages.format(Messages.getString(".InvalidDirectory"), directory), 2);
                return false;
            }
        } else {
            file = new File(directory);
        }
        if (this.internalValidator != null) {
            File newFile = this.internalValidator.validateInternally(file);
            if (newFile == null) {
                return false;
            }
            if (!Objects.equals(newFile, file)) {
                this.setSelectedFile(newFile);
            }
        }
        return this.validator == null || this.validator.isValidFile(file);
    }

    public void focusTextField() {
        if (this.txtDirectory.isEditable()) {
            this.txtDirectory.requestFocus();
            this.txtDirectory.setSelectionStart(0);
            this.txtDirectory.setSelectionEnd(this.txtDirectory.getDocument().getLength());
        } else {
            this.btnBrowse.requestFocus();
        }
    }

    private void setupControls() {
        this.txtDirectory = new JTextField();
        FileDrop.addTo(this.txtDirectory, null);
        this.btnBrowse = new JButton(Messages.getString(".ButtonBrowse"));
    }

    private void setupComponent() {
        this.setOpaque(false);
        if (this.directoryDescription != null && !this.directoryDescription.isEmpty()) {
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.directoryDescription), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.weighty = 0.0;
        gc.gridy = 0;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.add((Component)this.txtDirectory, gc);
        gc.gridx = 1;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.insets.left = 5;
        this.add((Component)this.btnBrowse, gc);
    }

    private void setupEventHandlers() {
        if (this.designTime) {
            return;
        }
        this.btnBrowse.addActionListener(e -> this.doBrowse());
        KeyboardUtil.addAccelerator(0, this.txtDirectory, this.txtDirectory, event -> {
            if (this.wizardContext != null) {
                this.wizardContext.pressControlButton(ControlButtonType.NEXT);
            }
        }, 10, 0);
        this.txtDirectory.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                DirectorySelector.this.focusInText = DirectorySelector.this.txtDirectory.getText();
            }

            @Override
            public void focusLost(FocusEvent e) {
                DirectorySelector.this.firePropertyChange(DirectorySelector.PROPERTY_SELECTED_PATH, DirectorySelector.this.focusInText, DirectorySelector.this.txtDirectory.getText());
            }
        });
        this.txtDirectory.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                DirectorySelector.this.alreadyValidated = false;
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                DirectorySelector.this.alreadyValidated = false;
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DirectorySelector.this.alreadyValidated = false;
            }
        });
    }

    private void doBrowse() {
        File parentDirectory;
        File currentDirectory;
        String selectedPath;
        DirectoryChooser directoryChooser = (DirectoryChooser)((DirectoryChooser)DirectoryChooser.create().parent(UiUtil.getParentWindow())).title(Messages.getString(".SelectDirectory"));
        if (Messages.containsKeyDirectly(".ButtonSelect")) {
            directoryChooser.approveButtonText(Messages.getString(".ButtonSelect"));
        }
        if ((selectedPath = this.txtDirectory.getText().trim()).length() > 0) {
            currentDirectory = new File(selectedPath);
        } else if (this.initialBrowserDirectory != null && this.initialBrowserDirectory.length() > 0) {
            currentDirectory = new File(this.initialBrowserDirectory);
        } else {
            if (lastDirectory == null) {
                lastDirectory = new File(Util.getUserHome());
            }
            currentDirectory = lastDirectory;
        }
        try {
            currentDirectory = currentDirectory.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        while (!(currentDirectory.exists() && currentDirectory.isDirectory() || (parentDirectory = FileSystemView.getFileSystemView().getParentDirectory(currentDirectory)) == null || currentDirectory.equals(parentDirectory))) {
            currentDirectory = parentDirectory;
        }
        if (currentDirectory.exists() && currentDirectory.isDirectory()) {
            directoryChooser.currentDirectory(currentDirectory);
        }
        if (directoryChooser.select()) {
            File selectedDirectory = directoryChooser.getSelectedDirectory();
            String suggestedPath = this.getSuggestedPath(selectedDirectory);
            String oldPath = this.txtDirectory.getText();
            lastDirectory = selectedDirectory;
            if (this.checkDirectory(suggestedPath)) {
                this.txtDirectory.setText(suggestedPath);
                this.firePropertyChange(PROPERTY_SELECTED_PATH, oldPath, suggestedPath);
                this.alreadyValidated = true;
            } else {
                this.alreadyValidated = false;
            }
        }
    }

    private String getSelectedDirectoryName() {
        String directory = this.txtDirectory.getText().trim();
        if (new File(directory).getParent() != null) {
            while (directory.endsWith("\\") || directory.endsWith("/")) {
                directory = directory.substring(0, directory.length() - 1);
            }
        }
        return directory;
    }

    private String getSuggestedPath(File parentDirectory) {
        if (parentDirectory.getPath().trim().length() == 0) {
            return "";
        }
        if (this.standardDirectoryName == null || this.standardDirectoryName.trim().length() == 0 || this.noStandardDirectoryNameForUpdate && ApplicationRegistry.isUpdateDirectory(parentDirectory)) {
            return parentDirectory.getPath();
        }
        return new File(parentDirectory, this.standardDirectoryName).getPath();
    }

    public static interface InternalValidator {
        public File validateInternally(File var1);
    }
}

