/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.dialog.PageList;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.wizard.StepsPane;
import com.jidesoft.wizard.WizardDialogPane;
import com.jidesoft.wizard.WizardResources;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MacOSXStepsPane
extends StepsPane {
    private Color _selectionBackground = UIDefaultsLookup.getColor("List.selectionBackground");
    private Color _selectionForeground = UIDefaultsLookup.getColor("List.selectionForeground");
    protected boolean _contentNumbered = false;
    protected boolean _navigable = false;
    protected WizardDialogPane _wizardDialogPane;
    private JList _contentList;
    private ListSelectionListener _listSelectionListener;

    public MacOSXStepsPane() {
        this.setName(this.getResourceString("Wizard.steps"));
    }

    @Override
    public void setPageList(PageList pageList) {
        this.setPageList(pageList.getPageTitlesAsList());
    }

    @Override
    public void setPageList(final List<String> list) {
        this.removeAll();
        this._contentList = new JList(new AbstractListModel(){
            private static final long serialVersionUID = -7382223823537407360L;

            @Override
            public int getSize() {
                return list.size();
            }

            @Override
            public Object getElementAt(int n) {
                return list.get(n);
            }
        });
        WrappedCellRenderer wrappedCellRenderer = new WrappedCellRenderer(this._contentNumbered, this.getPreferredSize().width);
        wrappedCellRenderer.setOpaque(false);
        this._contentList.setCellRenderer(wrappedCellRenderer);
        this._contentList.setOpaque(false);
        this._contentList.setEnabled(this.isNavigable());
        this._contentList.getAccessibleContext().setAccessibleDescription("");
        JScrollPane jScrollPane = new JScrollPane(this._contentList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(this.getResourceString("Wizard.steps"));
        jLabel.setFont(WizardStyle.getFont("Wizard.titleFont"));
        jLabel.setForeground(this.getForeground());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, WizardStyle.getInt("Wizard.gap"), 0));
        jPanel.add((Component)jLabel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.setBorder(WizardStyle.getBorder("Wizard.stepsBorder"));
        this.setOpaque(true);
        this.validate();
        this.installListener();
    }

    protected String getResourceString(String string) {
        return WizardResources.getResourceBundle(Locale.getDefault()).getString(string);
    }

    private void installListener() {
        if (this._listSelectionListener == null) {
            this._listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Object e = MacOSXStepsPane.this._contentList.getSelectedValue();
                    if (e instanceof String && !e.equals(MacOSXStepsPane.this._wizardDialogPane.getCurrentPage().getTitle())) {
                        MacOSXStepsPane.this._wizardDialogPane.setCurrentPage("" + e);
                    }
                }
            };
        }
        this._contentList.addListSelectionListener(this._listSelectionListener);
    }

    private void uninstallListener() {
        if (this._listSelectionListener != null) {
            this._contentList.removeListSelectionListener(this._listSelectionListener);
        }
    }

    @Override
    public void setSelectedPage(String string) {
        this.setSelectedPage(string, true);
    }

    @Override
    public void setSelectedPage(String string, boolean bl) {
        if (!bl) {
            this.uninstallListener();
        }
        try {
            this._contentList.setSelectedValue(string, true);
            this._contentList.revalidate();
        }
        finally {
            if (!bl) {
                this.installListener();
            }
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        this.setSelectedIndex(n, true);
    }

    @Override
    public void setSelectedIndex(int n, boolean bl) {
        if (!bl) {
            this.uninstallListener();
        }
        try {
            this._contentList.setSelectedIndex(n);
            this._contentList.ensureIndexIsVisible(n);
            this._contentList.revalidate();
        }
        finally {
            if (!bl) {
                this.installListener();
            }
        }
    }

    public Color getSelectionBackground() {
        return this._selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        this._selectionBackground = color;
    }

    public Color getSelectionForeground() {
        return this._selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        this._selectionForeground = color;
    }

    @Override
    public boolean isNavigable() {
        return this._navigable;
    }

    @Override
    public void setNavigable(boolean bl) {
        this._navigable = bl;
        if (this._contentList != null) {
            this._contentList.setEnabled(bl);
        }
    }

    @Override
    public WizardDialogPane getWizardDialogPane() {
        return this._wizardDialogPane;
    }

    @Override
    public void setWizardDialogPane(WizardDialogPane wizardDialogPane) {
        this._wizardDialogPane = wizardDialogPane;
    }

    private class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JRadioButton _numberedLabel;
        MultilineLabel _title;
        int _titleWidth;
        boolean _contentNumbered;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout());
            this._title = new MultilineLabel("");
            this._contentNumbered = bl;
            this._titleWidth = n - 12 - 12;
            this._numberedLabel = new JRadioButton();
            this._numberedLabel.setHorizontalAlignment(2);
            this._numberedLabel.setVerticalAlignment(1);
            this._numberedLabel.setFont(this._title.getFont());
            this._numberedLabel.setOpaque(false);
            this.add((Component)this._numberedLabel, "West");
            this._titleWidth -= 25;
            Insets insets = this._title.getInsets();
            this._title.setSize(this._titleWidth, insets.top + insets.bottom + 1);
            this.add((Component)this._title, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 2));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (this._contentNumbered) {
                this._numberedLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this._title.getInsets();
            this._title.setSize(this._titleWidth, insets.top + insets.bottom + 1);
            this._title.setText((String)object);
            if (bl) {
                this._numberedLabel.setSelected(true);
                this._numberedLabel.setEnabled(true);
            } else {
                this._numberedLabel.setSelected(false);
                this._numberedLabel.setEnabled(MacOSXStepsPane.this.isNavigable());
            }
            return this;
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            if (this._numberedLabel != null) {
                this._numberedLabel.setForeground(color);
            }
            if (this._title != null) {
                this._title.setForeground(color);
            }
        }
    }
}

