/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.dialog.PageList;
import com.jidesoft.swing.MultilineLabel;
import com.jidesoft.wizard.JavaWizardHeader;
import com.jidesoft.wizard.StepsPane;
import com.jidesoft.wizard.WizardDialogPane;
import com.jidesoft.wizard.WizardResources;
import com.jidesoft.wizard.WizardStyle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JavaStepsPane
extends StepsPane {
    protected Color _selectionBackground = null;
    protected Color _selectionForeground = null;
    protected boolean _contentNumbered = true;
    protected boolean _navigable = false;
    protected WizardDialogPane _wizardDialogPane;
    protected JList _contentList;
    protected JavaWizardHeader _header;
    private ListSelectionListener _listSelectionListener;

    public JavaStepsPane() {
        this.setName(this.getResourceString("Wizard.steps"));
    }

    public JavaStepsPane(Image image) {
        super(image);
        this.setName(this.getResourceString("Wizard.steps"));
    }

    @Override
    public void setPageList(PageList pageList) {
        this.setPageList(pageList.getPageTitlesAsList());
    }

    @Override
    public void setPageList(List<String> list) {
        this.removeAll();
        this._contentList = new JList(new ContentListModel(list));
        WrappedCellRenderer wrappedCellRenderer = new WrappedCellRenderer(this._contentNumbered, this.getPreferredSize().width);
        this._contentList.setCellRenderer(wrappedCellRenderer);
        this._contentList.setOpaque(false);
        this._contentList.setEnabled(this.isNavigable());
        this._contentList.setCursor(Cursor.getPredefinedCursor(12));
        this._contentList.getAccessibleContext().setAccessibleDescription("");
        JScrollPane jScrollPane = new JScrollPane(this._contentList);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.getViewport().setOpaque(false);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this._header = new JavaWizardHeader(this.getResourceString("Wizard.steps"), "");
        this._header.setForeground(this.getForeground());
        jPanel.add((Component)this._header, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "North");
        this.add((Component)jScrollPane, "Center");
        this.setBorder(WizardStyle.getBorder("Wizard.pageBorder"));
        this.setOpaque(true);
        this.validate();
        this.installListener();
    }

    protected String getResourceString(String string) {
        return WizardResources.getResourceBundle(Locale.getDefault()).getString(string);
    }

    private void installListener() {
        if (this._listSelectionListener == null) {
            this._listSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    Object e = JavaStepsPane.this._contentList.getSelectedValue();
                    if (e instanceof String && !e.equals(JavaStepsPane.this._wizardDialogPane.getCurrentPage().getTitle())) {
                        JavaStepsPane.this._wizardDialogPane.setCurrentPage("" + e);
                    }
                }
            };
        }
        this._contentList.addListSelectionListener(this._listSelectionListener);
    }

    private void uninstallListener() {
        if (this._listSelectionListener != null) {
            this._contentList.removeListSelectionListener(this._listSelectionListener);
        }
    }

    @Override
    public void setSelectedPage(String string) {
        this.setSelectedPage(string, true);
    }

    @Override
    public void setSelectedPage(String string, boolean bl) {
        if (!bl) {
            this.uninstallListener();
        }
        try {
            this._contentList.setSelectedValue(string, true);
            this._contentList.revalidate();
        }
        finally {
            if (!bl) {
                this.installListener();
            }
        }
    }

    @Override
    public void setSelectedIndex(int n) {
        this.setSelectedIndex(n, true);
    }

    @Override
    public void setSelectedIndex(int n, boolean bl) {
        if (!bl) {
            this.uninstallListener();
        }
        try {
            this._contentList.setSelectedIndex(n);
            this._contentList.ensureIndexIsVisible(n);
            this._contentList.revalidate();
        }
        finally {
            if (!bl) {
                this.installListener();
            }
        }
    }

    public Color getSelectionBackground() {
        return this._selectionBackground;
    }

    public void setSelectionBackground(Color color) {
        this._selectionBackground = color;
    }

    public Color getSelectionForeground() {
        return this._selectionForeground;
    }

    public void setSelectionForeground(Color color) {
        this._selectionForeground = color;
    }

    public JList getStepsList() {
        return this._contentList;
    }

    @Override
    public boolean isNavigable() {
        return this._navigable;
    }

    @Override
    public void setNavigable(boolean bl) {
        this._navigable = bl;
        if (this._contentList != null) {
            this._contentList.setEnabled(bl);
        }
    }

    @Override
    public WizardDialogPane getWizardDialogPane() {
        return this._wizardDialogPane;
    }

    @Override
    public void setWizardDialogPane(WizardDialogPane wizardDialogPane) {
        this._wizardDialogPane = wizardDialogPane;
    }

    private static class ContentListModel
    extends AbstractListModel {
        private static final long serialVersionUID = -5777308968687732523L;
        private final List<String> _list;

        public ContentListModel(List<String> list) {
            this._list = list;
        }

        @Override
        public int getSize() {
            return this._list.size();
        }

        @Override
        public Object getElementAt(int n) {
            return this._list.get(n);
        }

        @Override
        public void fireContentsChanged(Object object, int n, int n2) {
            super.fireContentsChanged(object, n, n2);
        }
    }

    private class WrappedCellRenderer
    extends JPanel
    implements ListCellRenderer {
        JLabel _numberedLabel;
        MultilineLabel _title;
        int _titleWidth;
        boolean _contentNumbered;

        private WrappedCellRenderer(boolean bl, int n) {
            super(new BorderLayout(6, 0));
            this._title = new MultilineLabel("");
            this._contentNumbered = bl;
            this._titleWidth = n - 12 - 6;
            this._numberedLabel = new JLabel(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    super.paintComponent(graphics);
                    if (!WrappedCellRenderer.this._contentNumbered) {
                        Rectangle rectangle = graphics.getClipBounds();
                        graphics.fillOval(rectangle.x, rectangle.y, 7, 7);
                    }
                }
            };
            this._numberedLabel.setLabelFor(this._title);
            this._numberedLabel.setHorizontalAlignment(2);
            this._numberedLabel.setVerticalAlignment(1);
            this._numberedLabel.setFont(this._title.getFont());
            this._numberedLabel.setOpaque(false);
            this.add((Component)this._numberedLabel, "West");
            this._titleWidth -= 25;
            Insets insets = this._title.getInsets();
            this._title.setSize(this._titleWidth, insets.top + insets.bottom + 1);
            this.add((Component)this._title, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 8, 2));
            this.setOpaque(false);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (this._contentNumbered) {
                this._numberedLabel.setText(Integer.toString(n + 1) + ".");
            }
            Insets insets = this._title.getInsets();
            this._title.setSize(this._titleWidth, insets.top + insets.bottom + 1);
            this._title.setText((String)object);
            if (jList.getSelectedIndex() == n) {
                this.setForeground(JavaStepsPane.this.getSelectionForeground());
                this.setBackground(JavaStepsPane.this.getSelectionBackground());
                this._title.setFont(this._title.getFont().deriveFont(1));
                this._numberedLabel.setFont(this._numberedLabel.getFont().deriveFont(1));
            } else {
                this.setForeground(JavaStepsPane.this.getForeground());
                this.setBackground(JavaStepsPane.this.getBackground());
                this._title.setFont(this._title.getFont().deriveFont(0));
                this._numberedLabel.setFont(this._numberedLabel.getFont().deriveFont(0));
            }
            this.setOpaque(false);
            return this;
        }

        @Override
        public void setForeground(Color color) {
            super.setForeground(color);
            if (this._numberedLabel != null) {
                this._numberedLabel.setForeground(color);
            }
            if (this._title != null) {
                this._title.setForeground(color);
            }
        }
    }
}

