/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.wizard;

import com.jidesoft.wizard.LeftPane;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;

public class GraphicLeftPane
extends LeftPane {
    protected Image _image;
    protected int _imageWidth;
    protected int _imageHeight;

    public GraphicLeftPane() {
        this((Image)null);
    }

    public GraphicLeftPane(Image image) {
        this._image = image;
        if (image != null) {
            ImageIcon imageIcon = new ImageIcon(image);
            this._imageWidth = imageIcon.getIconWidth();
            this._imageHeight = imageIcon.getIconHeight();
        } else {
            this._imageWidth = 0;
            this._imageHeight = 0;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this._image != null && this._imageWidth > 0 && this._imageHeight > 0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            for (int i = 0; i < n; i += this._imageWidth) {
                for (int j = 0; j < n2; j += this._imageHeight) {
                    graphics.drawImage(this._image, i, j, this._imageWidth, this._imageHeight, this.getBackground(), this);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._image != null) {
            return new Dimension(this._imageWidth, this._imageHeight);
        }
        return super.getPreferredSize();
    }
}

