/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.grid.TableHeaderPopupMenuInstaller;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.tree.TreePopupMenuCustomizer;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreePopupMenuInstaller
extends MouseAdapter {
    private JTree _tree;
    public static final String CLIENT_PROPERTY_POPUP_MENU_INSTALLER = "TreePopupMenuInstaller";
    List<TreePopupMenuCustomizer> _customizers;

    public TreePopupMenuInstaller(JTree jTree) {
        this._tree = jTree;
        this.installListeners();
    }

    public void addTreePopupMenuCustomizer(TreePopupMenuCustomizer treePopupMenuCustomizer) {
        if (this._customizers == null) {
            this._customizers = new ArrayList<TreePopupMenuCustomizer>();
        }
        this._customizers.add(treePopupMenuCustomizer);
    }

    public void removeTreePopupMenuCustomizer(TreePopupMenuCustomizer treePopupMenuCustomizer) {
        if (this._customizers != null) {
            this._customizers.remove(treePopupMenuCustomizer);
        }
    }

    public TreePopupMenuCustomizer[] getTreePopupMenuCustomizers() {
        return this._customizers != null ? this._customizers.toArray(new TreePopupMenuCustomizer[this._customizers.size()]) : new TreePopupMenuCustomizer[]{};
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    private void showPopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        if (!(mouseEvent.getComponent() instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)mouseEvent.getComponent();
        JPopupMenu jPopupMenu = this.createPopupMenu();
        TreePath[] treePathArray = this.getTargetTreePath(jTree, mouseEvent.getPoint());
        this.customizeMenuItems(jTree, jPopupMenu, treePathArray);
        if (jPopupMenu.getComponentCount() > 0) {
            JideSwingUtilities.showPopupMenu(jPopupMenu, jTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    protected JPopupMenu createPopupMenu() {
        return new JidePopupMenu();
    }

    protected void customizeMenuItems(JTree jTree, JPopupMenu jPopupMenu, TreePath[] treePathArray) {
        TreePopupMenuCustomizer[] treePopupMenuCustomizerArray;
        for (TreePopupMenuCustomizer treePopupMenuCustomizer : treePopupMenuCustomizerArray = this.getTreePopupMenuCustomizers()) {
            TableHeaderPopupMenuInstaller.addSeparatorIfNecessary(jPopupMenu);
            treePopupMenuCustomizer.customizePopupMenu(jTree, jPopupMenu, treePathArray);
        }
    }

    public void installListeners() {
        if (this._tree != null) {
            this._tree.addMouseListener(this);
        }
        this.updateClientProperty(this._tree, this);
    }

    public void uninstallListeners() {
        if (this._tree != null) {
            this._tree.removeMouseListener(this);
        }
        this.updateClientProperty(this._tree, null);
    }

    public static TreePopupMenuInstaller getTreePopupMenuInstaller(JTree jTree) {
        Object object = jTree.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
        if (object instanceof TreePopupMenuInstaller) {
            return (TreePopupMenuInstaller)object;
        }
        return null;
    }

    private void updateClientProperty(JTree jTree, TreePopupMenuInstaller treePopupMenuInstaller) {
        if (jTree != null) {
            Object object = jTree.getClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER);
            if (object instanceof TreePopupMenuInstaller && object != this) {
                ((TreePopupMenuInstaller)object).uninstallListeners();
            }
            jTree.putClientProperty(CLIENT_PROPERTY_POPUP_MENU_INSTALLER, treePopupMenuInstaller);
        }
    }

    protected TreePath[] getTargetTreePath(JTree jTree, Point point) {
        return jTree.getSelectionPaths();
    }

    public static void addSeparatorIfNecessary(JPopupMenu jPopupMenu) {
        int n = jPopupMenu.getComponentCount();
        if (n > 0 && !(jPopupMenu.getComponent(n - 1) instanceof JSeparator)) {
            jPopupMenu.addSeparator();
        }
    }
}

