/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tree;

import com.jidesoft.filter.Filter;
import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.tree.FilterableTreeModel;
import com.jidesoft.tree.TreeResource;
import com.jidesoft.tree.TreeUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class QuickTreeFilterField
extends QuickFilterField {
    private TreeModel _treeModel;
    private FilterableTreeModel _displayTreeModel;
    private boolean _hideEmptyParentNode = true;
    private boolean _matchesLeafNodeOnly = true;
    private boolean _keepAllChildren = false;
    private JTree _tree;
    boolean _filterAdded = false;
    public static final String PROPERTY_HIDE_EMPTY_PARENT_NODE = "hideEmptyParentNode";
    public static final String PROPERTY_MATCHES_LEAF_NODE_ONLY = "matchesLeafNodeOnly";
    public static final String PROPERTY_KEEP_ALL_CHILDREN = "keepAllChildren";

    public QuickTreeFilterField() {
        this((TreeModel)null);
    }

    public QuickTreeFilterField(TreeModel treeModel) {
        this.setTreeModel(treeModel);
    }

    public boolean isHideEmptyParentNode() {
        return this.getDisplayTreeModel() != null ? this.getDisplayTreeModel().isHideEmptyParentNode() : this._hideEmptyParentNode;
    }

    public void setHideEmptyParentNode(boolean bl) {
        if (this._hideEmptyParentNode != bl) {
            boolean bl2 = this._hideEmptyParentNode;
            this._hideEmptyParentNode = bl;
            if (this.getDisplayTreeModel() != null) {
                this.getDisplayTreeModel().setHideEmptyParentNode(bl);
            }
            this.firePropertyChange(PROPERTY_HIDE_EMPTY_PARENT_NODE, bl2, bl);
        }
    }

    public boolean isMatchesLeafNodeOnly() {
        return this.getDisplayTreeModel() != null ? this.getDisplayTreeModel().isMatchesLeafNodeOnly() : this._matchesLeafNodeOnly;
    }

    public void setMatchesLeafNodeOnly(boolean bl) {
        if (this._matchesLeafNodeOnly != bl || this.getDisplayTreeModel() != null && this.getDisplayTreeModel().isMatchesLeafNodeOnly() != bl) {
            boolean bl2 = this._matchesLeafNodeOnly;
            this._matchesLeafNodeOnly = bl;
            if (this.getDisplayTreeModel() != null) {
                this.getDisplayTreeModel().setMatchesLeafNodeOnly(bl);
            }
            this.firePropertyChange(PROPERTY_MATCHES_LEAF_NODE_ONLY, bl2, bl);
        }
    }

    public boolean isKeepAllChildren() {
        return this.getDisplayTreeModel() != null ? this.getDisplayTreeModel().isKeepAllChildren() : this._keepAllChildren;
    }

    public void setKeepAllChildren(boolean bl) {
        if (this._keepAllChildren != bl || this.getDisplayTreeModel() != null && this.getDisplayTreeModel().isKeepAllChildren() != bl) {
            boolean bl2 = this._keepAllChildren;
            this._keepAllChildren = bl;
            if (this.getDisplayTreeModel() != null) {
                this.getDisplayTreeModel().setKeepAllChildren(bl);
            }
            this.firePropertyChange(PROPERTY_KEEP_ALL_CHILDREN, bl2, bl);
        }
    }

    @Override
    protected JidePopupMenu createContextMenu() {
        JidePopupMenu jidePopupMenu = super.createContextMenu();
        jidePopupMenu.addSeparator();
        JMenuItem jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getTreeResourceString("Filter.matchLeafNodeOnly.text")));
        jMenuItem.setMnemonic(this.getTreeResourceString("Filter.matchLeafNodeOnly.mnemonic").charAt(0));
        jMenuItem.setName("Filter.matchLeafNodeOnly");
        jMenuItem.setSelected(this.isMatchesLeafNodeOnly());
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -2034715900186439555L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickTreeFilterField.this.setMatchesLeafNodeOnly(jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getTreeResourceString("Filter.hideNodesWithoutChildren.text")));
        jMenuItem.setMnemonic(this.getTreeResourceString("Filter.hideNodesWithoutChildren.mnemonic").charAt(0));
        jMenuItem.setName("Filter.hideNodesWithoutChildren");
        jMenuItem.setSelected(this.isHideEmptyParentNode());
        jMenuItem.setEnabled(this.isMatchesLeafNodeOnly());
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -6800754131183791531L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickTreeFilterField.this.setHideEmptyParentNode(jMenuItem.isSelected());
            }
        });
        jMenuItem = jidePopupMenu.add(new JCheckBoxMenuItem(this.getTreeResourceString("Filter.keepAllChildren.text")));
        jMenuItem.setMnemonic(this.getTreeResourceString("Filter.keepAllChildren.mnemonic").charAt(0));
        jMenuItem.setName("Filter.keepAllChildren");
        jMenuItem.setSelected(this.isKeepAllChildren());
        jMenuItem.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 6249781288159248263L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                QuickTreeFilterField.this.setKeepAllChildren(jMenuItem.isSelected());
            }
        });
        return jidePopupMenu;
    }

    @Override
    public void applyFilter(String string) {
        if (this._displayTreeModel != null) {
            Object object;
            if (!this._filterAdded) {
                object = this.getFilter();
                if (object == null) {
                    return;
                }
                this._displayTreeModel.addFilter((Filter)object);
                this._filterAdded = true;
            }
            object = null;
            TreePath[] treePathArray = null;
            if (this.getTree() != null) {
                object = TreeUtils.saveExpansionStateByTreePath(this.getTree());
                treePathArray = TreeUtils.saveSelection(this.getTree());
            }
            this._displayTreeModel.refresh();
            this.adjustMismatchColor(this._displayTreeModel.getChildCount(this._displayTreeModel.getRoot()) != 0);
            if (this.getTree() != null) {
                this.adjustTreeExpansionState(this.getTree(), (Enumeration<TreePath>)object);
                if (treePathArray != null) {
                    TreeUtils.loadSelection(this.getTree(), treePathArray);
                }
            }
        }
    }

    protected void adjustTreeExpansionState(JTree jTree, Enumeration<TreePath> enumeration) {
        if (enumeration != null && jTree != null) {
            TreeUtils.loadExpansionStateByTreePath(jTree, enumeration);
        }
    }

    public void setTreeModel(TreeModel treeModel) {
        if (treeModel != null) {
            this._treeModel = treeModel;
            this._displayTreeModel = this.createDisplayTreeModel(this._treeModel);
            this._displayTreeModel.setFiltersApplied(true);
            if (this._displayTreeModel != null) {
                this._displayTreeModel.setKeepAllChildren(this._keepAllChildren);
                this._displayTreeModel.setHideEmptyParentNode(this._hideEmptyParentNode);
                this._displayTreeModel.setMatchesLeafNodeOnly(this._matchesLeafNodeOnly);
            }
            this._filterAdded = false;
        }
    }

    protected FilterableTreeModel createDisplayTreeModel(TreeModel treeModel) {
        return new FilterableTreeModel(treeModel);
    }

    public TreeModel getTreeModel() {
        return this._treeModel;
    }

    public FilterableTreeModel getDisplayTreeModel() {
        return this._displayTreeModel;
    }

    public JTree getTree() {
        return this._tree;
    }

    public void setTree(JTree jTree) {
        this._tree = jTree;
    }

    protected String getTreeResourceString(String string) {
        return TreeResource.getResourceBundle(this.getLocale()).getString(string);
    }

    static {
        if (!Q.zz(4)) {
            Lm.showInvalidProductMessage(QuickTreeFilterField.class.getName(), 4);
        }
    }
}

