/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class RoundedRectangularShape
implements BalloonShape {
    private int _cornerSize = 18;

    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        int n = dimension.width;
        int n2 = dimension.height;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.getCornerSize(), 0.0f);
        generalPath.lineTo(n - this.getCornerSize() - 1, 0.0f);
        generalPath.curveTo(n - this.getCornerSize() - 1, 0.0f, n - 1, 0.0f, n - 1, this.getCornerSize());
        generalPath.lineTo(n - 1, n2 - this.getCornerSize());
        generalPath.curveTo(n - 1, n2 - this.getCornerSize(), n - 1, n2, n - this.getCornerSize() - 1, n2 - 1);
        generalPath.lineTo(this.getCornerSize(), n2 - 1);
        generalPath.curveTo(this.getCornerSize(), n2 - 1, 0.0f, n2 - 1, 0.0f, n2 - this.getCornerSize());
        generalPath.lineTo(0.0f, this.getCornerSize());
        generalPath.curveTo(0.0f, this.getCornerSize(), 0.0f, 0.0f, this.getCornerSize(), 0.0f);
        generalPath.closePath();
        return generalPath;
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        return new Point(0, dimension.height);
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        return new Insets(this.getCornerSize(), this.getCornerSize(), this.getCornerSize(), this.getCornerSize());
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        Dimension dimension = balloonTip.getBalloonSize();
        return RoundedRectangularShape.getDistance(point, new Rectangle(0, 0, dimension.width, dimension.height), this.getCornerSize());
    }

    public static double getDistance(Point point, Rectangle rectangle, int n) {
        int n2 = point.x;
        int n3 = point.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        double d = n3 < n ? (n2 < n ? Point.distance(n, n, n2, n3) - (double)n : (n2 < n4 - n ? (double)(-n3) : Point.distance(n4 - n, n, n2, n3) - (double)n)) : (n3 < n5 - n ? (n2 < n ? (double)(-n2) : (n2 < n4 - n ? (double)(-n) : (double)(n2 - n4))) : (n3 < n5 ? (n2 < n ? Point.distance(n, n5 - n, n2, n3) - (double)n : (n2 < n4 - n ? (double)(n3 - n5) : Point.distance(n4 - n, n5 - n, n2, n3) - (double)n)) : 0.0));
        return d;
    }

    public int getCornerSize() {
        return this._cornerSize;
    }

    public void setCornerSize(int n) {
        this._cornerSize = n;
    }
}

