/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shapes;

import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;

public class OvalShape
implements BalloonShape {
    @Override
    public Shape createOutline(Dimension dimension, Dimension dimension2) {
        int n = dimension.width;
        int n2 = dimension.height;
        return new Ellipse2D.Double(0.0, 0.0, n - 1, n2 - 1);
    }

    @Override
    public Point getHotSpot(Dimension dimension) {
        return new Point(0, dimension.height);
    }

    @Override
    public Insets getInsets(Dimension dimension) {
        double d = (double)dimension.width / 2.0;
        double d2 = (double)dimension.height / 2.0;
        double d3 = d * Math.sqrt(2.0);
        double d4 = d2 * Math.sqrt(2.0);
        int n = (int)(d3 - d);
        int n2 = (int)(d4 - d2);
        return new Insets(n2, n, n2, n);
    }

    @Override
    public double getEdgeDistance(Point point, BalloonTip balloonTip) {
        double d;
        Dimension dimension = balloonTip.getBalloonSize();
        double d2 = point.x;
        double d3 = point.y;
        if (dimension.width > dimension.height) {
            d3 = d3 * (double)dimension.width / (double)dimension.height;
            d = (double)dimension.width / 2.0;
        } else {
            d2 = d2 * (double)dimension.height / (double)dimension.width;
            d = (double)dimension.height / 2.0;
        }
        double d4 = Point.distance(d2, d3, d, d);
        return (int)(d4 - d);
    }
}

