/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip.shadows;

import com.jidesoft.swing.ShadowFactory;
import com.jidesoft.tooltip.BalloonShape;
import com.jidesoft.tooltip.BalloonTip;
import com.jidesoft.tooltip.ShadowComposite;
import com.jidesoft.tooltip.ShadowSettings;
import com.jidesoft.tooltip.ShadowStyle;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;

public abstract class DropShadow
implements ShadowStyle {
    protected int _yOffset = 40;
    protected int _xOffset = 40;
    protected double _scale = 1.0;

    @Override
    public BufferedImage createShadow(BufferedImage bufferedImage, BalloonTip balloonTip) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        BalloonShape balloonShape = balloonTip.getBalloonShape();
        ShadowSettings shadowSettings = balloonTip.getShadowSettings();
        ShadowComposite shadowComposite = shadowSettings.getShadowComposite();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Point point = new Point((int)((double)j / this._scale), (int)((double)i / this._scale));
                double d = balloonShape.getEdgeDistance(point, balloonTip);
                int n3 = shadowComposite.compose(d);
                bufferedImage.setRGB(j, i, n3);
            }
        }
        ShadowFactory shadowFactory = new ShadowFactory(shadowSettings.getSize(), shadowSettings.getOpacity(), shadowSettings.getColor());
        return shadowFactory.createShadow(bufferedImage);
    }

    @Override
    public Dimension getShadowSize(Dimension dimension) {
        int n = dimension.width;
        int n2 = dimension.height;
        return new Dimension((int)((double)n * this._scale), (int)((double)n2 * this._scale));
    }

    public int getYOffset() {
        return this._yOffset;
    }

    public void setYOffset(int n) {
        this._yOffset = n;
    }

    public int getXOffset() {
        return this._xOffset;
    }

    public void setXOffset(int n) {
        this._xOffset = n;
    }

    public double getScale() {
        return this._scale;
    }

    public void setScale(double d) {
        this._scale = d;
    }
}

