/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.tooltip.ExpandedTip;
import com.jidesoft.tooltip.TableRowExpandedTip;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

public class TableHeaderExpandedTip
extends ExpandedTip<JTableHeader> {
    private Handler _handler = new Handler();

    public TableHeaderExpandedTip(JTableHeader jTableHeader) {
        super(jTableHeader);
        if (((JTableHeader)this._component).getTable() != null && ((JTableHeader)this._component).getTable().getModel() != null) {
            ((JTableHeader)this._component).getTable().getModel().addTableModelListener(this._handler);
        }
        ((JTableHeader)this._component).getTable().addPropertyChangeListener("model", this._handler);
    }

    @Override
    void doHandleSelectionChange(int n, boolean bl) {
        super.doHandleSelectionChange(n, bl);
        ExpandedTip expandedTip = ExpandedTip.getExpandedTip(((JTableHeader)this._component).getTable());
        if (expandedTip instanceof TableRowExpandedTip) {
            ((TableRowExpandedTip)expandedTip).stopHeaderTimer();
        }
    }

    @Override
    public void uninstall() {
        super.uninstall();
        if (this._handler != null) {
            if (((JTableHeader)this._component).getTable().getModel() != null) {
                ((JTableHeader)this._component).getTable().getModel().removeTableModelListener(this._handler);
            }
            ((JTableHeader)this._component).getTable().removePropertyChangeListener("model", this._handler);
        }
    }

    private void updateSelection(JTable jTable) {
        int n = jTable.getSelectedRowCount() == 1 ? jTable.getSelectedRow() : -1;
        this.handleSelectionChange(n);
    }

    @Override
    public Component getComponent(int n) {
        return this._component;
    }

    @Override
    public Rectangle getRowBounds(int n) {
        Rectangle rectangle = ((JTableHeader)this._component).getBounds();
        rectangle.x = 0;
        return rectangle;
    }

    @Override
    public Rectangle getVisibleRect(int n) {
        Rectangle rectangle = ((JTableHeader)this._component).getVisibleRect();
        rectangle.x += ((JTableHeader)this._component).getBounds().x;
        rectangle.y += ((JTableHeader)this._component).getBounds().y;
        return rectangle;
    }

    @Override
    protected Point createToolTipImage(int n, boolean bl) {
        Rectangle rectangle;
        Point point = super.createToolTipImage(n, bl);
        if (point != null && (rectangle = this.getVisibleRect(n)) != null) {
            point.x -= rectangle.x;
            point.y -= rectangle.y;
        }
        return point;
    }

    @Override
    protected void paintTipImage(Graphics2D graphics2D, Component component, Rectangle rectangle, int n, int n2) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.x -= ((JTableHeader)this._component).getBounds().x;
        rectangle2.y -= ((JTableHeader)this._component).getBounds().y;
        super.paintTipImage(graphics2D, component, rectangle2, n, n2);
    }

    @Override
    public int rowAtPoint(Point point) {
        return 0;
    }

    @Override
    protected boolean shouldDrawBorder() {
        return false;
    }

    private class Handler
    implements PropertyChangeListener,
    TableModelListener {
        private Handler() {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TableHeaderExpandedTip.this.updateSelection(((JTableHeader)TableHeaderExpandedTip.this._component).getTable());
                }
            });
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                TableHeaderExpandedTip.this.updateSelection(((JTableHeader)TableHeaderExpandedTip.this._component).getTable());
                if (propertyChangeEvent.getOldValue() != null) {
                    ((TableModel)propertyChangeEvent.getOldValue()).removeTableModelListener(TableHeaderExpandedTip.this._handler);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((TableModel)propertyChangeEvent.getNewValue()).addTableModelListener(TableHeaderExpandedTip.this._handler);
                }
            }
        }
    }
}

