/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tooltip;

import com.jidesoft.navigation.NavigationList;
import com.jidesoft.tooltip.ExpandedTip;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ListExpandedTip
extends ExpandedTip<JList> {
    private Handler _handler = new Handler();

    public ListExpandedTip(JList jList) {
        super(jList);
        ((JList)this._component).getSelectionModel().addListSelectionListener(this._handler);
        if (((JList)this._component).getModel() != null) {
            ((JList)this._component).getModel().addListDataListener(this._handler);
        }
        ((JList)this._component).addPropertyChangeListener("selectionModel", this._handler);
        ((JList)this._component).addPropertyChangeListener("model", this._handler);
    }

    @Override
    public void uninstall() {
        super.uninstall();
        if (this._handler != null) {
            ((JList)this._component).removePropertyChangeListener("model", this._handler);
            ((JList)this._component).removePropertyChangeListener("selectionModel", this._handler);
            if (((JList)this._component).getModel() != null) {
                ((JList)this._component).getModel().removeListDataListener(this._handler);
            }
            ((JList)this._component).getSelectionModel().removeListSelectionListener(this._handler);
        }
    }

    private void updateSelection(JList jList) {
        int n = jList.getSelectedIndices().length == 1 ? jList.getSelectedIndex() : -1;
        this.handleSelectionChange(n);
    }

    @Override
    protected int rowAtPoint(Point point) {
        return ((JList)this._component).locationToIndex(point);
    }

    @Override
    protected Rectangle getRowBounds(int n) {
        Rectangle rectangle = ((JList)this._component).getCellBounds(n, n);
        if (rectangle == null) {
            return null;
        }
        ListCellRenderer listCellRenderer = ((JList)this._component).getCellRenderer();
        if (listCellRenderer == null) {
            return null;
        }
        ListModel listModel = ((JList)this._component).getModel();
        if (n >= listModel.getSize()) {
            return null;
        }
        Component component = listCellRenderer.getListCellRendererComponent((JList)this._component, listModel.getElementAt(n), n, ((JList)this._component).isSelectedIndex(n), ((JList)this._component).hasFocus());
        if (((JList)this._component).getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
            rectangle.x = rectangle.width - component.getPreferredSize().width;
            rectangle.width = component.getPreferredSize().width;
        } else {
            rectangle.width = component.getPreferredSize().width;
        }
        return rectangle;
    }

    @Override
    protected void paintTipImage(Graphics2D graphics2D, Component component, Rectangle rectangle, int n, int n2) {
        boolean bl = false;
        if (component instanceof NavigationList) {
            bl = ((NavigationList)component).isWideSelection();
            ((NavigationList)component).setWideSelection(false);
        }
        super.paintTipImage(graphics2D, component, rectangle, n, n2);
        if (component instanceof NavigationList) {
            ((NavigationList)component).setWideSelection(bl);
        }
    }

    private class Handler
    implements ListSelectionListener,
    PropertyChangeListener,
    ListDataListener {
        private Handler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListExpandedTip.this.updateSelection((JList)ListExpandedTip.this._component);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ListExpandedTip.this.updateSelection((JList)ListExpandedTip.this._component);
            if ("selectionModel".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((ListSelectionModel)propertyChangeEvent.getOldValue()).removeListSelectionListener(this);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((ListSelectionModel)propertyChangeEvent.getNewValue()).addListSelectionListener(this);
                }
            }
            if ("model".equals(propertyChangeEvent.getPropertyName())) {
                if (propertyChangeEvent.getOldValue() != null) {
                    ((ListModel)propertyChangeEvent.getOldValue()).removeListDataListener(this);
                }
                if (propertyChangeEvent.getNewValue() != null) {
                    ((ListModel)propertyChangeEvent.getNewValue()).addListDataListener(this);
                }
            }
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            ListExpandedTip.this.updateSelection((JList)ListExpandedTip.this._component);
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            ListExpandedTip.this.updateSelection((JList)ListExpandedTip.this._component);
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            ListExpandedTip.this.updateSelection((JList)ListExpandedTip.this._component);
        }
    }
}

