/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.tipoftheday;

import com.jidesoft.tipoftheday.TipOfTheDaySource;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleTipOfTheDaySource
implements TipOfTheDaySource {
    private int currentTipIndex;
    private final ResourceBundle bundle;
    private final String bundleKeyPattern;

    public ResourceBundleTipOfTheDaySource(ResourceBundle resourceBundle) {
        this(resourceBundle, "{0}");
    }

    public ResourceBundleTipOfTheDaySource(ResourceBundle resourceBundle, String string) {
        this.bundle = resourceBundle;
        this.bundleKeyPattern = string;
    }

    @Override
    public int getCurrentTipIndex() {
        return this.currentTipIndex;
    }

    @Override
    public void setCurrentTipIndex(int n) {
        this.currentTipIndex = n;
    }

    @Override
    public String getNextTip() {
        ++this.currentTipIndex;
        String string = this.getTip();
        if (string == null) {
            this.currentTipIndex = 0;
            string = this.getTip();
        }
        return string;
    }

    @Override
    public String getPreviousTip() {
        if (this.currentTipIndex < 1) {
            return null;
        }
        --this.currentTipIndex;
        return this.getTip();
    }

    protected String getTip() {
        Object[] objectArray = new Object[]{this.getCurrentTipIndex()};
        String string = MessageFormat.format(this.bundleKeyPattern, objectArray);
        try {
            String string2 = this.bundle.getString(string);
            return "<html><body>" + string2 + "</body></html>";
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }
}

