/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator
implements Iterator {
    private Iterator[] m_iters;
    private int m_cur;

    public CompositeIterator(int n) {
        this.m_iters = new Iterator[n];
    }

    public CompositeIterator(Iterator iterator, Iterator iterator2) {
        this(new Iterator[]{iterator, iterator2});
    }

    public CompositeIterator(Iterator[] iteratorArray) {
        this.m_iters = iteratorArray;
        this.m_cur = 0;
    }

    public void setIterator(int n, Iterator iterator) {
        this.m_iters[n] = iterator;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public Object next() {
        if (this.hasNext()) {
            return this.m_iters[this.m_cur].next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        if (this.m_iters == null) {
            return false;
        }
        while (true) {
            if (this.m_cur >= this.m_iters.length) {
                this.m_iters = null;
                return false;
            }
            if (this.m_iters[this.m_cur] == null) {
                ++this.m_cur;
                continue;
            }
            if (this.m_iters[this.m_cur].hasNext()) {
                return true;
            }
            ++this.m_cur;
        }
    }
}

