/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util.collections;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ByteArrayList {
    private byte[] m_bytes;
    private int m_size;

    public ByteArrayList() {
        this(4096);
    }

    public ByteArrayList(int n) {
        this.m_bytes = new byte[n];
        this.m_size = 0;
    }

    private void rangeCheck(int n) {
        if (n < 0 || n >= this.m_size) {
            throw new IndexOutOfBoundsException("Index: " + n + " Size: " + this.m_size);
        }
    }

    private void ensureCapacity(int n) {
        if (this.m_bytes.length < n) {
            int n2 = Math.max(3 * this.m_bytes.length / 2 + 1, n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.m_bytes, 0, byArray, 0, this.m_size);
            this.m_bytes = byArray;
        }
    }

    public byte get(int n) {
        this.rangeCheck(n);
        return this.m_bytes[n];
    }

    public void set(int n, byte by) {
        this.rangeCheck(n);
        this.m_bytes[n] = by;
    }

    public int size() {
        return this.m_size;
    }

    public void add(byte by) {
        this.ensureCapacity(this.m_size + 1);
        this.m_bytes[this.m_size++] = by;
    }

    public void add(byte[] byArray, int n, int n2) {
        this.ensureCapacity(this.m_size + n2);
        System.arraycopy(byArray, n, this.m_bytes, this.m_size, n2);
        this.m_size += n2;
    }

    public InputStream getAsInputStream() {
        return new ByteArrayInputStream(this.m_bytes, 0, this.m_size);
    }

    public byte[] toArray() {
        byte[] byArray = new byte[this.m_size];
        System.arraycopy(this.m_bytes, 0, byArray, 0, this.m_size);
        return byArray;
    }
}

