/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import com.jidesoft.thirdparty.prefuse.util.PrefuseConfig;

public class PrefuseLib {
    private static final String GROUP_DELIMITER = PrefuseConfig.get("data.delimiter");
    private static final double SIZE_SCALE_FACTOR = PrefuseConfig.getDouble("size.scale2D");
    public static final String FIELD_PREFIX = PrefuseConfig.get("data.visual.fieldPrefix");

    private PrefuseLib() {
    }

    public static String getMemoryUsageInKB() {
        long l = Runtime.getRuntime().totalMemory() / 2048L;
        long l2 = Runtime.getRuntime().freeMemory() / 2048L;
        long l3 = Runtime.getRuntime().maxMemory() / 2048L;
        return "Memory: " + (l - l2) + "k / " + l + "k / " + l3 + "k";
    }

    public static String getMemoryUsageInMB() {
        long l = Runtime.getRuntime().totalMemory() / 0x200000L;
        long l2 = Runtime.getRuntime().freeMemory() / 0x200000L;
        long l3 = Runtime.getRuntime().maxMemory() / 0x200000L;
        return "Memory: " + (l - l2) + "M / " + l + "M / " + l3 + "M";
    }

    public static double getSize2D(double d) {
        return Math.pow(d, SIZE_SCALE_FACTOR);
    }

    public static boolean isChildGroup(String string) {
        return string.indexOf(GROUP_DELIMITER) != -1;
    }

    public static String getParentGroup(String string) {
        int n = string.lastIndexOf(GROUP_DELIMITER);
        return n < 0 ? null : string.substring(0, n);
    }

    public static String getChildGroup(String string) {
        int n = string.lastIndexOf(GROUP_DELIMITER);
        return n < 0 ? null : string.substring(n + 1);
    }

    public static String getGroupName(String string, String string2) {
        return string + GROUP_DELIMITER + string2;
    }

    public static String getStartField(String string) {
        return string + ":start";
    }

    public static String getEndField(String string) {
        return string + ":end";
    }
}

