/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.util;

import com.jidesoft.thirdparty.prefuse.util.collections.IntObjectHashMap;
import java.awt.Font;

public class FontLib {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;

    public static Font getFont(String string, double d) {
        int n = (int)Math.floor(d);
        return FontLib.getFont(string, 0, n);
    }

    public static Font getFont(String string, int n, double d) {
        int n2 = (int)Math.floor(d);
        return FontLib.getFont(string, n, n2);
    }

    public static Font getFont(String string, int n, int n2) {
        int n3 = (string.hashCode() << 8) + (n2 << 2) + n;
        Font font = null;
        font = (Font)fontMap.get(n3);
        if (font == null) {
            font = new Font(string, n, n2);
            fontMap.put(n3, font);
            ++misses;
        }
        ++lookups;
        return font;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        fontMap.clear();
    }

    public static Font getIntermediateFont(Font font, Font font2, double d) {
        int n;
        String string;
        if (d < 0.5) {
            string = font.getName();
            n = font.getStyle();
        } else {
            string = font2.getName();
            n = font2.getStyle();
        }
        int n2 = (int)Math.round(d * (double)font2.getSize() + (1.0 - d) * (double)font.getSize());
        return FontLib.getFont(string, n, n2);
    }
}

