/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data.column;

import com.jidesoft.thirdparty.prefuse.data.DataTypeException;
import com.jidesoft.thirdparty.prefuse.data.Table;
import com.jidesoft.thirdparty.prefuse.data.column.BooleanColumn;
import com.jidesoft.thirdparty.prefuse.data.column.Column;
import com.jidesoft.thirdparty.prefuse.data.column.ConstantColumn;
import com.jidesoft.thirdparty.prefuse.data.column.DoubleColumn;
import com.jidesoft.thirdparty.prefuse.data.column.ExpressionColumn;
import com.jidesoft.thirdparty.prefuse.data.column.FloatColumn;
import com.jidesoft.thirdparty.prefuse.data.column.IntColumn;
import com.jidesoft.thirdparty.prefuse.data.column.LongColumn;
import com.jidesoft.thirdparty.prefuse.data.column.ObjectColumn;
import com.jidesoft.thirdparty.prefuse.data.expression.Expression;

public class ColumnFactory {
    public static final Column getColumn(Class clazz) {
        return ColumnFactory.getColumn(clazz, 0, 0, null);
    }

    public static final Column getColumn(Class clazz, int n) {
        return ColumnFactory.getColumn(clazz, n, n, null);
    }

    public static final Column getColumn(Class clazz, int n, Object object) {
        return ColumnFactory.getColumn(clazz, n, n, object);
    }

    public static final Column getColumn(Class clazz, int n, int n2, Object object) {
        if (clazz == Integer.TYPE) {
            if (object == null) {
                return new IntColumn(n);
            }
            int n3 = (Integer)object;
            return new IntColumn(n, n, n3);
        }
        if (clazz == Long.TYPE) {
            if (object == null) {
                return new LongColumn(n);
            }
            long l = (Long)object;
            return new LongColumn(n, n, l);
        }
        if (clazz == Float.TYPE) {
            if (object == null) {
                return new FloatColumn(n);
            }
            float f = ((Float)object).floatValue();
            return new FloatColumn(n, n, f);
        }
        if (clazz == Double.TYPE) {
            if (object == null) {
                return new DoubleColumn(n);
            }
            double d = (Double)object;
            return new DoubleColumn(n, n, d);
        }
        if (clazz == Boolean.TYPE) {
            if (object == null) {
                return new BooleanColumn(n);
            }
            boolean bl = (Boolean)object;
            return new BooleanColumn(n, n, bl);
        }
        if (clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Character.TYPE || clazz == Void.TYPE) {
            throw new DataTypeException(clazz);
        }
        return new ObjectColumn(clazz, n, n, object);
    }

    public static final Column getColumn(Table table, Expression expression) {
        return new ExpressionColumn(table, expression);
    }

    public static final Column getConstantColumn(Class clazz, Object object) {
        return new ConstantColumn(clazz, object);
    }
}

