/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.thirdparty.prefuse.data;

import com.jidesoft.thirdparty.prefuse.data.Table;
import java.util.HashMap;

public class Schema
implements Cloneable {
    private String[] m_names;
    private Class[] m_types;
    private Object[] m_dflts;
    private HashMap m_lookup;
    private int m_size;
    private boolean m_locked;

    public Schema() {
        this(10);
    }

    public Schema(int n) {
        this.m_names = new String[n];
        this.m_types = new Class[n];
        this.m_dflts = new Object[n];
        this.m_size = 0;
        this.m_locked = false;
    }

    public Schema(String[] stringArray, Class[] classArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i], classArray[i], null);
        }
    }

    public Schema(String[] stringArray, Class[] classArray, Object[] objectArray) {
        this(stringArray.length);
        if (stringArray.length != classArray.length || classArray.length != objectArray.length) {
            throw new IllegalArgumentException("Input arrays should be the same length");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addColumn(stringArray[i], classArray[i], objectArray[i]);
        }
    }

    public Object clone() {
        return new Schema(this.m_names, this.m_types, this.m_dflts);
    }

    protected void initLookup() {
        this.m_lookup = new HashMap();
        for (int i = 0; i < this.m_names.length; ++i) {
            this.m_lookup.put(this.m_names[i], new Integer(i));
        }
    }

    public Schema lockSchema() {
        this.m_locked = true;
        return this;
    }

    public boolean isLocked() {
        return this.m_locked;
    }

    public void addColumn(String string, Class clazz) {
        this.addColumn(string, clazz, null);
    }

    public void addColumn(String string, Class clazz, Object object) {
        int n;
        if (this.m_locked) {
            throw new IllegalStateException("Can not add column to a locked Schema.");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null column names are not allowed.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Null column types are not allowed.");
        }
        for (n = 0; n < this.m_size; ++n) {
            if (!this.m_names[n].equals(string)) continue;
            throw new IllegalArgumentException("Duplicate column names are not allowed: " + this.m_names[n]);
        }
        if (this.m_names.length == this.m_size) {
            n = 3 * this.m_names.length / 2 + 1;
            String[] stringArray = new String[n];
            Class[] classArray = new Class[n];
            Object[] objectArray = new Object[n];
            System.arraycopy(this.m_names, 0, stringArray, 0, this.m_size);
            System.arraycopy(this.m_types, 0, classArray, 0, this.m_size);
            System.arraycopy(this.m_dflts, 0, objectArray, 0, this.m_size);
            this.m_names = stringArray;
            this.m_types = classArray;
            this.m_dflts = objectArray;
        }
        this.m_names[this.m_size] = string;
        this.m_types[this.m_size] = clazz;
        this.m_dflts[this.m_size] = object;
        if (this.m_lookup != null) {
            this.m_lookup.put(string, new Integer(this.m_size));
        }
        ++this.m_size;
    }

    public int getColumnCount() {
        return this.m_size;
    }

    public String getColumnName(int n) {
        return this.m_names[n];
    }

    public int getColumnIndex(String string) {
        Integer n;
        if (this.m_lookup == null) {
            this.initLookup();
        }
        return (n = (Integer)this.m_lookup.get(string)) == null ? -1 : n;
    }

    public Class getColumnType(int n) {
        return this.m_types[n];
    }

    public Class getColumnType(String string) {
        int n = this.getColumnIndex(string);
        return n < 0 ? null : this.m_types[n];
    }

    public Object getDefault(int n) {
        return this.m_dflts[n];
    }

    public Object getDefault(String string) {
        int n = this.getColumnIndex(string);
        return n < 0 ? null : this.m_dflts[n];
    }

    public void setDefault(int n, Object object) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        this.m_dflts[n] = object;
    }

    public void setDefault(String string, Object object) {
        if (this.m_locked) {
            throw new IllegalStateException("Can not update default values of a locked Schema.");
        }
        int n = this.getColumnIndex(string);
        this.m_dflts[n] = object;
    }

    public void setDefault(String string, int n) {
        this.setDefault(string, (Object)new Integer(n));
    }

    public void setDefault(String string, long l) {
        this.setDefault(string, (Object)new Long(l));
    }

    public void setDefault(String string, float f) {
        this.setDefault(string, (Object)new Float(f));
    }

    public void setDefault(String string, double d) {
        this.setDefault(string, (Object)new Double(d));
    }

    public void setDefault(String string, boolean bl) {
        this.setDefault(string, (Object)(bl ? Boolean.TRUE : Boolean.FALSE));
    }

    public boolean equals(Object object) {
        if (!(object instanceof Schema)) {
            return false;
        }
        Schema schema = (Schema)object;
        if (this.m_size != schema.getColumnCount()) {
            return false;
        }
        for (int i = 0; i < this.m_size; ++i) {
            if (this.m_names[i].equals(schema.getColumnName(i)) && this.m_types[i].equals(schema.getColumnType(i)) && this.m_dflts[i].equals(schema.getDefault(i))) continue;
            return false;
        }
        return true;
    }

    public boolean isAssignableFrom(Schema schema) {
        int n = schema.getColumnCount();
        if (n > this.m_size) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            int n2 = this.getColumnIndex(schema.getColumnName(i));
            if (n2 < 0) {
                return false;
            }
            if (this.m_types[n2].equals(schema.getColumnType(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 0;
        for (int i = 0; i < this.m_size; ++i) {
            int n2 = i + 1;
            int n3 = n2 * this.m_names[i].hashCode();
            n3 ^= n2 * this.m_types[i].hashCode();
            if (this.m_dflts[i] != null) {
                n3 ^= this.m_dflts[i].hashCode();
            }
            n ^= n3;
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Schema[");
        for (int i = 0; i < this.m_size; ++i) {
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('(').append(this.m_names[i]).append(", ");
            stringBuffer.append(this.m_types[i].getName()).append(", ");
            stringBuffer.append(this.m_dflts[i]).append(')');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public Table instantiate() {
        return this.instantiate(0);
    }

    public Table instantiate(int n) {
        Table table = new Table(n, this.m_size);
        for (int i = 0; i < this.m_size; ++i) {
            table.addColumn(this.m_names[i], this.m_types[i], this.m_dflts[i]);
        }
        return table;
    }
}

