/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LayoutPersistence;
import com.jidesoft.utils.PersistenceUtilsCallback;
import com.jidesoft.utils.SecurityUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class AbstractLayoutPersistence
implements LayoutPersistence {
    public static final short V2004 = 19;
    public static final short V2005_09 = 20;
    protected short _version = (short)20;
    protected static final String DEFAULT_PROFILE_NAME = "default";
    public static final String PROPERTY_PROFILE_KEY = "profileKey";
    public static final String PROPERTY_USE_PREF = "usePref";
    public static final String PROPERTY_VERSION = "version";
    protected String _profileKey = "profile";
    protected static final int MAX_PREF_BYTE_ARRAY_LENGTH = 6144;
    protected boolean _loadingLayoutData = false;
    protected boolean _useFrameBounds = true;
    protected boolean _useFrameBoundsSet = false;
    protected boolean _useFrameState = true;
    protected boolean _useFrameStateSet = false;
    protected boolean _usePref = true;
    protected static final String LAYOUT_COUNT_STRING = "_count";
    protected final String LAYOUT_POSTFIX = ".layout";
    protected String _layoutDirectory = null;
    private PropertyChangeSupport changeSupport;
    private boolean _xmlFormat = false;
    private PersistenceUtilsCallback.Save _saveCallback = null;
    private PersistenceUtilsCallback.Load _loadCallback = null;
    private String _xmlEncoding = null;
    private String _layoutPersistenceName = null;
    private boolean _needFormatCheck = true;
    private boolean _last = true;

    @Override
    public short getVersion() {
        return this._version;
    }

    @Override
    public void setVersion(short s) {
        this._version = s;
    }

    public String getProfileKey() {
        return this._profileKey;
    }

    @Override
    public void setProfileKey(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("profileKey cannot be null or empty.");
        }
        String string2 = this._profileKey;
        if (!string.equals(string2)) {
            this._profileKey = string;
            this.firePropertyChange(PROPERTY_PROFILE_KEY, string2, string);
        }
    }

    private static void setByteArrayToPref(Preferences preferences, String string, byte[] byArray) {
        if (byArray.length <= 6144) {
            int n = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
            if (n > 1) {
                for (int i = 0; i < n; ++i) {
                    preferences.remove(string + "_" + i);
                }
            }
            preferences.putByteArray(string, byArray);
            preferences.putInt(string + LAYOUT_COUNT_STRING, 1);
        } else {
            int n = preferences.getInt(string + LAYOUT_COUNT_STRING, -99);
            if (n == 0 || n == 1) {
                preferences.remove(string);
            }
            int n2 = byArray.length / 6144 + 1;
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[6144];
            for (int i = 0; i < n2; ++i) {
                if (i != n2 - 1) {
                    byteBuffer.get(byArray2, 0, 6144);
                } else {
                    int n3 = byArray.length - i * 6144;
                    byArray2 = new byte[n3];
                    byteBuffer.get(byArray2, 0, n3);
                }
                preferences.putByteArray(string + "_" + i, byArray2);
            }
            preferences.putInt(string + LAYOUT_COUNT_STRING, n2);
        }
    }

    private static byte[] getByteArrayFromPref(Preferences preferences, String string) {
        int n;
        byte[] byArray = new byte[]{};
        int n2 = preferences.getInt(string + LAYOUT_COUNT_STRING, 0);
        if (n2 == 0 || n2 == 1) {
            return preferences.getByteArray(string, byArray);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2 * 6144);
        for (n = 0; n < n2; ++n) {
            byteBuffer.put(preferences.getByteArray(string + "_" + n, byArray));
        }
        n = byteBuffer.position();
        byte[] byArray2 = new byte[n];
        byteBuffer.position(0);
        byteBuffer.get(byArray2, 0, n);
        return byArray2;
    }

    @Override
    public void loadLayoutData() {
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            this.loadLayoutDataFrom(DEFAULT_PROFILE_NAME);
        }
        finally {
            this._loadingLayoutData = bl;
        }
    }

    @Override
    public boolean isLayoutAvailable(String string) {
        if (this._usePref) {
            Preferences preferences;
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                return false;
            }
            byte[] byArray = AbstractLayoutPersistence.getByteArrayFromPref(preferences.node(this._profileKey), string);
            return byArray.length != 0;
        }
        String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        File file = new File(string2);
        return file.exists();
    }

    @Override
    public List<String> getAvailableLayouts() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._usePref) {
            Preferences preferences;
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                return arrayList;
            }
            try {
                String[] stringArray;
                Preferences preferences2 = preferences.node(this._profileKey);
                for (String string : stringArray = preferences2.keys()) {
                    if (!string.endsWith(LAYOUT_COUNT_STRING)) continue;
                    arrayList.add(string.substring(0, string.length() - LAYOUT_COUNT_STRING.length()));
                }
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
            return arrayList;
        }
        String string = this.getLayoutDirectory() + File.separator;
        File file = new File(string);
        if (!file.exists()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".layout");
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string2 = file2.getName();
                if (!string2.endsWith(".layout")) continue;
                arrayList.add(string2.substring(0, string2.length() - ".layout".length()));
            }
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeLayout(String string) {
        if (this._usePref) {
            Preferences preferences;
            try {
                preferences = Preferences.userRoot();
            }
            catch (AccessControlException accessControlException) {
                return;
            }
            Preferences preferences2 = preferences.node(this._profileKey);
            int n = preferences2.getInt(string + LAYOUT_COUNT_STRING, 0);
            if (n > 1) {
                for (int i = 0; i < n; ++i) {
                    preferences2.remove(string + "_" + i);
                }
            } else {
                preferences2.remove(string);
            }
            preferences2.remove(string + LAYOUT_COUNT_STRING);
            return;
        }
        String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
        try {
            File file = new File(string2);
            if (!file.exists()) {
                return;
            }
            if (!file.delete()) return;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadLayoutDataFrom(String string) {
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            byte[] byArray = new byte[]{};
            if (this._usePref) {
                try {
                    Preferences preferences = Preferences.userRoot();
                    byArray = AbstractLayoutPersistence.getByteArrayFromPref(preferences.node(this._profileKey), string);
                }
                catch (AccessControlException accessControlException) {
                    this.resetToDefault();
                }
            } else {
                String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
                try {
                    File file = new File(string2);
                    if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                        throw new IOException("Cannot open " + string2);
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n = fileInputStream.available();
                    byArray = new byte[n];
                    int n2 = fileInputStream.read(byArray);
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (byArray == null || byArray.length == 0) {
                this.resetToDefault();
            } else {
                this.loadLayoutFrom(new ByteArrayInputStream(byArray));
            }
        }
        finally {
            this._loadingLayoutData = bl;
        }
    }

    @Override
    public boolean isLayoutDataVersionValid(String string) {
        Object object;
        byte[] byArray = new byte[]{};
        if (this._usePref) {
            try {
                object = Preferences.userRoot();
                byArray = AbstractLayoutPersistence.getByteArrayFromPref(((Preferences)object).node(this._profileKey), string);
            }
            catch (AccessControlException accessControlException) {
                this.resetToDefault();
            }
        } else {
            object = this.getLayoutDirectory() + File.separator + string + ".layout";
            try {
                File file = new File((String)object);
                if (!file.exists() && !file.createNewFile()) {
                    return false;
                }
                FileInputStream fileInputStream = new FileInputStream(file);
                int n = fileInputStream.available();
                byArray = new byte[n];
                int n2 = fileInputStream.read(byArray);
                fileInputStream.close();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (byArray == null || byArray.length == 0) {
            return false;
        }
        object = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            short s = ((DataInputStream)object).readShort();
            return this.isVersionCompatible(s);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected boolean isVersionCompatible(int n) {
        return this._version == n || this._version == 20 && n == 19;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadLayoutDataFromFile(String string) {
        boolean bl = this._loadingLayoutData;
        this._loadingLayoutData = true;
        try {
            byte[] byArray = null;
            try {
                File file = new File(string);
                if (file.exists()) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    int n = fileInputStream.available();
                    byArray = new byte[n];
                    int n2 = fileInputStream.read(byArray);
                    fileInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (byArray == null || byArray.length == 0) {
                this.resetToDefault();
            } else {
                this.loadLayoutFrom(new ByteArrayInputStream(byArray));
            }
        }
        finally {
            this._loadingLayoutData = bl;
        }
    }

    @Override
    public void saveLayoutData() {
        if (this._loadingLayoutData) {
            return;
        }
        this.saveLayoutDataAs(DEFAULT_PROFILE_NAME);
    }

    @Override
    public String getLayoutDirectory() {
        if (this._layoutDirectory == null) {
            String string = SecurityUtils.getProperty("user.home", "") + File.separator + "." + this._profileKey;
            File file = new File(string);
            if (!file.isDirectory() && !file.mkdirs()) {
                System.err.println("Failed to create directory: " + string);
            }
            return string;
        }
        return this._layoutDirectory;
    }

    @Override
    public void setLayoutDirectory(String string) {
        this._layoutDirectory = string;
    }

    @Override
    public void saveLayoutDataAs(String string) {
        if (this._loadingLayoutData) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            if (this._usePref) {
                Preferences preferences = Preferences.userRoot();
                AbstractLayoutPersistence.setByteArrayToPref(preferences.node(this._profileKey), string, byteArrayOutputStream.toByteArray());
            } else {
                String string2 = this.getLayoutDirectory() + File.separator + string + ".layout";
                File file = new File(string2);
                if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                    throw new IOException("Cannot open " + string2);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null && iOException.getMessage().startsWith("Cannot open")) {
                System.err.println(iOException.getLocalizedMessage());
            }
            throw new RuntimeException(iOException.getLocalizedMessage(), iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveLayoutDataToFile(String string) {
        block15: {
            if (this._loadingLayoutData) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                this.saveLayoutTo(byteArrayOutputStream);
                File file = new File(string);
                if (!(file.exists() || file.getParentFile().mkdirs() || file.createNewFile())) {
                    throw new IOException("Cannot open " + string);
                }
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                fileOutputStream.write(byteArrayOutputStream.toByteArray());
                fileOutputStream.close();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
            }
            catch (IOException iOException) {
                if (iOException.getMessage() != null && iOException.getMessage().startsWith("Cannot open")) {
                    System.err.println(iOException.getLocalizedMessage());
                    break block15;
                }
                throw new RuntimeException(iOException.getLocalizedMessage(), iOException);
            }
            finally {
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void setLayoutRawData(byte[] byArray) {
        if (byArray == null || byArray.length == 0) {
            this.resetToDefault();
        } else {
            this.loadLayoutFrom(new ByteArrayInputStream(byArray));
        }
    }

    @Override
    public byte[] getLayoutRawData() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.saveLayoutTo(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            System.err.println(iOException.getLocalizedMessage());
            return new byte[0];
        }
    }

    public boolean isUsePref() {
        return this._usePref;
    }

    @Override
    public void setUsePref(boolean bl) {
        boolean bl2 = this._usePref;
        if (bl != bl2) {
            this._usePref = bl;
            this.firePropertyChange(PROPERTY_USE_PREF, bl2, bl);
        }
    }

    @Override
    public void setUseFrameState(boolean bl) {
        this._useFrameState = bl;
        this._useFrameStateSet = true;
    }

    @Override
    public void setUseFrameBounds(boolean bl) {
        this._useFrameBounds = bl;
        this._useFrameBoundsSet = true;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(string);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, object, object2);
    }

    protected void firePropertyChange(String string, boolean bl, boolean bl2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, bl, bl2);
    }

    protected void firePropertyChange(String string, int n, int n2) {
        PropertyChangeSupport propertyChangeSupport = this.changeSupport;
        if (propertyChangeSupport == null) {
            return;
        }
        propertyChangeSupport.firePropertyChange(string, n, n2);
    }

    @Override
    public void loadInitialLayout(String string) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new File(string));
        this.loadInitialLayout(document);
    }

    @Override
    public void loadInitialLayout(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(inputStream);
        this.loadInitialLayout(document);
    }

    protected boolean shouldUseFrameState(boolean bl) {
        if (this._useFrameStateSet) {
            return this._useFrameState;
        }
        return !bl && this.isLast();
    }

    protected boolean shouldUseFrameBounds(boolean bl) {
        if (this._useFrameBoundsSet) {
            return this._useFrameBounds;
        }
        return !bl && this.isLast();
    }

    @Override
    public boolean isLast() {
        return this._last;
    }

    @Override
    public void setLast(boolean bl) {
        this._last = bl;
    }

    public boolean isLoadingLayoutData() {
        return this._loadingLayoutData;
    }

    public void setLoadingLayoutData(boolean bl) {
        this._loadingLayoutData = bl;
    }

    @Override
    public boolean isXmlFormat() {
        return this._xmlFormat;
    }

    @Override
    public void setXmlFormat(boolean bl) {
        this._xmlFormat = bl;
    }

    @Override
    public PersistenceUtilsCallback.Save getSaveCallback() {
        return this._saveCallback;
    }

    @Override
    public void setSaveCallback(PersistenceUtilsCallback.Save save) {
        this._saveCallback = save;
    }

    @Override
    public PersistenceUtilsCallback.Load getLoadCallback() {
        return this._loadCallback;
    }

    @Override
    public void setLoadCallback(PersistenceUtilsCallback.Load load) {
        this._loadCallback = load;
    }

    @Override
    public String getXmlEncoding() {
        return this._xmlEncoding;
    }

    @Override
    public void setXmlEncoding(String string) {
        this._xmlEncoding = string;
    }

    @Override
    public String getLayoutPersistenceName() {
        return this._layoutPersistenceName;
    }

    @Override
    public void setLayoutPersistenceName(String string) {
        this._layoutPersistenceName = string;
    }

    @Override
    public boolean isNeedFormatCheck() {
        return this._needFormatCheck;
    }

    @Override
    public void setNeedFormatCheck(boolean bl) {
        this._needFormatCheck = bl;
    }
}

