/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.status.LabelStatusBarItem;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;

public class TimeStatusBarItem
extends LabelStatusBarItem {
    private DateFormat _textFormat = DateFormat.getTimeInstance();
    private DateFormat _tooltipFormat = DateFormat.getDateInstance();
    private TimeZone _timeZone = TimeZone.getDefault();
    private Locale _locale = Locale.getDefault();
    private Calendar _currentTime;
    private ScheduledExecutorService _worker = null;
    public static final int INTERVAL_SECOND = 1000;
    private int _interval = 1000;

    public TimeStatusBarItem() {
        super("Time");
        this.updateTime();
        this.start();
    }

    @Override
    protected JLabel createLabel() {
        return new JLabel(){

            @Override
            public void validate() {
            }

            @Override
            public void invalidate() {
            }
        };
    }

    protected void updateTime() {
        Date date = this.getDisplayTime();
        if (this._textFormat != null) {
            this.setText(this._textFormat.format(date));
        }
        if (this._tooltipFormat != null) {
            this.setToolTipText(this._tooltipFormat.format(date));
        }
    }

    protected Date getDisplayTime() {
        if (this._currentTime == null) {
            this._currentTime = Calendar.getInstance(this._timeZone, this._locale);
        } else {
            this._currentTime.setTimeInMillis(System.currentTimeMillis());
        }
        return this._currentTime.getTime();
    }

    @Deprecated
    public void setUpdateInterval(int n) {
    }

    public int getUpdateInterval() {
        return this._interval;
    }

    public void setTextFormat(DateFormat dateFormat) {
        this._textFormat = dateFormat != null ? dateFormat : DateFormat.getTimeInstance();
        this.updateTime();
    }

    public void setTooltipFormat(DateFormat dateFormat) {
        this._tooltipFormat = dateFormat;
        this.updateTime();
    }

    public void stop() {
        if (this._worker != null && !this._worker.isShutdown()) {
            this._worker.shutdown();
        }
        this._worker = null;
    }

    public void start() {
        this.stop();
        this._worker = Executors.newScheduledThreadPool(3);
        int n = this.getUpdateInterval();
        this._worker.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimeStatusBarItem.this.updateTime();
            }
        }, 0L, n, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.start();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.stop();
    }

    @Deprecated
    protected Thread createUpdateThread() {
        return null;
    }
}

