/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.converter.DateConverter;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.status.Resource;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.NullButton;
import com.jidesoft.swing.NullLabel;
import com.jidesoft.swing.NullPanel;
import com.jidesoft.utils.PortingUtils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Calendar;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class ProgressStatusBarItem
extends StatusBarItem {
    public JidePopup _popup;
    private JLabel _statusLabel;
    private JLabel _progressLabel;
    private JProgressBar _progressBar;
    private AbstractButton _cancelButton;
    private CancelCallback _callback;
    private String _defaultStatus = null;
    private String _cancelText = null;
    private final String STATUS = "Status";
    private final String PROGRESS = "Progress";
    private Vector<String> _history;
    private int _maxNumberOfHistoryItems = 10;

    public ProgressStatusBarItem() {
        this.setLayout(new CardLayout());
        this.add(this.createStatusPanel(), "Status");
        this.add(this.createProcessPanel(), "Progress");
        this.showStatus();
        this._history = new Vector();
    }

    public void showStatus() {
        ((CardLayout)this.getLayout()).show(this, "Status");
    }

    public void showProgress() {
        ((CardLayout)this.getLayout()).show(this, "Progress");
    }

    private Component createProcessPanel() {
        NullPanel nullPanel = new NullPanel();
        this._callback = null;
        nullPanel.setLayout(new BorderLayout(3, 0));
        this._progressLabel = this.createProgressLabel();
        this._progressLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this._progressBar = this.createProgressBar();
        this._cancelButton = this.createCancelButton();
        NullPanel nullPanel2 = new NullPanel(new BorderLayout(0, 0));
        nullPanel2.setBorder(new EmptyBorder(3, 3, 3, 3));
        nullPanel2.add((Component)this._progressBar, "Center");
        NullPanel nullPanel3 = new NullPanel(new BorderLayout(3, 0));
        nullPanel3.add((Component)this._progressLabel, "Before");
        nullPanel3.add((Component)nullPanel2, "Center");
        nullPanel.add((Component)nullPanel3, "Center");
        if (this._cancelButton != null) {
            nullPanel.add((Component)this._cancelButton, "After");
        }
        this.setCancelCallback(null);
        return nullPanel;
    }

    protected JLabel createProgressLabel() {
        return new NullLabel();
    }

    protected JProgressBar createProgressBar() {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setMaximum(100);
        return jProgressBar;
    }

    @Override
    @Deprecated
    public void setPreferredWidth(int n) {
        super.setPreferredWidth(n);
    }

    protected AbstractButton createCancelButton() {
        NullButton nullButton = new NullButton(this.getCancelText());
        nullButton.setOpaque(false);
        nullButton.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        nullButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ProgressStatusBarItem.this.getCancelCallback() != null) {
                    ProgressStatusBarItem.this.getCancelCallback().cancelPerformed();
                }
            }
        });
        PortingUtils.removeFocus(nullButton);
        return nullButton;
    }

    protected Component createStatusPanel() {
        this._statusLabel = new NullLabel();
        this._statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
        this._statusLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (ProgressStatusBarItem.this._popup != null && ProgressStatusBarItem.this._popup.isVisible()) {
                    ProgressStatusBarItem.this._popup.hidePopup();
                    ProgressStatusBarItem.this._popup = null;
                } else if (ProgressStatusBarItem.this.getMaxNumberOfHistoryItems() != 0 && ProgressStatusBarItem.this._history.size() > 1) {
                    ProgressStatusBarItem.this._popup = JidePopupFactory.getSharedInstance().createPopup();
                    JList jList = new JList(ProgressStatusBarItem.this._history){

                        @Override
                        public Dimension getPreferredScrollableViewportSize() {
                            Dimension dimension = super.getPreferredScrollableViewportSize();
                            dimension.width = ProgressStatusBarItem.this._statusLabel.getWidth() - 2;
                            return dimension;
                        }
                    };
                    jList.setBackground(UIDefaultsLookup.getColor("control"));
                    jList.setVisibleRowCount(Math.min(10, ProgressStatusBarItem.this._history.size()));
                    JideScrollPane jideScrollPane = new JideScrollPane(jList);
                    jideScrollPane.setBorder(BorderFactory.createEmptyBorder());
                    JPanel jPanel = new JPanel(new BorderLayout(2, 2));
                    jPanel.add(jideScrollPane);
                    JideButton jideButton = new JideButton(new AbstractAction(Resource.getResourceBundle(ProgressStatusBarItem.this.getLocale()).getString("StatusBar.clearHistory")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            ProgressStatusBarItem.this.clearHistory();
                            ProgressStatusBarItem.this._popup.hidePopupImmediately();
                        }
                    });
                    jideButton.setButtonStyle(3);
                    jPanel.add((Component)JideSwingUtilities.createRightPanel(jideButton), "Last");
                    ProgressStatusBarItem.this._popup.add(jPanel);
                    ProgressStatusBarItem.this._popup.showPopup(ProgressStatusBarItem.this._statusLabel);
                }
            }
        });
        return this._statusLabel;
    }

    public void setStatus(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.statusChanged(string);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.statusChanged(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    protected void statusChanged(String string) {
        this.showStatus();
        this._statusLabel.setText(string);
        this._statusLabel.setToolTipText(string);
        if (string != null && string.trim().length() > 0) {
            this._history.add(0, ObjectConverterManager.toString(Calendar.getInstance(), Calendar.class, DateConverter.DATETIME_CONTEXT) + " " + string);
            if (this.getMaxNumberOfHistoryItems() != -1 && this._history.size() > this.getMaxNumberOfHistoryItems()) {
                this._history.remove(this._history.size() - 1);
            }
        }
    }

    public void clearHistory() {
        if (this._history != null) {
            this._history.clear();
        }
    }

    public void setStatusIcon(final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showStatus();
            this._statusLabel.setIcon(icon);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showStatus();
                    ProgressStatusBarItem.this._statusLabel.setIcon(icon);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgressStatus(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this._progressLabel.setText(string);
            this._progressLabel.setToolTipText(string);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this._progressLabel.setText(string);
                    ProgressStatusBarItem.this._progressLabel.setToolTipText(string);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgressIcon(final Icon icon) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this._progressLabel.setIcon(icon);
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this._progressLabel.setIcon(icon);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setProgress(final int n) {
        if (n < 0 || n > 100) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.showProgress();
            this._progressBar.setValue(n);
            this._progressBar.updateUI();
            if (n == 100) {
                this.showStatus();
                this.setStatus(this.getDefaultStatus());
            }
        } else {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ProgressStatusBarItem.this.showProgress();
                    ProgressStatusBarItem.this._progressBar.setValue(n);
                    ProgressStatusBarItem.this._progressBar.updateUI();
                    if (n == 100) {
                        ProgressStatusBarItem.this.showStatus();
                        ProgressStatusBarItem.this.setStatus(ProgressStatusBarItem.this.getDefaultStatus());
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void setCancelCallback(CancelCallback cancelCallback) {
        if (cancelCallback == null) {
            this._cancelButton.setVisible(false);
        } else {
            this._cancelButton.setVisible(true);
        }
        this._callback = cancelCallback;
    }

    public CancelCallback getCancelCallback() {
        return this._callback;
    }

    public String getDefaultStatus() {
        return this._defaultStatus != null ? this._defaultStatus : Resource.getResourceBundle(this.getLocale()).getString("StatusBar.ready");
    }

    public void setDefaultStatus(String string) {
        this._defaultStatus = string;
    }

    @Override
    public String getItemName() {
        return "Status";
    }

    public String getCancelText() {
        return this._cancelText != null ? this._cancelText : Resource.getResourceBundle(this.getLocale()).getString("StatusBar.cancel");
    }

    public void setCancelText(String string) {
        this._cancelText = string;
        if (this._cancelButton != null) {
            this._cancelButton.setText(this._cancelText);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(200, super.getPreferredSize().height);
    }

    public void setIndeterminate(boolean bl) {
        this._progressBar.setIndeterminate(bl);
    }

    public void setProgressBarWidth(int n) {
        this._progressBar.setMaximumSize(new Dimension(n, this._progressBar.getPreferredSize().height));
    }

    public JProgressBar getProgressBar() {
        return this._progressBar;
    }

    public AbstractButton getCancelButton() {
        return this._cancelButton;
    }

    public JLabel getProgressLabel() {
        return this._progressLabel;
    }

    public JLabel getStatusLabel() {
        return this._statusLabel;
    }

    public int getMaxNumberOfHistoryItems() {
        return this._maxNumberOfHistoryItems;
    }

    public void setMaxNumberOfHistoryItems(int n) {
        this._maxNumberOfHistoryItems = n;
    }

    public static interface CancelCallback {
        public void cancelPerformed();
    }
}

