/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.status;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2007.Office2007Painter;
import com.jidesoft.status.Resource;
import com.jidesoft.status.StatusBarItem;
import com.jidesoft.status.StatusBarSeparator;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;

public class MemoryStatusBarItem
extends StatusBarItem {
    private final Color DEFAULT_COLOR = new Color(236, 233, 176);
    private final Icon DEFAULT_ICON = IconsFactory.getImageIcon(MemoryStatusBarItem.class, "icons/gc.gif");
    private static final String PROPERTY_SHOW_MAX_MEMORY = "showMaxMemory";
    private Color _fillColor;
    private Icon _gcIcon;
    private boolean _showMaxMemory = false;
    protected JComponent _statusArea;
    protected AbstractButton _button;
    protected JPanel _buttonPanel;
    private int _interval = 2000;
    private Timer _timer;

    public MemoryStatusBarItem() {
        this.setLayout(new BorderLayout(0, 0));
        this._statusArea = new MemoryArea();
        this._statusArea.setFont(null);
        this._statusArea.setOpaque(false);
        this._statusArea.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    MemoryStatusBarItem.this._button.doClick();
                }
            }
        });
        this._button = this.createButton();
        PortingUtils.removeFocus(this._button);
        PortingUtils.removeButtonBorder(this._button);
        this._button.setOpaque(false);
        this._button.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -1766810895595638575L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                System.gc();
                MemoryStatusBarItem.this._statusArea.repaint();
            }
        });
        this.add((Component)this._statusArea, "Center");
        this._buttonPanel = new JPanel(new BorderLayout());
        if (SystemInfo.isMacOSX()) {
            this._buttonPanel.add((Component)this._button, "Before");
            this._buttonPanel.add((Component)new StatusBarSeparator(), "After");
            this.add((Component)this._buttonPanel, "Before");
        } else {
            this._buttonPanel.add((Component)new StatusBarSeparator(), "Before");
            this._buttonPanel.add((Component)this._button, "After");
            this.add((Component)this._buttonPanel, "After");
        }
        ToolTipManager.sharedInstance().registerComponent(this._statusArea);
        this._timer = new Timer(this._interval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryStatusBarItem.this._statusArea.repaint();
            }
        });
        this._timer.start();
    }

    protected AbstractButton createButton() {
        JButton jButton = new JButton(this.DEFAULT_ICON){

            @Override
            public Point getToolTipLocation(MouseEvent mouseEvent) {
                if (SystemInfo.isJdk6Above()) {
                    return super.getToolTipLocation(mouseEvent);
                }
                Point point = this.getLocation();
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                point.y += this.getHeight() - fontMetrics.getHeight();
                return point;
            }
        };
        jButton.setToolTipText(Resource.getResourceBundle(this.getLocale()).getString("Memory.rungc"));
        jButton.setFont(null);
        return jButton;
    }

    protected long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    protected long getMaxMemory() {
        return Runtime.getRuntime().maxMemory();
    }

    protected long getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public String formatText(long l, long l2, long l3) {
        return MessageFormat.format(Resource.getResourceBundle(this.getLocale()).getString("Memory.usageText"), Long.toString((l - l2) / 0x100000L), Long.toString((this.isShowMaxMemory() ? l3 : l) / 0x100000L));
    }

    protected String formatTooltip(long l, long l2, long l3) {
        return MessageFormat.format(Resource.getResourceBundle(this.getLocale()).getString(this.isShowMaxMemory() ? "Memory.usageTooltipMax" : "Memory.usageTooltip"), Long.toString((this.isShowMaxMemory() ? l3 : l2) / 0x100000L), Long.toString((l2 - l) / 0x100000L));
    }

    @Override
    public String getItemName() {
        return "Memory";
    }

    public Color getFillColor() {
        if (this._fillColor == null) {
            Color color = UIDefaultsLookup.getColor("MemoryStatusBarItem.fillColor");
            return color == null ? this.DEFAULT_COLOR : color;
        }
        return this._fillColor;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this._button != null) {
            PortingUtils.removeButtonBorder(this._button);
        }
    }

    public void setFillColor(Color color) {
        this._fillColor = color;
    }

    public Icon getGcIcon() {
        if (this._gcIcon == null) {
            return this.DEFAULT_ICON;
        }
        return this._gcIcon;
    }

    public void setGcIcon(Icon icon) {
        this._gcIcon = icon;
        if (this._gcIcon != null) {
            this._button.setIcon(this._gcIcon);
        }
    }

    public void setUpdateInterval(int n) {
        this._timer.stop();
        this._interval = n;
        this._timer.setDelay(n);
        this._timer.start();
    }

    public int getUpdateInterval() {
        return this._interval;
    }

    public void start() {
        this._timer.start();
    }

    public void stop() {
        this._timer.stop();
    }

    @Override
    public int getPreferredWidth() {
        long l = this.getTotalMemory();
        String string = this.formatText(l, l, l);
        if (this.getGraphics() != null) {
            return 40 + this.getGraphics().getFontMetrics().stringWidth(string) + this._button.getPreferredSize().width;
        }
        return 80;
    }

    public boolean isShowMaxMemory() {
        return this._showMaxMemory;
    }

    public void setShowMaxMemory(boolean bl) {
        boolean bl2 = this._showMaxMemory;
        if (bl2 != bl) {
            this._showMaxMemory = bl;
            this.firePropertyChange(PROPERTY_SHOW_MAX_MEMORY, bl2, this._showMaxMemory);
        }
    }

    class MemoryArea
    extends JComponent {
        MemoryArea() {
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Dimension dimension = MemoryStatusBarItem.this._statusArea.getSize();
            long l = MemoryStatusBarItem.this.getFreeMemory();
            long l2 = MemoryStatusBarItem.this.getTotalMemory();
            long l3 = MemoryStatusBarItem.this.getMaxMemory();
            int n = dimension.width;
            int n2 = (int)((long)n * (l2 - l) / (MemoryStatusBarItem.this.isShowMaxMemory() ? l3 : l2));
            int n3 = dimension.height;
            Color color = MemoryStatusBarItem.this.getFillColor();
            ThemePainter themePainter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
            if (this.isOpaque() && !(themePainter instanceof Office2007Painter)) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, n, n3);
            }
            if (themePainter != null) {
                themePainter.fillBackground(this, graphics, new Rectangle(0, 1, n2, n3 - 2), 0, 0, color);
            } else {
                graphics.setColor(color);
                graphics.fillRect(0, 1, n2, n3 - 2);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, 1, n2, n3 - 2);
            graphics.setColor(this.getForeground());
            String string = MemoryStatusBarItem.this.formatText(l2, l, l3);
            int n4 = graphics.getFontMetrics().stringWidth(string);
            graphics.setFont(this.getFont());
            Rectangle rectangle = new Rectangle();
            Insets insets = new Insets(0, 0, 0, 0);
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width = n2 - (insets.left + insets.right);
            rectangle.height = n3 - (insets.top + insets.bottom);
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            SwingUtilities.layoutCompoundLabel(graphics.getFontMetrics(), string, null, 0, 0, 0, 0, rectangle, rectangle3, rectangle2, 0);
            JideSwingUtilities.drawString(this, graphics, string, 2 + (n - n4) / 2, rectangle2.y + graphics.getFontMetrics().getAscent());
        }

        @Override
        public String getToolTipText() {
            long l = MemoryStatusBarItem.this.getFreeMemory();
            long l2 = MemoryStatusBarItem.this.getTotalMemory();
            long l3 = MemoryStatusBarItem.this.getMaxMemory();
            return MemoryStatusBarItem.this.formatTooltip(l, l2, l3);
        }

        @Override
        public Point getToolTipLocation(MouseEvent mouseEvent) {
            Point point = this.getLocation();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            point.y += this.getHeight() - fontMetrics.getHeight();
            return point;
        }
    }
}

