/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.ShortcutSchema;
import com.jidesoft.shortcut.ShortcutSchemaEvent;
import com.jidesoft.shortcut.ShortcutSchemaListener;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class ShortcutSchemaManager {
    private String _version;
    private List<ShortcutSchema> _shortcutSchema = new Vector<ShortcutSchema>();
    protected EventListenerList _listenerList = new EventListenerList();

    public ShortcutSchemaManager() {
    }

    public ShortcutSchemaManager(ShortcutSchemaManager shortcutSchemaManager) {
        ShortcutSchema[] shortcutSchemaArray;
        for (ShortcutSchema shortcutSchema : shortcutSchemaArray = shortcutSchemaManager.getShortcutSchemas()) {
            this.addShortcutSchema(new ShortcutSchema(shortcutSchema));
        }
        ShortcutSchema[] shortcutSchemaArray2 = this.getShortcutSchemas();
        for (int i = 0; i < shortcutSchemaArray2.length; ++i) {
            ShortcutSchema shortcutSchema;
            ShortcutSchema shortcutSchema2 = shortcutSchemaArray[i];
            shortcutSchema = shortcutSchemaArray2[i];
            if (shortcutSchema2.getParent() == null) continue;
            String string = shortcutSchema2.getParent().getName();
            ShortcutSchema shortcutSchema3 = this.getShortcutSchema(string);
            if (shortcutSchema3 != null) {
                shortcutSchema.setParent(shortcutSchema3);
                continue;
            }
            shortcutSchema.setParent(null);
        }
    }

    public ShortcutSchema[] getShortcutSchemas() {
        return this._shortcutSchema.toArray(new ShortcutSchema[this._shortcutSchema.size()]);
    }

    public void addShortcutSchema(ShortcutSchema shortcutSchema) {
        if (shortcutSchema == null) {
            throw new IllegalArgumentException("The input ShortcutSchema is null.");
        }
        if (this.getShortcutSchema(shortcutSchema.getName()) != null) {
            throw new IllegalArgumentException("ShortcutSchema with \"" + shortcutSchema.getName() + "\" already exists in ShortcutSchemaManager.");
        }
        this._shortcutSchema.add(shortcutSchema);
        this.fireShortcutSchemaChanged(new ShortcutSchemaEvent(this, 9100, shortcutSchema.getName()));
    }

    public String getActiveShortcutSchemaName() {
        for (ShortcutSchema shortcutSchema : this._shortcutSchema) {
            if (!shortcutSchema.isActive()) continue;
            return shortcutSchema.getName();
        }
        if (this._shortcutSchema.size() > 0) {
            ShortcutSchema shortcutSchema = this._shortcutSchema.get(0);
            shortcutSchema.setActive(true);
            return shortcutSchema.getName();
        }
        return null;
    }

    public ShortcutSchema getActiveShortcutSchema() {
        return this.getShortcutSchema(this.getActiveShortcutSchemaName());
    }

    public ShortcutSchema getShortcutSchema(String string) {
        for (ShortcutSchema shortcutSchema : this._shortcutSchema) {
            if (!shortcutSchema.getName().equals(string)) continue;
            return shortcutSchema;
        }
        return null;
    }

    public void setActiveShortcutSchemaName(String string) {
        for (ShortcutSchema shortcutSchema : this._shortcutSchema) {
            if (shortcutSchema.getName().equals(string)) {
                if (shortcutSchema.isActive()) continue;
                shortcutSchema.setActive(true);
                this.fireShortcutSchemaChanged(new ShortcutSchemaEvent(this, 9102, shortcutSchema.getName()));
                continue;
            }
            if (!shortcutSchema.isActive()) continue;
            shortcutSchema.setActive(false);
            this.fireShortcutSchemaChanged(new ShortcutSchemaEvent(this, 9103, shortcutSchema.getName()));
        }
    }

    public void renameSchema(String string, String string2) {
        for (ShortcutSchema shortcutSchema : this._shortcutSchema) {
            if (!shortcutSchema.getName().equals(string)) continue;
            shortcutSchema.setName(string2);
            this.fireShortcutSchemaChanged(new ShortcutSchemaEvent(this, 9104, string));
            break;
        }
    }

    public void removeShortcutSchema(String string) {
        for (ShortcutSchema shortcutSchema : this._shortcutSchema) {
            if (!shortcutSchema.getName().equals(string)) continue;
            this._shortcutSchema.remove(shortcutSchema);
            this.fireShortcutSchemaChanged(new ShortcutSchemaEvent(this, 9101, shortcutSchema.getName()));
            if (!shortcutSchema.isActive() || this._shortcutSchema.size() <= 0) break;
            shortcutSchema = this._shortcutSchema.get(0);
            shortcutSchema.setActive(true);
            break;
        }
    }

    public void clear() {
        this._shortcutSchema.clear();
    }

    public void addShortcutSchemaListener(ShortcutSchemaListener shortcutSchemaListener) {
        this._listenerList.add(ShortcutSchemaListener.class, shortcutSchemaListener);
    }

    public void removeShortcutSchemaListener(ShortcutSchemaListener shortcutSchemaListener) {
        this._listenerList.remove(ShortcutSchemaListener.class, shortcutSchemaListener);
    }

    public ShortcutSchemaListener[] getShortcutSchemaListeners() {
        return (ShortcutSchemaListener[])this._listenerList.getListeners(ShortcutSchemaListener.class);
    }

    public void fireShortcutSchemaChanged(ShortcutSchemaEvent shortcutSchemaEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ShortcutSchemaListener.class) continue;
            ((ShortcutSchemaListener)objectArray[i + 1]).shortcutSchemaChanged(shortcutSchemaEvent);
        }
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String string) {
        this._version = string;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutSchemaManager.class.getName(), 64);
        }
    }
}

