/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutEvent;
import com.jidesoft.shortcut.ShortcutListener;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.event.EventListenerList;

public class ShortcutSchema {
    protected EventListenerList _listenerList = new EventListenerList();
    private ShortcutSchema _parent;
    private boolean _editable = true;
    private String _name;
    private Map<String, List<Shortcut>> _maps = new TreeMap<String, List<Shortcut>>();
    private Map<String, Icon> _iconMaps = new HashMap<String, Icon>();
    private Map<String, String> _descriptionMaps = new HashMap<String, String>();
    private boolean _active;

    public ShortcutSchema() {
    }

    public ShortcutSchema(String string) {
        this.setName(string);
    }

    public ShortcutSchema(ShortcutSchema shortcutSchema) {
        this._editable = shortcutSchema.isEditable();
        this._name = shortcutSchema.getName();
        this._active = shortcutSchema.isActive();
        this._maps.clear();
        List<String> list = shortcutSchema.getLocalShortcutKeys();
        for (String string : list) {
            List<Shortcut> list2 = shortcutSchema.getLocalShortcutsAsList(string);
            if (list2.size() == 0) {
                this.setShortcuts(string, null);
                continue;
            }
            for (Shortcut shortcut : list2) {
                try {
                    this.addShortcut(string, (Shortcut)shortcut.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    cloneNotSupportedException.printStackTrace();
                }
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public Shortcut[] getShortcuts(String string) {
        List<Shortcut> list = this.getShortcutsAsList(string);
        return list == null ? new Shortcut[]{} : list.toArray(new Shortcut[list.size()]);
    }

    private List<Shortcut> getShortcutsAsList(String string) {
        List<Shortcut> list = this.getLocalShortcutsAsList(string);
        if (list == null) {
            return this.getParentShortcutsAsList(string);
        }
        return list;
    }

    public Shortcut[] getLocalShortcuts(String string) {
        List<Shortcut> list = this.getLocalShortcutsAsList(string);
        return list == null ? new Shortcut[]{} : list.toArray(new Shortcut[list.size()]);
    }

    private List<Shortcut> getParentShortcutsAsList(String string) {
        return this._parent != null ? this._parent.getShortcutsAsList(string) : new ArrayList();
    }

    private List<Shortcut> getLocalShortcutsAsList(String string) {
        return this._maps.get(string);
    }

    public void setShortcuts(String string, List<Shortcut> list) {
        this._maps.put(string, list);
        this.fireShortcutAdded(string, null);
    }

    public void clearAllShortcuts() {
        this._maps.clear();
        this.fireShortcutRemoved(null, null);
    }

    public void clearShortcuts(String string) {
        if (this._maps.containsKey(string)) {
            this._maps.remove(string);
            this.fireShortcutRemoved(string, null);
        }
    }

    public void addShortcut(String string, Shortcut shortcut) {
        this.addShortcut(string, shortcut, false);
    }

    public void addShortcut(String string, Shortcut shortcut, boolean bl) {
        this.addShortcut(string, shortcut, bl, false);
    }

    void addShortcut(String string, Shortcut shortcut, boolean bl, boolean bl2) {
        List<Shortcut> list = this._maps.get(string);
        boolean bl3 = false;
        boolean bl4 = false;
        if (list == null) {
            list = new Vector<Shortcut>();
            this._maps.put(string, list);
            bl4 = true;
            bl3 = true;
        }
        if (shortcut == null) {
            return;
        }
        List<Shortcut> list2 = this.getParentShortcutsAsList(string);
        if (!(list.contains(shortcut) || bl3 && list2.contains(shortcut))) {
            if (!bl && bl3) {
                for (Shortcut shortcut2 : list2) {
                    if (shortcut2.isEmpty()) continue;
                    list.add(shortcut2);
                }
            }
            if (!bl2) {
                list.add(shortcut);
            } else {
                list.add(0, shortcut);
            }
            if (this.compare(list2, list)) {
                this._maps.remove(string);
            }
            this.fireShortcutAdded(string, shortcut);
        } else if (bl4) {
            this._maps.remove(string);
        }
    }

    public void removeShortcut(String string, Shortcut shortcut) {
        List<Shortcut> list = this._maps.get(string);
        boolean bl = false;
        if (list != null) {
            if (list.remove(shortcut)) {
                List<Shortcut> list2 = this.getParentShortcutsAsList(string);
                if (this.compare(list2, list)) {
                    this._maps.remove(string);
                }
                bl = true;
            }
        } else {
            List<Shortcut> list3 = this.getParentShortcutsAsList(string);
            list = new Vector<Shortcut>();
            boolean bl2 = false;
            for (Shortcut shortcut2 : list3) {
                if (shortcut2.equals(shortcut)) {
                    bl2 = true;
                    continue;
                }
                list.add(shortcut2);
            }
            if (bl2) {
                this._maps.put(string, list);
                bl = true;
            }
        }
        if (bl) {
            this.fireShortcutRemoved(string, shortcut);
        }
    }

    private boolean compare(List<?> list, List<?> list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (Object obj : list) {
            if (list2.contains(obj)) continue;
            return false;
        }
        return true;
    }

    public ShortcutSchema getParent() {
        return this._parent;
    }

    public void setParent(ShortcutSchema shortcutSchema) {
        this._parent = shortcutSchema;
    }

    public boolean isActive() {
        return this._active;
    }

    void setActive(boolean bl) {
        this._active = bl;
    }

    public List<String> getShortcutKeys() {
        Collection<String> collection;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this._parent != null) {
            collection = this._parent.getShortcutKeys();
            for (String string : collection) {
                arrayList.add(string);
            }
        }
        collection = this._maps.keySet();
        for (String string : collection) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public List<String> getLocalShortcutKeys() {
        Set<String> set = this._maps.keySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : set) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public String toString() {
        if (this.isActive()) {
            return this.getName() + " (active)";
        }
        return this.getName();
    }

    public List<String> findUsages(Shortcut shortcut) {
        List<String> list = this.getShortcutKeys();
        Vector<String> vector = new Vector<String>();
        for (String string : list) {
            List<Shortcut> list2 = this.getShortcutsAsList(string);
            for (Shortcut shortcut2 : list2) {
                if (!shortcut2.equals(shortcut)) continue;
                vector.add(string);
            }
        }
        return vector;
    }

    public List<String> findConflicts(String string, Shortcut shortcut) {
        List<String> list = this.getShortcutKeys();
        Vector<String> vector = new Vector<String>();
        for (String string2 : list) {
            if (string2.equals(string)) continue;
            List<Shortcut> list2 = this.getShortcutsAsList(string2);
            for (Shortcut shortcut2 : list2) {
                if (!shortcut2.equals(shortcut)) continue;
                vector.add(string2 + " " + shortcut2.toString());
            }
        }
        return vector;
    }

    public void removeConflicts(String string, Shortcut shortcut) {
        List<String> list = this.getShortcutKeys();
        for (String string2 : list) {
            Shortcut[] shortcutArray;
            if (string2.equals(string)) continue;
            for (Shortcut shortcut2 : shortcutArray = this.getShortcuts(string2)) {
                if (!shortcut2.equals(shortcut)) continue;
                this.removeShortcut(string2, shortcut2);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ShortcutSchema)) {
            return false;
        }
        ShortcutSchema shortcutSchema = (ShortcutSchema)object;
        return !(this._name == null ? shortcutSchema._name != null : !this._name.equals(shortcutSchema._name));
    }

    public boolean isOverridden(String string) {
        return this.isEditable() && this._parent != null && this._maps.get(string) != null;
    }

    public Icon getCommandIcon(String string) {
        Icon icon = this._iconMaps.get(string);
        if (icon != null) {
            return icon;
        }
        return this._parent != null ? this._parent.getCommandIcon(string) : null;
    }

    public void setCommandIcon(String string, Icon icon) {
        if (icon == null) {
            this.clearCommandIcon(string);
        } else {
            this._iconMaps.put(string, icon);
        }
    }

    public void clearCommandIcon(String string) {
        this._iconMaps.remove(string);
    }

    public void clearAllCommandIcons() {
        this._iconMaps.clear();
    }

    public String getCommandDescription(String string) {
        String string2 = this._descriptionMaps.get(string);
        if (string2 != null) {
            return string2;
        }
        return this._parent != null ? this._parent.getCommandDescription(string) : null;
    }

    public void setCommandDescription(String string, String string2) {
        if (string2 == null) {
            this.clearCommandDescription(string);
        } else {
            this._descriptionMaps.put(string, string2);
        }
    }

    public void clearCommandDescription(String string) {
        this._descriptionMaps.remove(string);
    }

    public void clearAllCommandDescriptions() {
        this._descriptionMaps.clear();
    }

    public void addShortcutListener(ShortcutListener shortcutListener) {
        this._listenerList.add(ShortcutListener.class, shortcutListener);
    }

    public void removeShortcutListener(ShortcutListener shortcutListener) {
        this._listenerList.remove(ShortcutListener.class, shortcutListener);
    }

    public ShortcutListener[] getShortcutListeners() {
        return (ShortcutListener[])this._listenerList.getListeners(ShortcutListener.class);
    }

    public void fireShortcutAdded(String string, Shortcut shortcut) {
        this.fireShortcutChanged(new ShortcutEvent(this, 9000, string, shortcut));
    }

    public void fireShortcutRemoved(String string, Shortcut shortcut) {
        this.fireShortcutChanged(new ShortcutEvent(this, 9001, string, shortcut));
    }

    public void fireShortcutChanged(ShortcutEvent shortcutEvent) {
        Object[] objectArray = this._listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ShortcutListener.class) continue;
            ((ShortcutListener)objectArray[i + 1]).shortcutChanged(shortcutEvent);
        }
    }

    public Iterator<String> getCommands() {
        return this._maps.keySet().iterator();
    }

    public int hashCode() {
        return this._name != null ? this._name.hashCode() : 0;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutSchema.class.getName(), 64);
        }
    }
}

