/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.shortcut;

import com.jidesoft.shortcut.KeyboardShortcut;
import com.jidesoft.shortcut.MouseShortcut;
import com.jidesoft.shortcut.Shortcut;
import com.jidesoft.shortcut.ShortcutSchema;
import com.jidesoft.shortcut.ShortcutSchemaManager;
import com.jidesoft.swing.PersistenceUtils;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ShortcutPersistenceUtils {
    private static final String NODE_KEYMAP = "keymap";
    private static final String NODE_COMMAND = "action";
    private static final String NODE_KEYBOARD_SHORTCUT = "keyboard-shortcut";
    private static final String NODE_MOUSE_SHORTCUT = "mouse-shortcut";
    private static final String ATTRIBUTE_KEYSTROKE = "keystroke";
    private static final String ATTRIBUTE_KEYSTROKE1 = "first-keystroke";
    private static final String ATTRIBUTE_KEYSTROKE2 = "second-keystroke";
    private static final String ATTRIBUTE_KEYSTROKE3 = "third-keystroke";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ACTIVE = "active";
    private static final String ATTRIBUTE_PARENT = "parent";
    private static final String ATTRIBUTE_CONTEXT = "context";
    private static final String ATTRIBUTE_ID = "id";

    public static void save(ShortcutSchemaManager shortcutSchemaManager, String string) throws ParserConfigurationException, IOException {
        ShortcutPersistenceUtils.save(shortcutSchemaManager, string, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(ShortcutSchemaManager shortcutSchemaManager, String string, String string2) throws ParserConfigurationException, IOException {
        Document document = ShortcutPersistenceUtils.save(shortcutSchemaManager);
        PersistenceUtils.saveXMLDocumentToFile(document, string, string2);
    }

    public static void save(ShortcutSchemaManager shortcutSchemaManager, OutputStream outputStream) throws ParserConfigurationException, IOException {
        ShortcutPersistenceUtils.save(shortcutSchemaManager, outputStream, PersistenceUtils.getDefaultXmlEncoding());
    }

    public static void save(ShortcutSchemaManager shortcutSchemaManager, OutputStream outputStream, String string) throws ParserConfigurationException, IOException {
        Document document = ShortcutPersistenceUtils.save(shortcutSchemaManager);
        PersistenceUtils.saveXMLDocumentToStream(document, outputStream, string);
    }

    public static Document save(ShortcutSchemaManager shortcutSchemaManager) throws ParserConfigurationException {
        ShortcutSchema[] shortcutSchemaArray;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component");
        if (shortcutSchemaManager.getVersion() != null) {
            element.setAttribute("version", shortcutSchemaManager.getVersion());
        }
        document.appendChild(element);
        for (ShortcutSchema shortcutSchema : shortcutSchemaArray = shortcutSchemaManager.getShortcutSchemas()) {
            Element element2 = document.createElement(NODE_KEYMAP);
            element.appendChild(element2);
            element2.setAttribute(ATTRIBUTE_NAME, shortcutSchema.getName());
            element2.setAttribute(ATTRIBUTE_ACTIVE, "" + shortcutSchema.isActive());
            if (shortcutSchema.getParent() != null) {
                element2.setAttribute(ATTRIBUTE_PARENT, shortcutSchema.getParent().getName());
            }
            List<String> list = shortcutSchema.getLocalShortcutKeys();
            for (String string : list) {
                Shortcut[] shortcutArray = shortcutSchema.getLocalShortcuts(string);
                Element element3 = document.createElement(NODE_COMMAND);
                element2.appendChild(element3);
                element3.setAttribute(ATTRIBUTE_ID, string);
                for (Shortcut shortcut : shortcutArray) {
                    Shortcut shortcut2;
                    Element element4;
                    if (shortcut instanceof KeyboardShortcut) {
                        KeyStroke[] keyStrokeArray;
                        element4 = document.createElement(NODE_KEYBOARD_SHORTCUT);
                        element3.appendChild(element4);
                        shortcut2 = (KeyboardShortcut)shortcut;
                        if (shortcut.getName() != null) {
                            element4.setAttribute(ATTRIBUTE_NAME, shortcut.getName());
                        }
                        if (shortcut.getContext() != null) {
                            element4.setAttribute(ATTRIBUTE_CONTEXT, shortcut.getContext());
                        }
                        if ((keyStrokeArray = ((KeyboardShortcut)shortcut2).getKeyStrokes()).length > 0) {
                            element4.setAttribute(ATTRIBUTE_KEYSTROKE1, KeyboardShortcut.getKeyStrokeString(keyStrokeArray[0]));
                        }
                        if (keyStrokeArray.length > 1) {
                            element4.setAttribute(ATTRIBUTE_KEYSTROKE2, KeyboardShortcut.getKeyStrokeString(keyStrokeArray[1]));
                        }
                        if (keyStrokeArray.length <= 2) continue;
                        element4.setAttribute(ATTRIBUTE_KEYSTROKE3, KeyboardShortcut.getKeyStrokeString(keyStrokeArray[2]));
                        continue;
                    }
                    if (!(shortcut instanceof MouseShortcut)) continue;
                    element4 = document.createElement(NODE_MOUSE_SHORTCUT);
                    element3.appendChild(element4);
                    shortcut2 = (MouseShortcut)shortcut;
                    if (shortcut.getName() != null) {
                        element4.setAttribute(ATTRIBUTE_NAME, shortcut.getName());
                    }
                    if (shortcut.getContext() != null) {
                        element4.setAttribute(ATTRIBUTE_CONTEXT, shortcut.getContext());
                    }
                    element4.setAttribute(ATTRIBUTE_KEYSTROKE, MouseShortcut.getMouseShortcutString((MouseShortcut)shortcut2));
                }
            }
        }
        return document;
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        ShortcutPersistenceUtils.load(shortcutSchemaManager, inputStream, false);
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, String string) throws ParserConfigurationException, SAXException, IOException {
        ShortcutPersistenceUtils.load(shortcutSchemaManager, string, false);
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, InputStream inputStream, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        ShortcutPersistenceUtils.load(shortcutSchemaManager, PersistenceUtils.getDocument(inputStream), bl);
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, String string, boolean bl) throws ParserConfigurationException, SAXException, IOException {
        ShortcutPersistenceUtils.load(shortcutSchemaManager, PersistenceUtils.getDocument(string), bl);
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, Document document) {
        ShortcutPersistenceUtils.load(shortcutSchemaManager, document, false);
    }

    public static void load(ShortcutSchemaManager shortcutSchemaManager, Document document, boolean bl) {
        if (!bl) {
            shortcutSchemaManager.clear();
        }
        Node node = document.getElementsByTagName("component").item(0);
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = null;
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (!"version".equals(node2.getNodeName())) continue;
            string = node2.getNodeValue();
            break;
        }
        if (string != null) {
            shortcutSchemaManager.setVersion(string);
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            Node node3 = nodeList.item(i);
            if (!NODE_KEYMAP.equals(node3.getNodeName())) continue;
            NamedNodeMap namedNodeMap2 = node3.getAttributes();
            String string2 = null;
            boolean bl2 = false;
            String string3 = null;
            for (int j = 0; j < namedNodeMap2.getLength(); ++j) {
                object = namedNodeMap2.item(j);
                if (ATTRIBUTE_NAME.equals(object.getNodeName())) {
                    string2 = object.getNodeValue();
                    continue;
                }
                if (ATTRIBUTE_ACTIVE.equals(object.getNodeName())) {
                    bl2 = "true".equals(object.getNodeValue());
                    continue;
                }
                if (!ATTRIBUTE_PARENT.equals(object.getNodeName())) continue;
                string3 = object.getNodeValue();
            }
            ShortcutSchema shortcutSchema = new ShortcutSchema(string2);
            shortcutSchema.setActive(bl2);
            if (string3 != null) {
                shortcutSchema.setParent(shortcutSchemaManager.getShortcutSchema(string3));
            }
            object = node3.getChildNodes();
            for (int j = 0; j < object.getLength(); ++j) {
                Object object2;
                Node node4 = object.item(j);
                if (!NODE_COMMAND.equals(node4.getNodeName())) continue;
                NamedNodeMap namedNodeMap3 = node4.getAttributes();
                String string4 = null;
                for (int k = 0; k < namedNodeMap3.getLength(); ++k) {
                    object2 = namedNodeMap3.item(k);
                    if (!ATTRIBUTE_ID.equals(object2.getNodeName())) continue;
                    string4 = object2.getNodeValue();
                }
                Shortcut shortcut = null;
                object2 = node4.getChildNodes();
                if (object2.getLength() == 0) {
                    shortcutSchema.addShortcut(string4, null);
                }
                ArrayList<Shortcut> arrayList = new ArrayList<Shortcut>();
                for (int k = 0; k < object2.getLength(); ++k) {
                    Object object3;
                    Object object4;
                    Shortcut[] shortcutArray;
                    Node node5 = object2.item(k);
                    if (NODE_KEYBOARD_SHORTCUT.equals(node5.getNodeName())) {
                        shortcut = new KeyboardShortcut();
                        shortcutArray = node5.getAttributes();
                        String string5 = null;
                        object4 = null;
                        String string6 = null;
                        object3 = null;
                        for (int i2 = 0; i2 < shortcutArray.getLength(); ++i2) {
                            Node node6 = shortcutArray.item(i2);
                            if (ATTRIBUTE_KEYSTROKE1.equals(node6.getNodeName())) {
                                string5 = node6.getNodeValue();
                                continue;
                            }
                            if (ATTRIBUTE_KEYSTROKE2.equals(node6.getNodeName())) {
                                object4 = node6.getNodeValue();
                                continue;
                            }
                            if (ATTRIBUTE_KEYSTROKE3.equals(node6.getNodeName())) {
                                string6 = node6.getNodeValue();
                                continue;
                            }
                            if (!ATTRIBUTE_CONTEXT.equals(node6.getNodeName())) continue;
                            object3 = node6.getNodeValue();
                        }
                        if (string5 != null) {
                            ((KeyboardShortcut)shortcut).addKeyStroke(KeyboardShortcut.parseKeyStroke(string5));
                        }
                        if (object4 != null) {
                            ((KeyboardShortcut)shortcut).addKeyStroke(KeyboardShortcut.parseKeyStroke((String)object4));
                        }
                        if (string6 != null) {
                            ((KeyboardShortcut)shortcut).addKeyStroke(KeyboardShortcut.parseKeyStroke(string6));
                        }
                        if (object3 != null) {
                            shortcut.setContext((String)object3);
                        }
                        arrayList.add(shortcut);
                    } else if (NODE_MOUSE_SHORTCUT.equals(node5.getNodeName())) {
                        shortcutArray = node5.getAttributes();
                        String string7 = null;
                        object4 = null;
                        for (int i3 = 0; i3 < shortcutArray.getLength(); ++i3) {
                            object3 = shortcutArray.item(i3);
                            if (ATTRIBUTE_KEYSTROKE.equals(object3.getNodeName())) {
                                string7 = object3.getNodeValue();
                                continue;
                            }
                            if (!ATTRIBUTE_CONTEXT.equals(object3.getNodeName())) continue;
                            object4 = object3.getNodeValue();
                        }
                        if (string7 != null) {
                            shortcut = MouseShortcut.parse(string7);
                        }
                        if (object4 != null) {
                            shortcut.setContext((String)object4);
                        }
                        arrayList.add(shortcut);
                    }
                    shortcutArray = shortcutSchema.getLocalShortcuts(string4);
                    if (shortcutArray != null && shortcutArray.length > 0) {
                        for (int i4 = shortcutArray.length - 1; i4 >= 0; --i4) {
                            object4 = shortcutArray[i4];
                            if (arrayList.contains(object4)) continue;
                            arrayList.add(0, (Shortcut)object4);
                        }
                    }
                    shortcutSchema.setShortcuts(string4, arrayList);
                }
            }
            shortcutSchemaManager.addShortcutSchema(shortcutSchema);
        }
    }

    public static String getVersion(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        return ShortcutPersistenceUtils.getVersion(PersistenceUtils.getDocument(inputStream));
    }

    public static String getVersion(String string) throws ParserConfigurationException, SAXException, IOException {
        return ShortcutPersistenceUtils.getVersion(PersistenceUtils.getDocument(string));
    }

    public static String getVersion(Document document) {
        return PersistenceUtils.getVersion(document);
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(64)) {
            Lm.showInvalidProductMessage(ShortcutPersistenceUtils.class.getName(), 64);
        }
    }
}

