/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.search;

import com.jidesoft.search.FindResult;
import com.jidesoft.search.FindResults;
import java.util.EventObject;

public class FindAndReplaceEvent
extends EventObject {
    public static final int SEARCH_STARTED = 0;
    public static final int SEARCH_STARTED_TEXT = 1;
    public static final int SEARCH_FINISHED = 2;
    public static final int SEARCH_FINISHED_TEXT = 3;
    public static final int SEARCH_FOUND = 4;
    public static final int SEARCH_REPLACED = 5;
    private int _status;
    private FindResult _findResult;
    private FindResults _findResults;
    private String _targetName;
    private String _replaceText;

    public FindAndReplaceEvent(Object object, int n) {
        super(object);
        this._status = n;
    }

    public FindAndReplaceEvent(Object object, int n, FindResult findResult) {
        super(object);
        this._status = n;
        this._findResult = findResult;
    }

    public FindAndReplaceEvent(Object object, int n, String string, FindResults findResults) {
        super(object);
        this._status = n;
        this._targetName = string;
        this._findResults = findResults;
    }

    public FindAndReplaceEvent(Object object, int n, FindResults findResults) {
        super(object);
        this._status = n;
        this._findResults = findResults;
    }

    public FindAndReplaceEvent(Object object, int n, String string) {
        super(object);
        this._status = n;
        this._targetName = string;
    }

    public FindAndReplaceEvent(Object object, int n, FindResult findResult, String string) {
        super(object);
        this._status = n;
        this._findResult = findResult;
        this._replaceText = string;
    }

    public int getStatus() {
        return this._status;
    }

    public FindResult getFindResult() {
        return this._findResult;
    }

    public FindResults getFindResults() {
        return this._findResults;
    }

    public String getTargetName() {
        return this._targetName;
    }

    public String getReplaceText() {
        return this._replaceText;
    }

    @Override
    public String toString() {
        switch (this.getStatus()) {
            case 0: {
                return this.getClass().getName() + "[ SEARCH_STARTED ]";
            }
            case 2: {
                return this.getClass().getName() + "[ SEARCH_FINISHED" + (this.getFindResults() != null ? ": found " + this.getFindResults().getNumberOfFindResults() + " usages ]" : " ]");
            }
            case 1: {
                return this.getClass().getName() + "[ SEARCH_STARTED_TEXT: " + this.getTargetName() + "]";
            }
            case 4: {
                return this.getClass().getName() + "[ SEARCH_FOUND: " + this.getFindResult() + "]";
            }
            case 5: {
                return this.getClass().getName() + "[ SEARCH_REPLACED: " + this.getFindResult() + " => " + this.getReplaceText() + "]";
            }
            case 3: {
                return this.getClass().getName() + "[ SEARCH_FINISHED_TEXT" + (this.getFindResults() != null ? ": found " + this.getFindResults().getNumberOfFindResults() + " usages ]" : " ]");
            }
        }
        return super.toString();
    }
}

