/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.search;

import com.jidesoft.search.FindAndReplace;
import com.jidesoft.search.FindAndReplacePanel;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DbVisReplaceHelper {
    private static final Logger LOGGER = Logger.getLogger(DbVisReplaceHelper.class.getName());

    static void setup(FindAndReplacePanel findAndReplacePanel, JComboBox<?> jComboBox, JCheckBox jCheckBox, JRadioButton jRadioButton, JButton jButton, JComboBox<?> jComboBox2, FindAndReplace findAndReplace) {
        jButton.addActionListener(actionEvent -> DbVisReplaceHelper.showPopupMenu(findAndReplacePanel, jComboBox2, findAndReplace));
        jRadioButton.addItemListener(itemEvent -> jButton.setEnabled(jCheckBox.isSelected() && jRadioButton.isSelected()));
        MySearchTextListener mySearchTextListener = new MySearchTextListener(jComboBox, findAndReplace);
        JTextField jTextField = (JTextField)jComboBox.getEditor().getEditorComponent();
        jTextField.getDocument().addDocumentListener(mySearchTextListener);
        jComboBox.addItemListener(mySearchTextListener);
        jComboBox.addActionListener(mySearchTextListener);
    }

    private static void showPopupMenu(FindAndReplacePanel findAndReplacePanel, JComboBox<?> jComboBox, FindAndReplace findAndReplace) {
        boolean bl;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        boolean bl2 = bl = findAndReplacePanel.getTargets() == null || findAndReplacePanel.getTargets().length < 1;
        if (findAndReplace.isUseRegex() && !bl) {
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\", "FindAndReplace.regexHelperBackslash", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\b", "FindAndReplace.regexHelperBackspace", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\f", "FindAndReplace.regexHelperFormFeed", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\n", "FindAndReplace.regexHelperNewLine", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\r", "FindAndReplace.regexHelperCarriageReturn", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\t", "FindAndReplace.regexHelperTab", new Object[0]));
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "\\$", "FindAndReplace.regexHelperDollar", new Object[0]));
            jidePopupMenu.addSeparator();
            jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, "$0", "FindAndReplace.regexHelperGroup0", new Object[0]));
            try {
                int n = findAndReplace.getMatcher().groupCount();
                if (n > 0) {
                    for (int i = 1; i <= n; ++i) {
                        String string = "$" + i;
                        jidePopupMenu.add(DbVisReplaceHelper.createMenuItem(findAndReplacePanel, jComboBox, string, "FindAndReplace.regexHelperGroup", i));
                    }
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                LOGGER.log(Level.FINEST, "Invalid regexp search pattern: " + findAndReplace.getFindText(), patternSyntaxException);
            }
        }
        JideSwingUtilities.showPopupMenu(jidePopupMenu, jComboBox, jComboBox.getWidth(), 2);
    }

    private static JMenuItem createMenuItem(FindAndReplacePanel findAndReplacePanel, JComboBox<?> jComboBox, String string, String string2, Object ... objectArray) {
        String string3 = findAndReplacePanel.getTargets()[0].getResourceString(string2);
        if (objectArray.length > 0) {
            string3 = MessageFormat.format(string3, objectArray);
        }
        return new JMenuItem(findAndReplacePanel.createAction(jComboBox, string, string3));
    }

    private static class MySearchTextListener
    implements DocumentListener,
    ActionListener,
    ItemListener {
        private final JComboBox<?> searchComboBox;
        private final FindAndReplace findAndReplace;

        private MySearchTextListener(JComboBox<?> jComboBox, FindAndReplace findAndReplace) {
            this.searchComboBox = jComboBox;
            this.findAndReplace = findAndReplace;
        }

        private void setPanelFindText() {
            JTextField jTextField = (JTextField)this.searchComboBox.getEditor().getEditorComponent();
            this.findAndReplace.setFindText(jTextField.getText());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.setPanelFindText();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.setPanelFindText();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.setPanelFindText();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.setPanelFindText();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.setPanelFindText();
        }
    }
}

