/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.AbstractPeriodConverter;
import com.jidesoft.scale.DatePeriod;
import com.jidesoft.scale.PeriodConverter;
import com.jidesoft.scale.ScaleArea;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DatePeriodConverter
extends AbstractPeriodConverter<Date> {
    private static final long serialVersionUID = 1491288903053008517L;
    private final DateFormat _labelFormat;
    private final DateFormat _toolTipFormat;
    private boolean _formatEndDate;
    private int _endFormatField;
    public static final String RESOURCE_PREFIX = "ScaleArea.Date.";
    static final Map<Locale, Integer> WEEK = new HashMap<Locale, Integer>();

    public DatePeriodConverter(String string, DateFormat dateFormat, DateFormat dateFormat2) {
        super(string);
        this._labelFormat = dateFormat;
        this._toolTipFormat = dateFormat2;
    }

    public DatePeriodConverter(String string, DateFormat dateFormat, DateFormat dateFormat2, int n) {
        this(string, dateFormat, dateFormat2);
        this.setFormatEndDate(true, n);
    }

    public void setFormatEndDate(boolean bl, int n) {
        this._formatEndDate = bl;
        this._endFormatField = n;
    }

    @Override
    public String getText(Date date, Date date2) {
        return this.getText(this._labelFormat, date, date2);
    }

    @Override
    public String getDescription(Date date, Date date2) {
        return this.getText(this._toolTipFormat, date, date2);
    }

    private Date adjustDate(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(this._endFormatField, n);
        return calendar.getTime();
    }

    public String getText(DateFormat dateFormat, Date date, Date date2) {
        String string = this.format(dateFormat, date);
        if (this._formatEndDate) {
            String string2 = this.format(dateFormat, this.adjustDate(date2, -1));
            string = string + "-" + string2;
        }
        return string;
    }

    protected String format(DateFormat dateFormat, Date date) {
        return dateFormat.format(date);
    }

    public static PeriodConverter<Date> createDefaultPeriodConverter(ScaleArea<Date> scaleArea) {
        return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.date"), DateFormat.getDateInstance(3), DateFormat.getDateInstance(1));
    }

    public static PeriodConverter<Date> createPeriodConverter(final ScaleArea<Date> scaleArea, DatePeriod datePeriod) {
        if (datePeriod == DatePeriod.MILLENIUM) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.millennium"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy"), 1);
        }
        if (datePeriod == DatePeriod.CENTURY) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.century"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"), 1);
        }
        if (datePeriod == DatePeriod.DECENNIUM) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.decade"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"), 1);
        }
        if (datePeriod == DatePeriod.YEAR) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.year"), new SimpleDateFormat("yyyy"), new SimpleDateFormat("yyyy GGGG"));
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, 9999);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.QUARTER) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.quarter"), new SimpleDateFormat("MMMM"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.monthOfYear.longFormat")));
            datePeriodConverter.setFormatEndDate(true, 5);
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.MONTH) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.month"), new SimpleDateFormat("MMMM"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.monthOfYear.longFormat")));
            Calendar calendar = Calendar.getInstance();
            calendar.set(2, 8);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.WEEK_OF_MONTH) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.weekOfMonth"), new SimpleDateFormat("W"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.weekOfMonth.longFormat")));
        }
        if (datePeriod == DatePeriod.WEEK_OF_YEAR) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.weekOfYear"), new SimpleDateFormat("w"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.weekOfYear.longFormat")));
        }
        if (datePeriod == DatePeriod.FIRST_DAY_OF_WEEK) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.firstDayOfWeek"), SimpleDateFormat.getDateInstance(3), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.firstDayOfWeek.longFormat")), 7);
        }
        if (datePeriod == DatePeriod.DAY_OF_YEAR) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfYear"), SimpleDateFormat.getDateInstance(3), SimpleDateFormat.getDateInstance(1));
        }
        if (datePeriod == DatePeriod.DAY_OF_MONTH) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfMonth"), new SimpleDateFormat("d"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.date.longFormat")));
        }
        if (datePeriod == DatePeriod.DAY_OF_WEEK) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.dayOfWeek"), (DateFormat)new SimpleDateFormat("E"), (DateFormat)new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.date.longFormat"))){
                private static final long serialVersionUID = -7991321514536114448L;

                @Override
                protected String format(DateFormat dateFormat, Date date) {
                    String string = super.format(dateFormat, date);
                    if (!(dateFormat instanceof SimpleDateFormat) || !"E".equals(((SimpleDateFormat)dateFormat).toPattern())) {
                        return string;
                    }
                    if (string.length() == 1) {
                        return string;
                    }
                    Locale locale = scaleArea.getLocale();
                    Integer n = (Integer)WEEK.get(locale);
                    if (n == null) {
                        String string2;
                        int n2;
                        int n3;
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        int n4 = calendar.getMinimum(7);
                        int n5 = calendar.getMaximum(7);
                        calendar.set(7, n4);
                        String[] stringArray = new String[n5 - n4 + 1];
                        for (n3 = n4; n3 <= n5; ++n3) {
                            calendar.set(7, n3);
                            stringArray[n3 - n4] = super.format(dateFormat, calendar.getTime());
                        }
                        n = 0;
                        n3 = 32;
                        boolean bl = false;
                        int n6 = stringArray.length;
                        for (n2 = 0; n2 < n6; ++n2) {
                            string2 = stringArray[n2];
                            if (n2 == 0) {
                                n3 = string2.charAt(n);
                                continue;
                            }
                            if (string2.charAt(n) == n3) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            n = string.length() - 1;
                            n6 = stringArray.length;
                            for (n2 = 0; n2 < n6; ++n2) {
                                string2 = stringArray[n2];
                                if (n >= string.length()) break;
                                if (n2 == 0) {
                                    n3 = string2.charAt(n);
                                    continue;
                                }
                                if (string2.charAt(n) == n3) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) {
                            WEEK.put(locale, n);
                        } else {
                            return string;
                        }
                    }
                    return string.substring(n, n + 1);
                }
            };
            Calendar calendar = Calendar.getInstance();
            calendar.set(7, 4);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.HOUR) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.hour"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.hour.format")), SimpleDateFormat.getDateTimeInstance());
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 11);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.HOUR_OF_DAY) {
            DatePeriodConverter datePeriodConverter = new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.hour"), new SimpleDateFormat(scaleArea.getResourceString("ScaleArea.Date.hourOfDay.format")), SimpleDateFormat.getDateTimeInstance());
            Calendar calendar = Calendar.getInstance();
            calendar.set(10, 23);
            datePeriodConverter.setPrototypeDisplayValue(calendar.getTime());
            return datePeriodConverter;
        }
        if (datePeriod == DatePeriod.MINUTE) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.minute"), new SimpleDateFormat("m"), new SimpleDateFormat("hh:mm"));
        }
        if (datePeriod == DatePeriod.SECOND) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.second"), new SimpleDateFormat("s"), new SimpleDateFormat("hh:mm:ss"));
        }
        if (datePeriod == DatePeriod.MILLISECOND) {
            return new DatePeriodConverter(scaleArea.getResourceString("ScaleArea.Date.millisecond"), new SimpleDateFormat("S"), new SimpleDateFormat("hh:mm:ss-SS"));
        }
        return null;
    }
}

