/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.scale;

import com.jidesoft.scale.Period;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class DatePeriod
implements Period,
Serializable {
    private static final long serialVersionUID = -3361098627363838020L;
    public static final DatePeriod MILLENIUM;
    public static final DatePeriod CENTURY;
    public static final DatePeriod DECENNIUM;
    public static final DatePeriod YEAR;
    public static final DatePeriod QUARTER;
    public static final DatePeriod MONTH;
    public static final DatePeriod WEEK_OF_YEAR;
    public static final DatePeriod FIRST_DAY_OF_WEEK;
    public static final DatePeriod WEEK_OF_MONTH;
    public static final DatePeriod DAY_OF_WEEK;
    public static final DatePeriod DAY_OF_MONTH;
    public static final DatePeriod DAY_OF_WEEK_IN_MONTH;
    public static final DatePeriod DAY_OF_YEAR;
    public static final DatePeriod AM_PM;
    public static final DatePeriod HOUR;
    public static final DatePeriod HOUR_OF_DAY;
    public static final DatePeriod MINUTE;
    public static final DatePeriod SECOND;
    public static final DatePeriod MILLISECOND;
    private final int _calendarField;
    private final int _amount;
    private final int _offset;

    public DatePeriod(int n, int n2, int n3) {
        this._offset = n3;
        if (n < 0 || n >= 17) {
            throw new IllegalArgumentException("Invalid Calendar field: " + n);
        }
        if (n == 0) {
            throw new IllegalArgumentException("Calendar.ERA not supported!");
        }
        this._calendarField = n;
        this._amount = n2;
    }

    public int getCalendarField() {
        return this._calendarField;
    }

    public int getAmount() {
        return this._amount;
    }

    public int getOffset() {
        return this._offset;
    }

    public String toString() {
        String string;
        switch (this._calendarField) {
            case 0: {
                string = "ERA";
                break;
            }
            case 1: {
                string = "YEAR";
                break;
            }
            case 2: {
                string = "MONTH";
                break;
            }
            case 3: {
                string = "WEEK_OF_YEAR";
                break;
            }
            case 4: {
                string = "WEEK_OF_MONTH";
                break;
            }
            case 7: {
                string = "DAY_OF_WEEK";
                break;
            }
            case 5: {
                string = "DAY_OF_MONTH";
                break;
            }
            case 8: {
                string = "DAY_OF_WEEK_IN_MONTH";
                break;
            }
            case 6: {
                string = "DAY_OF_YEAR";
                break;
            }
            case 9: {
                string = "DAY_OF_YEAR";
                break;
            }
            case 10: {
                string = "HOUR";
                break;
            }
            case 11: {
                string = "HOUR_OF_DAY";
                break;
            }
            case 12: {
                string = "MINUTE";
                break;
            }
            case 13: {
                string = "SECOND";
                break;
            }
            case 14: {
                string = "MILLISECOND";
                break;
            }
            default: {
                string = String.valueOf(this._calendarField);
            }
        }
        return "DatePeriod[_calendarField=" + string + ", _amount=" + this._amount + ", _offset=" + this._offset + "]";
    }

    public static List<DatePeriod> getDefaultDatePeriods() {
        return Arrays.asList(MILLISECOND, SECOND, MINUTE, HOUR_OF_DAY, HOUR, AM_PM, DAY_OF_YEAR, DAY_OF_WEEK_IN_MONTH, DAY_OF_MONTH, DAY_OF_WEEK, WEEK_OF_MONTH, WEEK_OF_YEAR, FIRST_DAY_OF_WEEK, MONTH, QUARTER, YEAR, DECENNIUM, CENTURY, MILLENIUM);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DatePeriod)) {
            return false;
        }
        DatePeriod datePeriod = (DatePeriod)object;
        if (this._calendarField != datePeriod._calendarField) {
            return false;
        }
        if (this._amount != datePeriod._amount) {
            return false;
        }
        return this._offset == datePeriod._offset;
    }

    public int hashCode() {
        int n = this._calendarField;
        n = 31 * n + this._amount;
        n = 31 * n + this._offset;
        return n;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(8192)) {
            Lm.showInvalidProductMessage(DatePeriod.class.getName(), 8192);
        }
        MILLENIUM = new DatePeriod(1, 1000, -1);
        CENTURY = new DatePeriod(1, 100, -1);
        DECENNIUM = new DatePeriod(1, 10, -1);
        YEAR = new DatePeriod(1, 1, 0);
        QUARTER = new DatePeriod(2, 3, 0);
        MONTH = new DatePeriod(2, 1, 0);
        WEEK_OF_YEAR = new DatePeriod(3, 1, 0);
        FIRST_DAY_OF_WEEK = new DatePeriod(3, 1, 0);
        WEEK_OF_MONTH = new DatePeriod(4, 1, 0);
        DAY_OF_WEEK = new DatePeriod(7, 1, 0);
        DAY_OF_MONTH = new DatePeriod(5, 1, 0);
        DAY_OF_WEEK_IN_MONTH = new DatePeriod(8, 1, 0);
        DAY_OF_YEAR = new DatePeriod(6, 1, 0);
        AM_PM = new DatePeriod(9, 1, 0);
        HOUR = new DatePeriod(10, 1, 0);
        HOUR_OF_DAY = new DatePeriod(11, 1, 0);
        MINUTE = new DatePeriod(12, 1, 0);
        SECOND = new DatePeriod(13, 1, 0);
        MILLISECOND = new DatePeriod(14, 1, 0);
    }
}

