/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedConstants;
import com.jidesoft.rss.FeedPreference;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.swing.JideBoxLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;

public class PreferencePanel
extends JPanel {
    private JRadioButton _defaultBrowser = null;
    private JRadioButton _userBrowser = null;
    private JTextField _browser = null;
    private JCheckBox _doubleSite = null;
    private JComboBox _maxItem = null;
    private JSpinner _delayTime = null;
    private FeedReader _rss;

    public PreferencePanel(FeedReader feedReader) {
        this._rss = feedReader;
        this.initComponents();
    }

    protected void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setLayout(new GridLayout(2, 1, 6, 6));
        this.add(this.createSubscriptionPanel());
        this.add(this.createBrowserPanel());
    }

    public JComponent createSubscriptionPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1));
        TitledBorder titledBorder = new TitledBorder(this._rss.getResourceString("RssFeeds.subscriptions"));
        jPanel.setBorder(titledBorder);
        this._doubleSite = new JCheckBox(this._rss.getResourceString("RssFeeds.allowDupChannel"));
        this._doubleSite.setMnemonic(65);
        jPanel.add(this._doubleSite);
        jPanel.add(Box.createVerticalStrut(3), "fix");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new JideBoxLayout(jPanel2, 0, 6));
        this._maxItem = new JComboBox<String>(new String[]{"10", "30", "50", "100", "300", "1000"});
        jPanel2.add(this._maxItem);
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.maxItemCount"));
        jPanel2.add((Component)jLabel, "fix");
        jPanel2.add(Box.createGlue(), "vary");
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(3), "fix");
        JPanel jPanel3 = new JPanel();
        JLabel jLabel2 = new JLabel(this._rss.getResourceString("RssFeeds.refresh1"));
        jPanel3.setLayout(new JideBoxLayout(jPanel3, 0, 6));
        jPanel3.add((Component)jLabel2, "fix");
        this._delayTime = new JSpinner(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE / FeedConstants.MS_IN_MINUTE, 1));
        this._delayTime.setPreferredSize(new Dimension(50, this._delayTime.getPreferredSize().height));
        jPanel3.add((Component)this._delayTime, "fix");
        JLabel jLabel3 = new JLabel(this._rss.getResourceString("RssFeeds.refresh2"));
        jPanel3.add((Component)jLabel3, "fix");
        jPanel3.add(Box.createGlue(), "vary");
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(2), "fix");
        return jPanel;
    }

    public JComponent createBrowserPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new JideBoxLayout(jPanel, 1));
        TitledBorder titledBorder = new TitledBorder(this._rss.getResourceString("RssFeeds.Browser"));
        jPanel.setBorder(titledBorder);
        this._defaultBrowser = new JRadioButton(this._rss.getResourceString("RssFeeds.defaultBrowser"));
        this._defaultBrowser.setMnemonic(68);
        jPanel.add(this._defaultBrowser);
        jPanel.add(Box.createVerticalStrut(3), "fix");
        this._userBrowser = new JRadioButton(this._rss.getResourceString("RssFeeds.useBrowser"));
        this._userBrowser.setMnemonic(70);
        jPanel.add(this._userBrowser);
        jPanel.add(Box.createVerticalStrut(3), "fix");
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.Browser.command"));
        jPanel2.setLayout(new BorderLayout(6, 6));
        jPanel2.add((Component)jLabel, "Before");
        this._browser = new JTextField(20);
        this._browser.setEditable(this._userBrowser.isSelected());
        jPanel2.add((Component)this._browser, "Center");
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(2), "fix");
        this._defaultBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencePanel.this._userBrowser.setSelected(!PreferencePanel.this._defaultBrowser.isSelected());
                PreferencePanel.this._browser.setEditable(PreferencePanel.this._userBrowser.isSelected());
            }
        });
        this._userBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreferencePanel.this._defaultBrowser.setSelected(!PreferencePanel.this._userBrowser.isSelected());
                PreferencePanel.this._browser.setEditable(PreferencePanel.this._userBrowser.isSelected());
            }
        });
        return jPanel;
    }

    public void load(FeedPreference feedPreference) {
        this._doubleSite.setSelected(feedPreference.isAllowDuplicatedChannels());
        this._maxItem.setSelectedItem("" + feedPreference.getMaxCacheItems());
        this._delayTime.setValue(feedPreference.getRefreshTime());
        this._defaultBrowser.setSelected(feedPreference.isUseDefaultBrowser());
        this._userBrowser.setSelected(!feedPreference.isUseDefaultBrowser());
        this._browser.setText(feedPreference.getBrowser());
    }

    public void save(FeedPreference feedPreference) throws Exception {
        boolean bl = this._doubleSite.isSelected();
        int n = Integer.parseInt(this._maxItem.getSelectedItem().toString());
        int n2 = (Integer)this._delayTime.getValue();
        boolean bl2 = this._defaultBrowser.isSelected();
        String string = this._browser.getText();
        feedPreference.setAllowDuplicatedChannels(bl);
        feedPreference.setMaxCacheItems(n);
        feedPreference.setRefreshTime(n2);
        feedPreference.setUseDefaultBrowser(bl2);
        feedPreference.setBrowser(string);
    }
}

