/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.rss.FeedReader;
import com.jidesoft.rss.MoveChannelThread;
import com.jidesoft.rss.TreeGroupCellRender;
import de.nava.informa.core.ChannelGroupIF;
import de.nava.informa.impl.basic.ChannelGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class MoveChannelDialog
extends StandardDialog {
    private FeedReader _rss = null;
    private JTree _tree = null;

    MoveChannelDialog(Dialog dialog, FeedReader feedReader) {
        super(dialog, true);
        this.initDialog(feedReader);
    }

    MoveChannelDialog(Frame frame, FeedReader feedReader) {
        super(frame);
        this.initDialog(feedReader);
    }

    private void initDialog(FeedReader feedReader) {
        this._rss = feedReader;
        this.setTitle(this._rss.getResourceString("RssFeeds.moveChannelDialogTitle"));
        this.setDefaultAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.okButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MoveChannelDialog.this._tree.getLastSelectedPathComponent() == null) {
                    JOptionPane.showMessageDialog(MoveChannelDialog.this._rss, MoveChannelDialog.this._rss.getResourceString("RssFeeds.message.failToMoveChannel.selectGroup"), MoveChannelDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)MoveChannelDialog.this._tree.getLastSelectedPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)MoveChannelDialog.this._rss.getFeedTree().getLastSelectedPathComponent();
                DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
                ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode3.getUserObject();
                ChannelGroupIF channelGroupIF2 = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
                if (channelGroupIF.getId() == channelGroupIF2.getId()) {
                    JOptionPane.showMessageDialog(MoveChannelDialog.this._rss, MoveChannelDialog.this._rss.getResourceString("RssFeeds.message.failToMoveChannel.srcdstGroupSame"), MoveChannelDialog.this._rss.getResourceString("RssFeeds.title"), 2);
                    return;
                }
                MoveChannelDialog.this.setVisible(false);
                MoveChannelDialog.this.dispose();
                new MoveChannelThread(MoveChannelDialog.this._rss, channelGroupIF2).start();
            }
        });
        this.setDefaultCancelAction(new AbstractAction(UIDefaultsLookup.getString("OptionPane.cancelButtonText", this.getLocale())){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MoveChannelDialog.this.setVisible(false);
                MoveChannelDialog.this.dispose();
            }
        });
    }

    @Override
    public JComponent createBannerPanel() {
        return null;
    }

    @Override
    public JComponent createContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        JLabel jLabel = new JLabel(this._rss.getResourceString("RssFeeds.Label.moveChannel.selectGroup"));
        jLabel.setDisplayedMnemonic(this._rss.getResourceString("RssFeeds.Label.moveChannel.selectGroup.mnemonic").charAt(0));
        jPanel.add((Component)jLabel, "First");
        this._tree = this.createTempFolderTree();
        this._tree.setSelectionRow(0);
        this._tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    MoveChannelDialog.this.getDefaultAction().actionPerformed(null);
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this._tree), "Center");
        jLabel.setLabelFor(this._tree);
        return jPanel;
    }

    private JTree createTempFolderTree() {
        Serializable serializable;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._rss.getGroupTreeModel().getRoot();
        ChannelGroupIF channelGroupIF = (ChannelGroupIF)defaultMutableTreeNode.getUserObject();
        ChannelGroup channelGroup = new ChannelGroup();
        channelGroup.setId(channelGroupIF.getId());
        channelGroup.setTitle(channelGroupIF.getTitle());
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(channelGroup);
        Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
        while (enumeration.hasMoreElements()) {
            serializable = (DefaultMutableTreeNode)enumeration.nextElement();
            if (!(((DefaultMutableTreeNode)serializable).getUserObject() instanceof ChannelGroupIF)) continue;
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(((DefaultMutableTreeNode)serializable).getUserObject()));
        }
        serializable = new JTree(defaultMutableTreeNode2){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(300, 200);
            }
        };
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ((JTree)serializable).setCellRenderer(new TreeGroupCellRender());
        ((JTree)serializable).getSelectionModel().setSelectionMode(1);
        ((JTree)serializable).setRootVisible(true);
        return serializable;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton jButton = new JButton();
        JButton jButton2 = new JButton();
        buttonPanel.addButton((AbstractButton)jButton, "AFFIRMATIVE");
        buttonPanel.addButton((AbstractButton)jButton2, "CANCEL");
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jButton.setAction(this.getDefaultAction());
        jButton2.setAction(this.getDefaultCancelAction());
        return buttonPanel;
    }
}

