/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedReader;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

class ItemPopupMenuAction
extends MouseAdapter {
    private JTable _itemTable = null;
    private JPopupMenu _popupMenu;

    public ItemPopupMenuAction(FeedReader feedReader) {
        this._itemTable = feedReader.getFeedTable();
        this._popupMenu = feedReader.getItemPopupMenu();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Component component;
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2 && this._popupMenu != null && this._popupMenu.getComponentCount() > 0 && (component = this._popupMenu.getComponent(0)) instanceof AbstractButton) {
            ((AbstractButton)component).doClick();
        }
    }

    private void showPopupMenu(MouseEvent mouseEvent) {
        int n = this._itemTable.rowAtPoint(mouseEvent.getPoint());
        this._itemTable.setRowSelectionInterval(n, n);
        this._popupMenu.show(this._itemTable, mouseEvent.getX(), mouseEvent.getY());
    }
}

