/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.rss;

import com.jidesoft.rss.FeedConstants;
import com.jidesoft.rss.FeedPreference;
import java.util.prefs.Preferences;

public class DefaultFeedPreference
implements FeedPreference {
    static final String PREFIX = "/com/jidesoft/feedreader/preference/";
    static final String PREFERENCEKEY_ID = "/com/jidesoft/feedreader/preference/Id";
    static final String PREFERENCEKEY_NAME = "/com/jidesoft/feedreader/preference/Name";
    static final String PREFERENCEKEY_ALLOWDUPLICATEDCHANNELS = "/com/jidesoft/feedreader/preference/AllowDuplicatedChannels";
    static final String PREFERENCEKEY_MAXCACHEITEMS = "/com/jidesoft/feedreader/preference/MaxCacheItems";
    static final String PREFERENCEKEY_REFRESHTIME = "/com/jidesoft/feedreader/preference/RefreshTime";
    static final String PREFERENCEKEY_USEDEFAULTBROWSER = "/com/jidesoft/feedreader/preference/UseDefaultBrowser";
    static final String PREFERENCEKEY_BROWSER = "/com/jidesoft/feedreader/preference/Browser";
    static final String PREFERENCEKEY_DESCRIPTION = "/com/jidesoft/feedreader/preference/Description";

    @Override
    public boolean isAllowDuplicatedChannels() {
        return Preferences.userRoot().getBoolean(PREFERENCEKEY_ALLOWDUPLICATEDCHANNELS, false);
    }

    @Override
    public void setAllowDuplicatedChannels(boolean bl) {
        Preferences.userRoot().putBoolean(PREFERENCEKEY_ALLOWDUPLICATEDCHANNELS, bl);
    }

    @Override
    public String getBrowser() {
        return Preferences.userRoot().get(PREFERENCEKEY_BROWSER, "");
    }

    @Override
    public void setBrowser(String string) {
        Preferences.userRoot().put(PREFERENCEKEY_BROWSER, string);
    }

    @Override
    public String getDescription() {
        return Preferences.userRoot().get(PREFERENCEKEY_DESCRIPTION, "");
    }

    @Override
    public void setDescription(String string) {
        Preferences.userRoot().put(PREFERENCEKEY_BROWSER, string);
    }

    @Override
    public int getMaxCacheItems() {
        return Preferences.userRoot().getInt(PREFERENCEKEY_MAXCACHEITEMS, 10);
    }

    @Override
    public void setMaxCacheItems(int n) {
        Preferences.userRoot().putInt(PREFERENCEKEY_MAXCACHEITEMS, n);
    }

    @Override
    public String getName() {
        return Preferences.userRoot().get(PREFERENCEKEY_NAME, "");
    }

    @Override
    public void setName(String string) {
        Preferences.userRoot().put(PREFERENCEKEY_NAME, string);
    }

    @Override
    public boolean isUseDefaultBrowser() {
        return Preferences.userRoot().getBoolean(PREFERENCEKEY_USEDEFAULTBROWSER, true);
    }

    @Override
    public void setUseDefaultBrowser(boolean bl) {
        Preferences.userRoot().putBoolean(PREFERENCEKEY_USEDEFAULTBROWSER, bl);
    }

    @Override
    public long getId() {
        return Preferences.userRoot().getLong(PREFERENCEKEY_ID, 1L);
    }

    @Override
    public void setId(long l) {
        Preferences.userRoot().putLong(PREFERENCEKEY_ID, l);
    }

    @Override
    public int getRefreshTime() {
        int n = Preferences.userRoot().getInt(PREFERENCEKEY_REFRESHTIME, 30);
        if (n <= 0) {
            n = 1;
        } else if (n > Integer.MAX_VALUE / FeedConstants.MS_IN_MINUTE) {
            n = Integer.MAX_VALUE / FeedConstants.MS_IN_MINUTE;
        }
        return n;
    }

    @Override
    public void setRefreshTime(int n) {
        if (n <= 0) {
            n = 1;
        } else if (n > Integer.MAX_VALUE / FeedConstants.MS_IN_MINUTE) {
            n = Integer.MAX_VALUE / FeedConstants.MS_IN_MINUTE;
        }
        Preferences.userRoot().putInt(PREFERENCEKEY_REFRESHTIME, n);
    }
}

