/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Range;

public class BooleanRange
extends AbstractRange<Boolean> {
    private Boolean _lower = false;
    private Boolean _upper = true;

    public BooleanRange(boolean bl, boolean bl2) {
        this.adjust(bl, bl2);
    }

    @Override
    public Range<Boolean> createIntermediate(Range<Boolean> range, double d) {
        return null;
    }

    @Override
    public Boolean lower() {
        return this._lower;
    }

    @Override
    public Boolean upper() {
        return this._upper;
    }

    @Override
    public void adjust(Boolean bl, Boolean bl2) {
        this.setMin(bl);
        this.setMax(bl2);
    }

    protected void setMin(boolean bl) {
        boolean bl2 = this._lower;
        this._lower = bl;
        this.firePropertyChange("min", bl2, this._lower);
    }

    protected void setMax(boolean bl) {
        boolean bl2 = this._upper;
        this._upper = bl;
        this.firePropertyChange("max", bl2, this._upper);
    }

    @Override
    public double minimum() {
        throw new UnsupportedOperationException("minimum() is not implemented in StringRange");
    }

    @Override
    public double maximum() {
        throw new UnsupportedOperationException("maximum() is not implemented in StringRange");
    }

    @Override
    public double size() {
        return this._lower.compareTo(this._upper);
    }

    @Override
    public boolean contains(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl.compareTo(this.lower()) >= 0 && bl.compareTo(this.upper()) <= 0;
    }

    public String toString() {
        return "BooleanRange{lower='" + this._lower + '\'' + ", upper='" + this._upper + '\'' + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BooleanRange)) {
            return false;
        }
        BooleanRange booleanRange = (BooleanRange)object;
        if (this._lower != null ? !this._lower.equals(booleanRange._lower) : booleanRange._lower != null) {
            return false;
        }
        return !(this._upper != null ? !this._upper.equals(booleanRange._upper) : booleanRange._upper != null);
    }

    public int hashCode() {
        int n = this._lower != null ? this._lower.hashCode() : 0;
        n = 31 * n + (this._upper != null ? this._upper.hashCode() : 0);
        return n;
    }
}

