/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PeriodHeaderPainter;
import com.jidesoft.plaf.basic.BasicScaleAreaUI;
import com.jidesoft.plaf.basic.TableCellRendererPeriodHeaderPainter;
import com.jidesoft.scale.Period;
import com.jidesoft.scale.PeriodConverter;
import com.jidesoft.scale.ScaleArea;
import com.jidesoft.scale.ScaleModel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.TableCellRenderer;

public class TableCellRendererScaleAreaUI
extends BasicScaleAreaUI {
    private CellRendererPane _rendererPane;
    private Period _selectedPeriod;
    private Object _selectedStartInstant;
    private Object _selectedEndInstant;
    private Period _currentSmallestPeriod;
    private boolean _preferredPeriodSizeDirty;

    public static ComponentUI createUI(JComponent jComponent) {
        return new TableCellRendererScaleAreaUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        ScaleArea scaleArea = (ScaleArea)jComponent;
        this._rendererPane = new CellRendererPane();
        scaleArea.add(this._rendererPane);
        this._currentSmallestPeriod = scaleArea.getSmallestVisiblePeriod();
        this._preferredPeriodSizeDirty = true;
    }

    @Override
    protected PeriodHeaderPainter createDefaultPeriodHeaderPainter(ScaleArea<Object> scaleArea) {
        return new TableCellRendererPeriodHeaderPainter();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this._currentSmallestPeriod = null;
        this._preferredPeriodSizeDirty = true;
        this.setPreferredPeriodSize(new Dimension(27, 21));
        ScaleArea scaleArea = (ScaleArea)jComponent;
        scaleArea.remove(this._rendererPane);
        this._rendererPane = null;
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installDefaults(ScaleArea<Object> scaleArea) {
        super.installDefaults(scaleArea);
        LookAndFeel.installColorsAndFont(scaleArea, "TableHeader.background", "TableHeader.foreground", "TableHeader.font");
        LookAndFeel.installProperty(scaleArea, "opaque", Boolean.TRUE);
    }

    protected Dimension calculatePreferredPeriodSize(Period period) {
        ScaleArea<Object> scaleArea = this.getScaleArea();
        ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
        if (period != null && scaleModel != null) {
            PeriodHeaderPainter periodHeaderPainter = scaleArea.getPeriodHeaderPainter();
            if (periodHeaderPainter instanceof TableCellRendererPeriodHeaderPainter) {
                TableCellRendererPeriodHeaderPainter tableCellRendererPeriodHeaderPainter = (TableCellRendererPeriodHeaderPainter)periodHeaderPainter;
                TableCellRenderer tableCellRenderer = tableCellRendererPeriodHeaderPainter.getTableCellRenderer(scaleArea);
                if (tableCellRenderer != null) {
                    PeriodConverter<Object> periodConverter = scaleArea.getPeriodConverter(period);
                    Object object = periodConverter.getPrototypeDisplayValue();
                    if (object == null) {
                        object = scaleArea.getStart();
                    }
                    Object object2 = scaleModel.getPeriodStart(period, object);
                    Object object3 = scaleModel.getPeriodEnd(period, object);
                    Component component = tableCellRendererPeriodHeaderPainter.createRendererComponent(scaleArea, tableCellRenderer, periodConverter, period, object2, object3);
                    tableCellRendererPeriodHeaderPainter.prepareRenderer(scaleArea, periodConverter, object2, object3, component);
                    Dimension dimension = component.getPreferredSize();
                    dimension.width += 4;
                    tableCellRendererPeriodHeaderPainter.releaseRenderer(scaleArea, periodConverter, object2, object3, component);
                    return dimension;
                }
                return new Dimension(27, 21);
            }
            return super.getPreferredPeriodSize(period);
        }
        return new Dimension(27, 21);
    }

    @Override
    public Dimension getPreferredPeriodSize(Period period) {
        if (this._preferredPeriodSizeDirty) {
            this._preferredPeriodSizeDirty = false;
            ScaleArea<Object> scaleArea = this.getScaleArea();
            this._currentSmallestPeriod = scaleArea.getSmallestVisiblePeriod();
            this.setPreferredPeriodSize(this.calculatePreferredPeriodSize(this._currentSmallestPeriod));
            this.recalculateScale(scaleArea);
        }
        if (period == this._currentSmallestPeriod) {
            return super.getPreferredPeriodSize(period);
        }
        return this.calculatePreferredPeriodSize(period);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this._rendererPane.removeAll();
    }

    protected CellRendererPane getCellRendererPane() {
        return this._rendererPane;
    }

    @Override
    protected BasicScaleAreaUI.Handler createHandler() {
        return new RendererPropertyChangeHandler(this);
    }

    protected boolean isPeriodSelected(Period period, Object object, Object object2) {
        return period != null && this._selectedPeriod == period && JideSwingUtilities.equals(this._selectedStartInstant, object) && JideSwingUtilities.equals(this._selectedEndInstant, object2);
    }

    protected void repaintPeriod(Object object, Object object2, Object object3) {
        if (object != null) {
            ScaleArea<Object> scaleArea = this.getScaleArea();
            ScaleModel<Object> scaleModel = scaleArea.getScaleModel();
            int n = this.getX(scaleModel.getPosition(object2));
            int n2 = this.getX(scaleModel.getPosition(object3));
            scaleArea.repaint(n, 0, n2 - n, scaleArea.getHeight());
        }
    }

    protected static class RendererPropertyChangeHandler
    extends BasicScaleAreaUI.Handler {
        public RendererPropertyChangeHandler(TableCellRendererScaleAreaUI tableCellRendererScaleAreaUI) {
            super(tableCellRendererScaleAreaUI);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("periodConverters".equals(string) || "visiblePeriods".equals(string) || "preferredPeriodSize".equals(string) || "treeTable".equals(string)) {
                this.getUI()._preferredPeriodSizeDirty = true;
            }
            super.propertyChange(propertyChangeEvent);
        }

        protected TableCellRendererScaleAreaUI getUI() {
            return (TableCellRendererScaleAreaUI)this._ui;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            super.mouseEntered(mouseEvent);
            this.updateSelectedPeriod(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            super.mouseExited(mouseEvent);
            this.updateSelectedPeriod(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (this.getCurrentAction() == 0) {
                this.updateSelectedPeriod(mouseEvent);
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            super.mouseMoved(mouseEvent);
            this.updateSelectedPeriod(mouseEvent);
        }

        protected void updateSelectedPeriod(MouseEvent mouseEvent) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Period period = null;
            if (this.getUI().getScaleArea().getVisibleRect().contains(mouseEvent.getPoint())) {
                period = this.getUI().getPeriodAt(mouseEvent.getY());
            }
            if (period != null) {
                object4 = this.getUI().getScaleArea().getScaleModel();
                object3 = object4.getInstantAt(this.getUI().getPositionAt(mouseEvent.getX()));
                object2 = object4.getPeriodStart(period, (Object)object3);
                object = object4.getPeriodEnd(period, object3);
            } else {
                object2 = null;
                object = null;
            }
            if (!this.getUI().isPeriodSelected(period, object2, object)) {
                object4 = this.getUI()._selectedPeriod;
                object3 = this.getUI()._selectedStartInstant;
                Object object5 = this.getUI()._selectedEndInstant;
                this.getUI()._selectedPeriod = period;
                this.getUI()._selectedStartInstant = object2;
                this.getUI()._selectedEndInstant = object;
                this.getUI().repaintPeriod(object4, object3, object5);
                this.getUI().repaintPeriod(this.getUI()._selectedPeriod, this.getUI()._selectedStartInstant, this.getUI()._selectedEndInstant);
            }
        }
    }
}

