/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.combobox.ExComboBox;
import com.jidesoft.combobox.ListExComboBox;
import com.jidesoft.combobox.TableExComboBox;
import com.jidesoft.grid.AbstractJideCellEditor;
import com.jidesoft.grid.JideTable;
import com.jidesoft.swing.DelegateAction;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellEditor;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class ExComboBoxEditor
implements ComboBoxEditor {
    ComboBoxEditor _delegate;
    ExComboBox _comboBox;
    boolean _edited;
    private DocumentListener _documentListener;
    protected Object oldValue;

    public ExComboBoxEditor(ComboBoxEditor comboBoxEditor, ExComboBox exComboBox) {
        this._delegate = comboBoxEditor;
        this._comboBox = exComboBox;
        Component component = this._delegate.getEditorComponent();
        if (component instanceof JComponent) {
            this.registerActions((JComponent)component);
        }
    }

    @Override
    public Component getEditorComponent() {
        return this._delegate.getEditorComponent();
    }

    @Override
    public void selectAll() {
        Component component = this._delegate.getEditorComponent();
        if (component instanceof JTextField) {
            ((JTextField)component).selectAll();
        } else {
            this._delegate.selectAll();
        }
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        this._delegate.addActionListener(actionListener);
    }

    @Override
    public void removeActionListener(ActionListener actionListener) {
        this._delegate.removeActionListener(actionListener);
    }

    @Override
    public void setItem(Object object) {
        try {
            this._delegate.setItem(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            ((JTextComponent)this.getEditorComponent()).setText(this._comboBox.convertElementToString(object));
            this.oldValue = object;
        } else {
            ((JTextComponent)this.getEditorComponent()).setText("");
        }
        this._edited = false;
    }

    @Override
    public Object getItem() {
        JTextComponent jTextComponent = (JTextComponent)this.getEditorComponent();
        return this._edited ? this._comboBox.convertStringToElement(jTextComponent.getText()) : this._comboBox.getSelectedItem();
    }

    protected void registerActions(final JComponent jComponent) {
        DelegateAction delegateAction = new DelegateAction(){
            private static final long serialVersionUID = 4640922702323108672L;

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                Container container;
                Object object = ExComboBoxEditor.this._comboBox.getClientProperty("AbstractComboBox.isTableCellEditor");
                if (object instanceof AbstractJideCellEditor && !ExComboBoxEditor.this._comboBox.isPopupVisible()) {
                    if (ExComboBoxEditor.this._comboBox.isEditable() && ((AbstractJideCellEditor)object).isPassEnterKeyToTable()) {
                        container = SwingUtilities.getAncestorOfClass(JideTable.class, ExComboBoxEditor.this._comboBox);
                        if (actionEvent.getSource() != container && container instanceof JideTable) {
                            ((CellEditor)object).stopCellEditing();
                            ((JideTable)container).processKeyBinding(KeyStroke.getKeyStroke(10, 0), new KeyEvent(ExComboBoxEditor.this._comboBox, 401, System.currentTimeMillis(), 0, 10, '\n'), 1, true);
                        }
                    } else if (!((AbstractJideCellEditor)object).isPassEnterKeyToTable()) {
                        ((CellEditor)object).stopCellEditing();
                    }
                } else {
                    ExComboBoxEditor.this._comboBox.commitEditWithFocusLostBehavior(true);
                }
                container = SwingUtilities.getRootPane(ExComboBoxEditor.this._comboBox);
                if (container != null) {
                    Action action;
                    Object object2;
                    InputMap inputMap = container.getInputMap(2);
                    ActionMap actionMap = container.getActionMap();
                    if (inputMap != null && actionMap != null && (object2 = inputMap.get(KeyStroke.getKeyStroke(10, 0))) != null && (action = actionMap.get(object2)) != null) {
                        action.actionPerformed(new ActionEvent(container, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
                    }
                }
                return true;
            }
        };
        DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(10, 0), delegateAction);
        DelegateAction delegateAction2 = new DelegateAction(){
            private static final long serialVersionUID = -5819007480167189283L;

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                if (!ExComboBoxEditor.this._comboBox.isPopupVisible()) {
                    ExComboBoxEditor.this._comboBox.showPopup();
                    return true;
                }
                return false;
            }
        };
        DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(115, 0), delegateAction2);
        DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(40, 0), delegateAction2);
        DelegateAction.replaceAction(jComponent, 0, KeyStroke.getKeyStroke(40, 512), delegateAction2);
        if (jComponent instanceof JTextField) {
            this._documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    ExComboBoxEditor.this._edited = true;
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    ExComboBoxEditor.this._edited = true;
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    ExComboBoxEditor.this._edited = true;
                }
            };
            ((JTextField)jComponent).getDocument().removeDocumentListener(this._documentListener);
            ((JTextField)jComponent).getDocument().addDocumentListener(this._documentListener);
            jComponent.addPropertyChangeListener("document", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getOldValue() instanceof Document) {
                        ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(ExComboBoxEditor.this._documentListener);
                    }
                    if (propertyChangeEvent.getNewValue() instanceof Document) {
                        ((Document)propertyChangeEvent.getNewValue()).removeDocumentListener(ExComboBoxEditor.this._documentListener);
                        ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(ExComboBoxEditor.this._documentListener);
                    }
                }
            });
            if (this._comboBox instanceof ListExComboBox || this._comboBox instanceof TableExComboBox) {
                jComponent.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (ExComboBoxEditor.this._comboBox.isEnabled() && ExComboBoxEditor.this._comboBox.isButtonVisible() && mouseEvent.getClickCount() == 2) {
                            if (ExComboBoxEditor.this._comboBox instanceof ListExComboBox && ((ListExComboBox)ExComboBoxEditor.this._comboBox).isToggleValueOnDoubleClick()) {
                                ((ListExComboBox)ExComboBoxEditor.this._comboBox).toggleValue(jComponent, 40);
                            } else if (ExComboBoxEditor.this._comboBox instanceof TableExComboBox && ((TableExComboBox)ExComboBoxEditor.this._comboBox).isToggleValueOnDoubleClick()) {
                                ((TableExComboBox)ExComboBoxEditor.this._comboBox).toggleValue(jComponent, 40);
                            }
                        }
                    }
                });
            }
        }
    }
}

