/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.gantt.TaskBar;
import com.jidesoft.plaf.basic.TaskBarPainter;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;

public class DefaultTaskBarPainter
implements TaskBarPainter {
    @Override
    public void paintTask(Graphics2D graphics2D, TaskBar taskBar, Rectangle rectangle, Insets insets, Color color, Color color2, Color color3) {
        this.paintSingle(graphics2D, rectangle, insets, taskBar.getCompletion(), color, color2, color3, taskBar.getComponentOrientation().isLeftToRight());
    }

    private void paintSingle(Graphics2D graphics2D, Rectangle rectangle, Insets insets, double d, Color color, Color color2, Color color3, boolean bl) {
        int n = rectangle.height / 3;
        int n2 = Math.max(3, rectangle.width - insets.left - insets.right);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        Rectangle rectangle3 = new Rectangle(rectangle.x + insets.left + 1, rectangle.y + 1, n2 - 1, n);
        JideSwingUtilities.fillGradient(graphics2D, rectangle3.intersection(rectangle2), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), true);
        Rectangle rectangle4 = new Rectangle(rectangle.x + insets.left + 1, rectangle.y + 1 + n, n2 - 1, rectangle.height - 1 - n);
        JideSwingUtilities.fillGradient(graphics2D, rectangle4.intersection(rectangle2), color, ColorUtils.getDerivedColor(color, 0.64f), true);
        graphics2D.setColor(color2);
        graphics2D.drawRoundRect(rectangle.x + insets.left, rectangle.y, n2, rectangle.height, 4, 4);
        if (d > 0.0) {
            int n3 = (int)((double)(n2 - 1) * Math.min(1.0, d));
            int n4 = 3;
            int n5 = bl ? rectangle.x + insets.left + 1 : rectangle.x + insets.left + n2 - n3;
            int n6 = rectangle.y + rectangle.height / 2 - 1;
            graphics2D.setColor(color3);
            graphics2D.fillRect(n5, n6, n3, n4);
        }
    }

    @Override
    public void paintTaskGroup(Graphics2D graphics2D, TaskBar taskBar, Rectangle rectangle, Insets insets, Color color, Color color2, Color color3) {
        int n = Math.max(insets.left, insets.right);
        int n2 = n * 2;
        Polygon polygon = new Polygon(new int[]{0, n2, n2, n, 0}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height / 2, rectangle.y + rectangle.height, rectangle.y + rectangle.height / 2}, 5);
        Polygon polygon2 = new Polygon(new int[]{rectangle.width - n2, rectangle.width, rectangle.width, rectangle.width - n, rectangle.width - n2}, new int[]{rectangle.y, rectangle.y, rectangle.y + rectangle.height / 2, rectangle.y + rectangle.height, rectangle.y + rectangle.height / 2}, 5);
        Rectangle rectangle2 = graphics2D.getClipBounds();
        Rectangle rectangle3 = new Rectangle(n, rectangle.y + 1, rectangle.width - n, rectangle.height / 2 - 1);
        JideSwingUtilities.fillGradient(graphics2D, rectangle3.intersection(rectangle2), ColorUtils.getDerivedColor(color, 0.95f), color, true);
        graphics2D.setColor(color2);
        graphics2D.drawRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        JideSwingUtilities.fillGradient(graphics2D, polygon, color, ColorUtils.getDerivedColor(color, 0.65f), true);
        Rectangle rectangle4 = new Rectangle(rectangle.x, rectangle.y + 1, rectangle.width, rectangle.height / 2 - 3);
        Area area = new Area(polygon);
        Area area2 = new Area(rectangle4);
        area.intersect(area2);
        JideSwingUtilities.fillGradient(graphics2D, area, ColorUtils.getDerivedColor(color, 0.8f), ColorUtils.getDerivedColor(color, 0.45f), true);
        graphics2D.setColor(color2);
        graphics2D.draw(polygon);
        JideSwingUtilities.fillGradient(graphics2D, polygon2, color, ColorUtils.getDerivedColor(color, 0.65f), true);
        area = new Area(polygon2);
        area.intersect(area2);
        JideSwingUtilities.fillGradient(graphics2D, area, ColorUtils.getDerivedColor(color, 0.8f), ColorUtils.getDerivedColor(color, 0.45f), true);
        graphics2D.setColor(color2);
        graphics2D.draw(polygon2);
    }

    @Override
    public void paintMilestone(Graphics2D graphics2D, TaskBar taskBar, Rectangle rectangle, Insets insets, Color color, Color color2, Color color3) {
        int n = Math.max(insets.left, insets.right);
        int n2 = n * 2;
        Polygon polygon = new Polygon(new int[]{n, n2, n, rectangle.x}, new int[]{rectangle.y, rectangle.y + n, rectangle.y + n2, rectangle.y + n}, 4);
        graphics2D.setColor(color);
        graphics2D.fill(polygon);
    }
}

