/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.StatusBarSeparatorUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.status.StatusBarSeparator;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public class BasicStatusBarSeparatorUI
extends StatusBarSeparatorUI {
    protected Color shadow;
    protected Color highlight;
    private int _size;
    private ThemePainter _painter;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicStatusBarSeparatorUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.installDefaults((StatusBarSeparator)jComponent);
        this.installListeners((StatusBarSeparator)jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((StatusBarSeparator)jComponent);
        this.uninstallListeners((StatusBarSeparator)jComponent);
    }

    protected void installDefaults(StatusBarSeparator statusBarSeparator) {
        this._painter = (ThemePainter)UIDefaultsLookup.get("Theme.painter");
        LookAndFeel.installColors(statusBarSeparator, "StatusBarSeparator.background", "StatusBarSeparator.foreground");
        this._size = UIDefaultsLookup.getInt("StatusBar.gap");
    }

    protected void uninstallDefaults(StatusBarSeparator statusBarSeparator) {
        this._painter = null;
    }

    protected void installListeners(StatusBarSeparator statusBarSeparator) {
        SeparatorPropertyChangeListener separatorPropertyChangeListener = new SeparatorPropertyChangeListener();
        if (separatorPropertyChangeListener != null) {
            statusBarSeparator.putClientProperty(this, separatorPropertyChangeListener);
            statusBarSeparator.addPropertyChangeListener(separatorPropertyChangeListener);
        }
    }

    protected void uninstallListeners(StatusBarSeparator statusBarSeparator) {
        SeparatorPropertyChangeListener separatorPropertyChangeListener = (SeparatorPropertyChangeListener)statusBarSeparator.getClientProperty(this);
        statusBarSeparator.putClientProperty(this, null);
        if (separatorPropertyChangeListener != null) {
            statusBarSeparator.removePropertyChangeListener(separatorPropertyChangeListener);
        }
    }

    public ThemePainter getPainter() {
        return this._painter;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.getPainter().paintStatusBarSeparator(jComponent, graphics, new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()), JideSwingUtilities.getOrientationOf(jComponent), 0);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        StatusBarSeparator statusBarSeparator = (StatusBarSeparator)jComponent;
        if (statusBarSeparator.getOrientation() == 0) {
            return new Dimension(this._size, 0);
        }
        return new Dimension(0, this._size);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    protected class SeparatorPropertyChangeListener
    implements PropertyChangeListener {
        protected SeparatorPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                Component component = (Component)propertyChangeEvent.getSource();
                component.repaint();
            }
        }
    }
}

