/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.JideTable;
import com.jidesoft.plaf.TableUIDelegate;
import com.jidesoft.utils.PortingUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicJideTableUIDelegate
implements TableUIDelegate {
    protected JTable table;
    protected CellRendererPane rendererPane;

    public BasicJideTableUIDelegate(JTable jTable, CellRendererPane cellRendererPane) {
        this.table = jTable;
        this.rendererPane = cellRendererPane;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            this.paintDropLines(graphics);
            return;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        Point point = rectangle.getLocation();
        if (!bl) {
            ++point.x;
        }
        Point point2 = new Point(rectangle.x + rectangle.width - (bl ? 1 : 0), rectangle.y + rectangle.height);
        int n = this.table.rowAtPoint(point);
        int n2 = this.table.rowAtPoint(point2);
        boolean bl2 = false;
        if (n == -1) {
            n = 0;
            bl2 = true;
        }
        if (n2 == -1) {
            n2 = this.table.getRowCount() - 1;
        }
        if (bl2 && !SystemInfo.isJdk6Above() && n2 == this.table.getRowCount() - 1) {
            Dimension dimension = PortingUtils.getLocalScreenSize(this.table);
            if (rectangle.y > dimension.height) {
                n = n2 - this.table.getVisibleRect().height / this.table.getRowHeight() - 1;
            }
        }
        int n3 = this.table.columnAtPoint(bl ? point : point2);
        int n4 = this.table.columnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(graphics, n, n2, n3, n4);
        if (!(this.table instanceof JideTable) || ((JideTable)this.table).isCellContentVisible()) {
            this.paintCells(graphics, n, n2, n3, n4);
        }
        this.paintDropLines(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintDropLines(Graphics graphics) {
        Class clazz;
        if (SystemInfo.isJdk6Above() && (clazz = this.table.getDropLocation()) == null) {
            return;
        }
        for (clazz = this.table.getUI().getClass(); clazz != BasicTableUI.class && clazz != null; clazz = clazz.getSuperclass()) {
        }
        if (clazz != null) {
            Color color = null;
            if (this.table.getSelectedColumn() < 0) {
                color = UIManager.getColor("Table.dropLineShortColor");
            }
            try {
                if (this.table.getSelectedColumn() < 0) {
                    UIManager.getDefaults().put("Table.dropLineShortColor", UIManager.getColor("Table.dropLineColor"));
                }
                this.superPaintDropLines(graphics);
            }
            catch (Exception exception) {
            }
            finally {
                if (color != null) {
                    UIManager.getDefaults().put("Table.dropLineShortColor", color);
                }
            }
        }
    }

    private Rectangle getHDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n = dropLocation.getRow();
        int n2 = dropLocation.getColumn();
        if (n2 >= this.table.getColumnCount()) {
            --n2;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (n >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(JTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n, true);
        if (n >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    private void superPaintDropLines(Graphics graphics) {
        int n;
        int n2;
        JTable.DropLocation dropLocation = this.table.getDropLocation();
        if (dropLocation == null) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertColumn() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(n2, rectangle.y, n, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n2 = rectangle.y;
            n = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            if (!dropLocation.isInsertRow() && color2 != null) {
                graphics.setColor(color2);
                graphics.fillRect(rectangle.x, n2, rectangle.width, n);
            }
        }
    }

    public void paintGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        block15: {
            int n5;
            int n6;
            Rectangle rectangle = this.table.getCellRect(n, n3, true);
            Rectangle rectangle2 = this.table.getCellRect(n2, n4, true);
            Rectangle rectangle3 = rectangle.union(rectangle2);
            int n7 = -1;
            int n8 = rectangle3.y;
            if (this.table.getShowHorizontalLines()) {
                n6 = rectangle3.x + rectangle3.width;
                for (n5 = n; n5 <= n2; ++n5) {
                    Color color;
                    Color color2 = color = this.table instanceof JideTable ? ((JideTable)this.table).getGridColor(n5) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    graphics.drawLine(rectangle3.x, (n8 += this.table.getRowHeight(n5)) - 1, n6 - 1, n8 - 1);
                    if (n5 != n2) continue;
                    n7 = n8 - 1 - rectangle3.y;
                }
            } else if (this.table instanceof JideTable && ((JideTable)this.table).isRowAutoResizes()) {
                for (n6 = n; n6 <= n2; ++n6) {
                    n8 += this.table.getRowHeight(n6);
                    if (n6 != n2) continue;
                    n7 = n8 - 1 - rectangle3.y;
                }
            }
            graphics.setColor(this.table.getGridColor());
            if (!this.table.getShowVerticalLines()) break block15;
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n5 = Math.max(rectangle3.y + rectangle3.height, n7);
            if (this.table.getComponentOrientation().isLeftToRight()) {
                int n9 = rectangle3.x;
                for (int i = n3; i <= n4; ++i) {
                    Color color;
                    Color color3 = color = this.table instanceof JideTable ? ((JideTable)this.table).getVerticalGridColor(i) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    int n10 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n9 += n10) - 1, 0, n9 - 1, n5 - 1);
                }
            } else {
                int n11 = rectangle3.x;
                graphics.drawLine(n11, 0, n11, n5 - 1);
                for (int i = n4; i >= n3; --i) {
                    Color color;
                    Color color4 = color = this.table instanceof JideTable ? ((JideTable)this.table).getVerticalGridColor(i) : null;
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(this.table.getGridColor());
                    }
                    int n12 = tableColumnModel.getColumn(i).getWidth();
                    graphics.drawLine((n11 += n12) - 1, 0, n11 - 1, n5 - 1);
                }
            }
        }
    }

    protected int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n5 = tableColumnModel.getColumnMargin();
        boolean bl2 = bl = this.table instanceof JideTable && ((JideTable)this.table).alwaysCalculateCellRect();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                for (int j = n3; j <= n4; ++j) {
                    Rectangle rectangle2 = null;
                    if (this.table.isEditing() && this.table.getEditingRow() == i && this.table.getEditingColumn() == j) {
                        rectangle2 = ((JideTable)this.table).getEditorCellRect(i, j);
                    }
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    int n6 = tableColumn2.getWidth();
                    rectangle.width = n6 - n5;
                    if (tableColumn2 != tableColumn && rectangle.width > 0) {
                        if (bl && rectangle2 != null) {
                            this.adjustCellEditor(graphics, rectangle2, i, j);
                        }
                        this.paintCell(graphics, rectangle, i, j);
                    }
                    rectangle.x += n6;
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                Rectangle rectangle = this.table.getCellRect(i, n3, false);
                for (int j = n3; j <= n4; ++j) {
                    Rectangle rectangle3 = null;
                    if (this.table.isEditing() && this.table.getEditingRow() == i && this.table.getEditingColumn() == j) {
                        rectangle3 = ((JideTable)this.table).getEditorCellRect(i, j);
                    }
                    TableColumn tableColumn3 = tableColumnModel.getColumn(j);
                    int n7 = tableColumn3.getWidth();
                    if (j != n3) {
                        rectangle.x -= n7;
                    }
                    rectangle.width = n7 - n5;
                    if (tableColumn3 == tableColumn || rectangle.width <= 0) continue;
                    if (bl && rectangle3 != null) {
                        this.adjustCellEditor(graphics, rectangle3, i, j);
                    }
                    this.paintCell(graphics, rectangle, i, j);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    public void paintDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5 = this.viewIndexForColumn(tableColumn);
        if (n5 < 0) {
            return;
        }
        Rectangle rectangle = this.table.getCellRect(n, n5, true);
        Rectangle rectangle2 = this.table.getCellRect(n2, n5, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(this.table.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n4 = rectangle3.x;
            int n6 = rectangle3.y;
            int n7 = n4 + rectangle3.width - 1;
            int n8 = n6 + rectangle3.height - 1;
            graphics.drawLine(n4 - 1, n6, n4 - 1, n8);
            graphics.drawLine(n7, n6, n7, n8);
        }
        for (n4 = n; n4 <= n2; ++n4) {
            Color color;
            Rectangle rectangle4 = this.table.getCellRect(n4, n5, false);
            rectangle4.x += n3;
            this.paintCell(graphics, rectangle4, n4, n5);
            if (!this.table.getShowHorizontalLines()) continue;
            Color color2 = color = this.table instanceof JideTable ? ((JideTable)this.table).getGridColor(n4) : null;
            if (color != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(this.table.getGridColor());
            }
            Rectangle rectangle5 = this.table.getCellRect(n4, n5, true);
            rectangle5.x += n3;
            int n9 = rectangle5.x;
            int n10 = rectangle5.y;
            int n11 = n9 + rectangle5.width - 1;
            int n12 = n10 + rectangle5.height - 1;
            graphics.drawLine(n9, n12, n11, n12);
        }
    }

    public void paintCell(Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics graphics2;
        Object object;
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            object = ((JideTable)this.table).getEditorCellRect(n, n2);
            if (rectangle != null && rectangle.equals(object)) {
                return;
            }
        }
        if (rectangle == null) {
            return;
        }
        object = this.table.getCellRenderer(n, n2);
        if (object == null) {
            return;
        }
        Component component = this.table.prepareRenderer((TableCellRenderer)object, n, n2);
        if (component != null) {
            component.setComponentOrientation(this.table.getComponentOrientation());
        }
        if (this.table instanceof JideTable) {
            graphics2 = graphics.create();
            ((JideTable)this.table).paintCellUnderlay(graphics2, component, n, n2, rectangle);
            graphics2.dispose();
        }
        this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        if (component != null) {
            this.rendererPane.remove(component);
        }
        if (this.table instanceof JideTable) {
            graphics2 = graphics.create();
            ((JideTable)this.table).paintCellOverlay(graphics2, component, n, n2, rectangle);
            graphics2.dispose();
        }
        if (this.table instanceof JideTable) {
            ((JideTable)this.table).releaseRendererComponent((TableCellRenderer)object, n, n2, component);
        }
    }

    protected void adjustCellEditor(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (this.table.isEditing() && this.table.getEditingRow() == n && this.table.getEditingColumn() == n2) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }
}

