/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellSpanTable;
import com.jidesoft.plaf.basic.BasicNavigableTableUIDelegate;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashSet;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class BasicCellSpanTableUIDelegate
extends BasicNavigableTableUIDelegate {
    private Set<Cell> _paintedCell = new HashSet<Cell>();

    public BasicCellSpanTableUIDelegate(JTable jTable, CellRendererPane cellRendererPane) {
        super(jTable, cellRendererPane);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl;
        if (!(this.table instanceof CellSpanTable)) {
            super.paint(graphics, jComponent);
            return;
        }
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        if (!cellSpanTable.isCellSpanOn()) {
            super.paint(graphics, jComponent);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = this.table.getBounds();
        rectangle2.y = 0;
        rectangle2.x = 0;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0 || !rectangle2.intersects(rectangle)) {
            return;
        }
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n = cellSpanTable.originalRowAtPoint(point);
        int n2 = cellSpanTable.originalRowAtPoint(point2);
        if (n == -1) {
            n = 0;
        }
        if (n2 == -1) {
            n2 = cellSpanTable.getRowCount() - 1;
        }
        int n3 = cellSpanTable.originalColumnAtPoint((bl = cellSpanTable.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n4 = cellSpanTable.originalColumnAtPoint(bl ? point2 : point);
        if (n3 == -1) {
            n3 = 0;
        }
        if (n4 == -1) {
            n4 = cellSpanTable.getColumnCount() - 1;
        }
        this.paintSpanGrid(graphics, n, n2, n3, n4);
        this.paintSpanCells(graphics, n, n2, n3, n4);
        this.paintDropLines(graphics);
    }

    private void paintSpanGrid(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        Rectangle rectangle = cellSpanTable.originalGetCellRect(n, n3, true);
        Rectangle rectangle2 = cellSpanTable.originalGetCellRect(n2, n4, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        boolean bl = cellSpanTable.getComponentOrientation().isLeftToRight();
        graphics.setColor(cellSpanTable.getGridColor());
        if (cellSpanTable.getShowVerticalLines()) {
            int n8;
            CellSpan cellSpan;
            int n9;
            Color color;
            int n10;
            TableColumnModel tableColumnModel = cellSpanTable.getColumnModel();
            if (bl) {
                n7 = rectangle3.x;
                for (n10 = n3; n10 <= n4; ++n10) {
                    color = cellSpanTable.getVerticalGridColor(n10);
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(cellSpanTable.getGridColor());
                    }
                    n6 = rectangle3.y;
                    n7 += n10 >= 0 && n10 < tableColumnModel.getColumnCount() ? tableColumnModel.getColumn(n10).getWidth() : 0;
                    for (n9 = n; n9 <= n2; ++n9) {
                        cellSpan = cellSpanTable.getCellSpanAt(n9, n10);
                        n5 = 0;
                        if (cellSpan == null) {
                            n5 = 1;
                        } else {
                            n8 = Math.min(cellSpan.getColumn() + cellSpan.getColumnSpan() - 1, tableColumnModel.getColumnCount() - 1);
                            if (n10 == n8) {
                                n5 = 1;
                            } else {
                                int n11;
                                for (n11 = n10 + 1; n11 <= n8 && tableColumnModel.getColumn(n11).getWidth() == 0; ++n11) {
                                }
                                if (n11 > n8) {
                                    n5 = 1;
                                }
                            }
                        }
                        n8 = cellSpanTable.getRowHeight(n9);
                        if (n5 != 0) {
                            graphics.drawLine(n7 - 1, n6, n7 - 1, n6 + n8 - 1);
                        }
                        n6 += n8;
                    }
                }
            } else {
                n7 = rectangle3.x + rectangle3.width;
                for (n10 = n3; n10 < n4; ++n10) {
                    color = cellSpanTable.getVerticalGridColor(n10);
                    if (color != null) {
                        graphics.setColor(color);
                    } else {
                        graphics.setColor(cellSpanTable.getGridColor());
                    }
                    n6 = rectangle3.y;
                    n7 -= n10 >= 0 && n10 < tableColumnModel.getColumnCount() ? tableColumnModel.getColumn(n10).getWidth() : 0;
                    for (n9 = n; n9 <= n2; ++n9) {
                        cellSpan = cellSpanTable.getCellSpanAt(n9, n10);
                        n5 = cellSpan == null || n10 == cellSpan.getColumn() + cellSpan.getColumnSpan() - 1 ? 1 : 0;
                        n8 = cellSpanTable.getRowHeight(n9);
                        if (n5 != 0) {
                            graphics.drawLine(n7 - 1, n6, n7 - 1, n6 + n8 - 1);
                        }
                        n6 += n8;
                    }
                }
            }
        }
        graphics.setColor(cellSpanTable.getGridColor());
        if (cellSpanTable.getShowHorizontalLines()) {
            int n12 = rectangle3.y;
            for (n7 = n; n7 <= n2; ++n7) {
                n6 = bl ? rectangle3.x : rectangle3.x + rectangle3.width;
                n12 += cellSpanTable.getRowHeight(n7);
                Color color = cellSpanTable.getGridColor(n7);
                if (color != null) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(cellSpanTable.getGridColor());
                }
                for (int i = n3; i <= n4; ++i) {
                    CellSpan cellSpan = cellSpanTable.getCellSpanAt(n7, i);
                    boolean bl2 = cellSpan == null || n7 == cellSpan.getRow() + cellSpan.getRowSpan() - 1;
                    int n13 = n5 = i >= 0 && i < cellSpanTable.getColumnModel().getColumnCount() ? cellSpanTable.getColumnModel().getColumn(i).getWidth() : 0;
                    if (bl2) {
                        if (bl) {
                            graphics.drawLine(n6, n12 - 1, n6 + n5 - 1, n12 - 1);
                        } else {
                            graphics.drawLine(n6, n12 - 1, n6 - n5 - 1, n12 - 1);
                        }
                    }
                    if (bl) {
                        n6 += n5;
                        continue;
                    }
                    n6 -= n5;
                }
            }
        }
    }

    private void addPaintedCell(Cell cell) {
        this._paintedCell.add(cell);
    }

    private boolean isCellPainted(Cell cell) {
        return this._paintedCell.contains(cell);
    }

    private void paintSpanCells(Graphics graphics, int n, int n2, int n3, int n4) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        this._paintedCell.clear();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    Cell cell;
                    TableColumn tableColumn2;
                    Rectangle rectangle;
                    CellSpan cellSpan = cellSpanTable.getCellSpanAt(i, j);
                    if (cellSpan != null) {
                        int n5;
                        int n6 = cellSpan.getRow();
                        Cell cell2 = new Cell(n6, n5 = cellSpan.getColumn());
                        if (this.isCellPainted(cell2) || n6 != i && n5 != j) continue;
                        rectangle = this.table.getCellRect(i, j, false);
                        tableColumn2 = tableColumnModel.getColumn(j);
                        if (tableColumn2 == tableColumn) continue;
                        this.paintCell(graphics, rectangle, n6, n5);
                        this.addPaintedCell(cell2);
                        continue;
                    }
                    rectangle = this.table.getCellRect(i, j, false);
                    tableColumn2 = tableColumnModel.getColumn(j);
                    if (tableColumn2 == tableColumn || this.isCellPainted(cell = new Cell(i, j))) continue;
                    this.paintCell(graphics, rectangle, i, j);
                    this.addPaintedCell(cell);
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                for (int j = n3; j <= n4; ++j) {
                    Cell cell;
                    TableColumn tableColumn3;
                    Rectangle rectangle;
                    CellSpan cellSpan = cellSpanTable.getCellSpanAt(i, j);
                    if (cellSpan != null) {
                        int n7;
                        int n8 = cellSpan.getRow();
                        Cell cell3 = new Cell(n8, n7 = cellSpan.getColumn());
                        if (this.isCellPainted(cell3) || n8 != i && n7 != j) continue;
                        rectangle = this.table.getCellRect(i, j, false);
                        tableColumn3 = tableColumnModel.getColumn(j);
                        if (tableColumn3 == tableColumn) continue;
                        this.paintCell(graphics, rectangle, n8, n7);
                        this.addPaintedCell(cell3);
                        continue;
                    }
                    rectangle = this.table.getCellRect(i, j, false);
                    tableColumn3 = tableColumnModel.getColumn(j);
                    if (tableColumn3 == tableColumn || this.isCellPainted(cell = new Cell(i, j))) continue;
                    this.paintCell(graphics, rectangle, i, j);
                    this.addPaintedCell(cell);
                }
            }
        }
        if (tableColumn != null) {
            this.paintSpanDraggedArea(graphics, n, n2, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    protected void paintSpanDraggedArea(Graphics graphics, int n, int n2, TableColumn tableColumn, int n3) {
        int n4;
        int n5;
        CellSpanTable cellSpanTable = (CellSpanTable)this.table;
        int n6 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = cellSpanTable.originalGetCellRect(n, n6, true);
        Rectangle rectangle2 = cellSpanTable.originalGetCellRect(n2, n6, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n3;
        graphics.setColor(cellSpanTable.getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        if (cellSpanTable.getShowVerticalLines()) {
            graphics.setColor(cellSpanTable.getGridColor());
            n5 = rectangle3.x;
            int n7 = rectangle3.y;
            int n8 = n5 + rectangle3.width - 1;
            n4 = n7 + rectangle3.height - 1;
            graphics.drawLine(n5 - 1, n7, n5 - 1, n4);
            graphics.drawLine(n8, n7, n8, n4);
        }
        for (n5 = n; n5 <= n2; ++n5) {
            CellSpan cellSpan = cellSpanTable.getCellSpanAt(n5, n6);
            if (cellSpan == null || cellSpan.getColumn() == n6) {
                Rectangle rectangle4 = cellSpanTable.getCellRect(n5, n6, false);
                rectangle4.x += n3;
                this.paintCell(graphics, rectangle4, n5, n6);
            }
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(cellSpanTable.getGridColor());
            Rectangle rectangle5 = cellSpanTable.getCellRect(n5, n6, true);
            rectangle5.x += n3;
            n4 = rectangle5.x;
            int n9 = rectangle5.y;
            int n10 = n4 + rectangle5.width - 1;
            int n11 = n9 + rectangle5.height - 1;
            graphics.drawLine(n4, n11, n10, n11);
        }
    }

    private class Cell {
        int row;
        int column;

        public Cell(int n, int n2) {
            this.row = n;
            this.column = n2;
        }

        public int hashCode() {
            int n = this.row;
            n = 29 * n + this.column;
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Cell) {
                Cell cell = (Cell)object;
                return this.row == cell.row && this.column == cell.column;
            }
            return super.equals(object);
        }
    }
}

