/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.aqua;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.aqua.AquaDockableFrameTitlePane;
import com.jidesoft.plaf.aqua.AquaJideUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

class AquaDFButtonIcon
implements Icon {
    static ImageIcon HIDE_BUTTON_ICONS = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/hide_buttons.gif");
    static Icon HIDE_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 0, 0, 12, 13);
    static Icon HIDE_FOCUSED_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 12, 0, 12, 13);
    static Icon HIDE_PRESSED_ICON = IconsFactory.getIcon(null, HIDE_BUTTON_ICONS, 24, 0, 12, 13);
    static ImageIcon TITLE_BUTTON_ICONS = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/title_buttons.gif");
    static final int SIZE = 11;
    static Icon FLOAT_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 0, 11, 11);
    static Icon FLOAT_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 11, 0, 11, 11);
    static Icon FLOAT_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 22, 0, 11, 11);
    static Icon DOCK_ICON = FLOAT_ICON;
    static Icon DOCK_FOCUSED_ICON = FLOAT_FOCUSED_ICON;
    static Icon DOCK_PRESSED_ICON = FLOAT_PRESSED_ICON;
    static Icon AUTOHIDE_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 11, 11, 11);
    static Icon AUTOHIDE_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 11, 11, 11, 11);
    static Icon AUTOHIDE_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 22, 11, 11, 11);
    static Icon STOP_AUTOHIDE_ICON = AUTOHIDE_ICON;
    static Icon STOP_AUTOHIDE_FOCUSED_ICON = AUTOHIDE_FOCUSED_ICON;
    static Icon STOP_AUTOHIDE_PRESSED_ICON = AUTOHIDE_PRESSED_ICON;
    static Icon MAXIMIZE_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 0, 22, 11, 11);
    static Icon MAXIMIZE_FOCUSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 11, 22, 11, 11);
    static Icon MAXIMIZE_PRESSED_ICON = IconsFactory.getIcon(null, TITLE_BUTTON_ICONS, 22, 22, 11, 11);
    static Icon RESTORE_ICON = MAXIMIZE_ICON;
    static Icon RESTORE_FOCUSED_ICON = MAXIMIZE_FOCUSED_ICON;
    static Icon RESTORE_PRESSED_ICON = MAXIMIZE_PRESSED_ICON;
    static Icon DISABLED_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/disabled.gif");
    static Icon EMPTY_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/empty.gif");
    static Icon GRAPHITE_ICON = IconsFactory.getImageIcon(AquaDFButtonIcon.class, "icons/graphite.gif");
    private JButton _button;
    private DockableFrame _frame;
    private AquaDockableFrameTitlePane _titlePane;
    private int _type;

    public AquaDFButtonIcon(DockableFrame dockableFrame, AquaDockableFrameTitlePane aquaDockableFrameTitlePane, JButton jButton, int n) {
        this._type = n;
        this._frame = dockableFrame;
        this._button = jButton;
        this._titlePane = aquaDockableFrameTitlePane;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        boolean bl = this._titlePane.anyRollovers();
        ButtonModel buttonModel = this._button.getModel();
        boolean bl2 = buttonModel.isPressed() && buttonModel.isArmed();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Icon icon = null;
        boolean bl3 = UIDefaultsLookup.getBoolean("DockableFrame.usingMacStandardIcons");
        if (AquaJideUtils.isGraphite() && (bl2 || bl) && this.getType() != 0) {
            icon = GRAPHITE_ICON;
        } else {
            switch (this.getType()) {
                case 0: {
                    if (bl2) {
                        icon = bl3 ? FLOAT_PRESSED_ICON : HIDE_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = bl3 ? FLOAT_FOCUSED_ICON : HIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = bl3 ? FLOAT_ICON : HIDE_ICON;
                    break;
                }
                case 1: {
                    if (bl2) {
                        icon = AUTOHIDE_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = AUTOHIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = AUTOHIDE_ICON;
                    break;
                }
                case 2: {
                    if (bl2) {
                        icon = STOP_AUTOHIDE_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = STOP_AUTOHIDE_FOCUSED_ICON;
                        break;
                    }
                    icon = STOP_AUTOHIDE_ICON;
                    break;
                }
                case 3: {
                    if (bl2) {
                        icon = FLOAT_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = FLOAT_FOCUSED_ICON;
                        break;
                    }
                    icon = FLOAT_ICON;
                    break;
                }
                case 4: {
                    if (bl2) {
                        icon = DOCK_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = DOCK_FOCUSED_ICON;
                        break;
                    }
                    icon = DOCK_ICON;
                    break;
                }
                case 5: {
                    if (bl2) {
                        icon = MAXIMIZE_PRESSED_ICON;
                        break;
                    }
                    if (bl) {
                        icon = MAXIMIZE_FOCUSED_ICON;
                        break;
                    }
                    icon = MAXIMIZE_ICON;
                    break;
                }
                case 6: {
                    icon = bl2 ? RESTORE_PRESSED_ICON : (bl ? RESTORE_FOCUSED_ICON : RESTORE_ICON);
                }
            }
        }
        if (icon != null) {
            icon.paintIcon(component, graphics2D, n, n2);
        }
        graphics2D.dispose();
    }

    @Override
    public int getIconWidth() {
        return 11;
    }

    @Override
    public int getIconHeight() {
        return 11;
    }
}

