/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.QuickFilterField;
import com.jidesoft.pivot.FieldBox;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.UnassignedFieldsArea;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;

class QuickUnassignedFieldsAreaFilterField
extends QuickFilterField {
    private UnassignedFieldsArea _fieldsArea;
    private JComponent[] _components;

    public QuickUnassignedFieldsAreaFilterField(UnassignedFieldsArea unassignedFieldsArea, JComponent[] jComponentArray) {
        this._fieldsArea = unassignedFieldsArea;
        this._components = jComponentArray;
        this.setWildcardEnabled(true);
    }

    @Override
    protected JTextField createTextField() {
        JTextField jTextField = super.createTextField();
        jTextField.setColumns(4);
        return jTextField;
    }

    @Override
    protected String convertElementToString(Object object) {
        if (object instanceof FieldBox) {
            return ((FieldBox)object).getField().getTitle();
        }
        if (object instanceof PivotField) {
            return ((PivotField)object).getTitle();
        }
        return super.convertElementToString(object);
    }

    @Override
    public void applyFilter(String string) {
        List<FieldBox> list = this._fieldsArea.getFieldBoxes();
        FieldBox[] fieldBoxArray = list.toArray(new FieldBox[list.size()]);
        this._fieldsArea.removeAll();
        for (FieldBox fieldBox : fieldBoxArray) {
            if (!this.compare(fieldBox, string) || fieldBox.getParent() == this._fieldsArea) continue;
            this._fieldsArea.add(fieldBox);
        }
        boolean bl = this._fieldsArea.getComponentCount() != 0;
        this.adjustMismatchColor(bl);
        if (this._components != null) {
            for (JComponent jComponent : this._components) {
                jComponent.setEnabled(bl);
            }
        }
        this._fieldsArea.invalidate();
        this._fieldsArea.getParent().doLayout();
    }
}

