/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.CompoundKeyMap;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class PivotDataCube {
    private final Set<CompoundKey> _rowHeaderMap = new LinkedHashSet<CompoundKey>();
    private final Set<CompoundKey> _columnHeaderMap = new LinkedHashSet<CompoundKey>();
    private final CompoundKeyMap _dataMap = new CompoundKeyMap(new String[]{"Row", "Column"});

    public List addValue(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        this._rowHeaderMap.add(compoundKey);
        this._columnHeaderMap.add(compoundKey2);
        if (n >= 0) {
            return this._dataMap.addValue(compoundKey, compoundKey2, n);
        }
        return null;
    }

    public List addPrefixValue(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        return this._dataMap.addValue(compoundKey, compoundKey2, n);
    }

    public boolean hasRowKey(CompoundKey compoundKey) {
        return this._rowHeaderMap.contains(compoundKey);
    }

    public boolean hasColumnKey(CompoundKey compoundKey) {
        return this._columnHeaderMap.contains(compoundKey);
    }

    public CompoundKey[] getRowKeys() {
        return this._rowHeaderMap.toArray(new CompoundKey[this._rowHeaderMap.size()]);
    }

    public CompoundKey[] getColumnKeys() {
        return this._columnHeaderMap.toArray(new CompoundKey[this._columnHeaderMap.size()]);
    }

    public List getValues(CompoundKey compoundKey, CompoundKey compoundKey2) {
        return this.getValues(compoundKey, compoundKey2, true);
    }

    public List getValues(CompoundKey compoundKey, CompoundKey compoundKey2, boolean bl) {
        return this._dataMap.getValues(compoundKey, compoundKey2, bl);
    }

    public Set getValuesAsSet(CompoundKey compoundKey, CompoundKey compoundKey2) {
        return this._dataMap.getValuesAsSet(compoundKey, compoundKey2);
    }

    public boolean removeRowKey(CompoundKey compoundKey) {
        return this._rowHeaderMap.remove(compoundKey);
    }

    public boolean removeColumnKey(CompoundKey compoundKey) {
        return this._columnHeaderMap.remove(compoundKey);
    }

    public void clear() {
        this._rowHeaderMap.clear();
        this._columnHeaderMap.clear();
        this._dataMap.clear();
    }

    void calculateStartNotice() {
        this._dataMap.setNeedLookBack(false);
    }

    void calculateEndNotice() {
        this._dataMap.setNeedLookBack(true);
    }

    boolean isCalculating() {
        return !this._dataMap.isNeedLookBack();
    }

    public void clearEmptyValues() {
        this._dataMap.clearEmptyValues();
    }

    public void setRowKeyLength(int n) {
        this._dataMap.setRowKeyLength(n);
    }

    public void setColumnKeyLength(int n) {
        this._dataMap.setColumnKeyLength(n);
    }

    public Set<CompoundKey> getKeys() {
        return this._dataMap.keySet();
    }

    public Object getValue(CompoundKey compoundKey) {
        return this._dataMap.get(compoundKey);
    }

    public Object removeKey(CompoundKey compoundKey) {
        return this._dataMap.remove(compoundKey);
    }

    public boolean renameKey(CompoundKey compoundKey, CompoundKey compoundKey2) {
        Object object = this.removeKey(compoundKey);
        if (object instanceof List && ((List)object).size() == 1) {
            Object[] objectArray = compoundKey2.getKeys();
            this._dataMap.addValue((CompoundKey)objectArray[0], (CompoundKey)objectArray[1], (Integer)((List)object).get(0));
        } else {
            this._dataMap.put(compoundKey2, object);
        }
        return object != null;
    }

    public CompoundKey[] removeValue(int n) {
        return this._dataMap.removeValue(n);
    }

    public CompoundKey[] getValue(int n) {
        return this._dataMap.getValue(n);
    }

    public void rowsInserted(int n, int n2) {
        this._dataMap.insertValues(n, n2);
    }

    public CompoundKey[] rowsDeleted(int n, int n2) {
        return this._dataMap.removeValues(n, n2);
    }

    public boolean verify() {
        HashMap<Object, CompoundKey> hashMap = new HashMap<Object, CompoundKey>();
        Set set = this._dataMap.keySet();
        block0: for (CompoundKey compoundKey : set) {
            Comparable<Integer> comparable;
            Object object3;
            CompoundKey compoundKey2 = (CompoundKey)compoundKey.getKeys()[0];
            CompoundKey compoundKey3 = (CompoundKey)compoundKey.getKeys()[1];
            boolean bl = compoundKey2.getKeyCount() == this.getRowKeys().length && compoundKey3.getKeyCount() == this.getColumnKeys().length;
            Object object2 = this._dataMap.get(compoundKey);
            if (bl && object2 instanceof Integer) {
                int n = (Integer)object2;
                CompoundKey compoundKey4 = (CompoundKey)hashMap.get(n);
                if (compoundKey4 != null) {
                    System.out.println("Row index duplicated: " + compoundKey4 + " <<>> " + compoundKey);
                }
                hashMap.put(n, compoundKey);
                continue;
            }
            if (!(object2 instanceof List)) continue;
            List list = (List)object2;
            if (bl) {
                for (Object object3 : list) {
                    comparable = (CompoundKey)hashMap.get(object3);
                    if (comparable != null) {
                        System.out.println("Row index duplicated: " + comparable + " <<>> " + compoundKey);
                    }
                    hashMap.put(object3, compoundKey);
                }
            }
            int n = -1;
            object3 = list.iterator();
            while (object3.hasNext()) {
                comparable = (Integer)object3.next();
                if ((Integer)comparable <= n) {
                    System.out.print("Index is not sorted: " + compoundKey + " " + PivotDataCube.printArray(list.toArray(), true, false));
                    continue block0;
                }
                n = (Integer)comparable;
            }
        }
        System.out.println("Verification is OK!");
        return true;
    }

    private static String printArray(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append('{');
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) {
                stringBuffer.append(bl2 ? "\"" : "");
                stringBuffer.append(objectArray[i].toString());
                stringBuffer.append(bl2 ? "\"" : "");
            } else {
                stringBuffer.append("null");
            }
            if (i >= objectArray.length - 1) continue;
            stringBuffer.append(", ");
        }
        if (bl) {
            stringBuffer.append('}');
        }
        return stringBuffer.toString();
    }
}

