/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.pivot.DataTable;
import com.jidesoft.pivot.FieldArea;
import com.jidesoft.pivot.FieldBox;
import com.jidesoft.pivot.HeaderTable;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.UnassignedFieldsArea;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.ShadowFactory;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;

public class FieldBoxInputListener
implements MouseListener,
MouseMotionListener,
KeyListener,
ActionListener {
    private PivotTablePane _pane;
    private static final int OFFSET = 2;
    private int _distanceX = 0;
    private int _distanceY = 0;
    private int _positionX = 0;
    private int _positionY = 0;
    boolean _isDragging = false;
    private boolean _shouldCancel = true;
    private boolean _dropAllowed = true;
    private int _deltaX;
    private int _deltaY;
    private BufferedImage _image;
    private BufferedImage _shadow;
    boolean _isAboutToDrag = false;
    private Point _startLocation;
    private Rectangle _dropArea = null;
    private Container _dropContainer = null;
    private int _dropSide = -1;
    private static final float ANGLE = 90.0f;
    private static final int DISTANCE = 5;

    public FieldBoxInputListener(PivotTablePane pivotTablePane) {
        this._pane = pivotTablePane;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this._pane);
            this._pane.showPopup(point);
            return;
        }
        if (!this._pane.isRearrangable()) {
            return;
        }
        if (SwingUtilities.isLeftMouseButton(mouseEvent) && !this._isAboutToDrag && !this._isDragging) {
            this._isAboutToDrag = true;
            this._startLocation = mouseEvent.getPoint();
            this._startLocation = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), this._startLocation, this._pane);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this._pane);
            this._pane.showPopup(point);
            return;
        }
        if (!this._pane.isRearrangable()) {
            return;
        }
        if (this._isDragging) {
            this.endDragging((Component)mouseEvent.getSource());
        } else {
            this.resetAll();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof FieldBox) {
            final FieldBox fieldBox = (FieldBox)mouseEvent.getSource();
            if (!this._isAboutToDrag && !this._isDragging && fieldBox.isFilterButtonVisible() && this._pane.isShowFilterButtonsOnMouseOver()) {
                fieldBox.showFilterButtonVisible(true);
            }
            if (this._pane.isShowFilterButtonsOnMouseOver()) {
                JideSwingUtilities.setRecursively(fieldBox.getParent(), new JideSwingUtilities.Handler(){

                    @Override
                    public boolean condition(Component component) {
                        return component instanceof FieldBox;
                    }

                    @Override
                    public void action(Component component) {
                        if (!fieldBox.equals(component)) {
                            ((FieldBox)component).showFilterButtonVisible(false);
                        }
                    }

                    @Override
                    public void postAction(Component component) {
                    }
                });
            }
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof FieldBox) {
            FieldBox fieldBox = (FieldBox)mouseEvent.getSource();
            if (!(this._isAboutToDrag || this._isDragging || !fieldBox.isFilterButtonVisible() || !this._pane.isShowFilterButtonsOnMouseOver() || fieldBox.isPopupVisible() || mouseEvent.getX() >= 0 && mouseEvent.getX() < fieldBox.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() < fieldBox.getHeight())) {
                fieldBox.showFilterButtonVisible(false);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._pane.isRearrangable()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this._pane);
        if (this._isAboutToDrag) {
            if (Math.abs(point.x - this._startLocation.x) > 2 || Math.abs(point.y - this._startLocation.y) > 2) {
                this._isDragging = true;
                this.beginDragging((Component)mouseEvent.getSource(), this._startLocation);
                this._isAboutToDrag = false;
            }
        } else if (this._isDragging) {
            this.dragging((Component)mouseEvent.getSource(), point);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27) {
            this.cancelDragging();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public boolean isDragging() {
        return this._isDragging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beginDragging(Component component, Point point) {
        Point point2 = component.getLocation();
        point2 = SwingUtilities.convertPoint(component.getParent(), point2, this._pane);
        this._positionX = point2.x;
        this._positionY = point2.y;
        this._deltaX = point.x - this._positionX;
        this._deltaY = point.y - this._positionY;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        this._image = graphicsConfiguration.createCompatibleImage(component.getWidth(), component.getHeight(), 3);
        boolean bl = false;
        if (component instanceof JComponent && component.isDoubleBuffered()) {
            bl = true;
            ((JComponent)component).setDoubleBuffered(false);
        }
        try {
            component.paint(this._image.getGraphics());
        }
        finally {
            if (bl) {
                ((JComponent)component).setDoubleBuffered(true);
            }
        }
        ShadowFactory shadowFactory = new ShadowFactory(5, 0.5f, Color.BLACK);
        this._shadow = shadowFactory.createShadow(this._image);
        this._isDragging = true;
    }

    protected boolean isDropAllowed(Component component, Rectangle rectangle, int n, Container container) {
        return true;
    }

    private void dragging(Component component, Point point) {
        Serializable serializable;
        Serializable serializable2;
        int n = this._positionX;
        int n2 = this._positionY;
        Rectangle rectangle = this._dropArea;
        this._positionX = point.x - this._deltaX;
        this._positionY = point.y - this._deltaY;
        Component component2 = this._pane.findComponentAt(point);
        Container container = PivotTablePane.getValidParentOf(component, component2);
        boolean bl = this._shouldCancel = component == container;
        if (container instanceof JViewport) {
            container = (Container)((JViewport)container).getView();
        }
        if (component == container) {
            container = null;
        }
        if (container != null) {
            Insets insets;
            if (container instanceof DataTable) {
                container = this._pane.getDataFieldsArea();
            } else if (container instanceof HeaderTable && (serializable2 = ((HeaderTable)container).getHeaderTableModel()) != null) {
                container = ((HeaderTableModel)serializable2).isRowHeader() ? this._pane.getRowFieldsArea() : this._pane.getColumnFieldsArea();
            }
            serializable2 = container.getBounds();
            if (container instanceof FieldArea) {
                insets = container.getInsets();
                ((Rectangle)serializable2).x += insets.left;
                ((Rectangle)serializable2).y += insets.top;
                ((Rectangle)serializable2).width -= insets.left + insets.right;
                ((Rectangle)serializable2).height -= insets.top + insets.bottom;
            }
            serializable2 = SwingUtilities.convertRectangle(container.getParent(), (Rectangle)serializable2, this._pane);
            if (container instanceof FieldBox) {
                if (component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldBox)container).getField().getAreaType())) {
                    int n3 = FieldBoxInputListener.sideOf(point, (Rectangle)serializable2);
                    switch (n3) {
                        case 3: {
                            this._dropArea = new Rectangle(((Rectangle)serializable2).x + ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).y, ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).height);
                            this._dropSide = n3;
                            this._dropContainer = container;
                            break;
                        }
                        case 7: {
                            this._dropArea = new Rectangle(((Rectangle)serializable2).x, ((Rectangle)serializable2).y, ((Rectangle)serializable2).width / 2, ((Rectangle)serializable2).height);
                            this._dropSide = n3;
                            this._dropContainer = container;
                            break;
                        }
                        default: {
                            this.resetDropArea();
                            break;
                        }
                    }
                } else {
                    this.resetDropArea();
                }
            } else if (container instanceof UnassignedFieldsArea) {
                if (container.getComponentCount() > 0) {
                    insets = container.getInsets();
                    serializable = container.getComponent(container.getComponentCount() - 1);
                    this._dropArea = new Rectangle(((Rectangle)serializable2).x + ((Component)serializable).getX() + ((Component)serializable).getWidth() + 2 - insets.left, ((Rectangle)serializable2).y, component.getPreferredSize().width, ((Component)serializable).getHeight());
                    this._dropSide = 3;
                    this._dropContainer = container;
                } else {
                    this.resetDropArea();
                }
            } else if (container instanceof FieldArea) {
                if (container.getComponentCount() > 0 && component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldArea)container).getAreaType())) {
                    insets = container.getInsets();
                    serializable = container.getComponent(container.getComponentCount() - 1);
                    this._dropArea = new Rectangle(((Rectangle)serializable2).x + ((Component)serializable).getX() + ((Component)serializable).getWidth() + 2 - insets.left, ((Rectangle)serializable2).y, component.getPreferredSize().width, ((Component)serializable).getHeight());
                    this._dropSide = 3;
                    this._dropContainer = container;
                } else if (component instanceof FieldBox && ((FieldBox)component).getField().isAllowedAsField(((FieldArea)container).getAreaType())) {
                    this._dropArea = new Rectangle(((Rectangle)serializable2).x, ((Rectangle)serializable2).y, Math.min(((Rectangle)serializable2).width, this._image.getWidth()), ((Rectangle)serializable2).height);
                    this._dropSide = -1;
                    this._dropContainer = container;
                } else {
                    this.resetDropArea();
                }
            } else {
                this.resetDropArea();
            }
        } else {
            this.resetDropArea();
        }
        if (this._pane.isFlatLayout() && this._pane.getScrollPane() != null) {
            serializable2 = this._pane.getScrollPane().getViewport().getBounds();
            Point point2 = SwingUtilities.convertPoint(this._pane.getScrollPane().getViewport(), ((Rectangle)serializable2).getLocation(), this._pane);
            serializable = SwingUtilities.convertPoint(this._pane.getScrollPane().getViewport(), new Point(point2.x + ((Rectangle)serializable2).width, point2.y + ((Rectangle)serializable2).height), this._pane);
            Point point3 = this._pane.getScrollPane().getViewport().getViewPosition();
            Dimension dimension = this._pane.getScrollPane().getViewport().getViewSize();
            if (point.x < point2.x && point3.x > 0) {
                point3.x -= point2.x - point.x;
                if (point3.x < 0) {
                    point3.x = 0;
                }
            } else if (point.x >= ((Point)serializable).x && point3.x < dimension.width - ((Rectangle)serializable2).width) {
                point3.x = Math.min(point3.x + point.x - ((Point)serializable).x, dimension.width - ((Rectangle)serializable2).width);
            }
            if (point.y < point2.y && point3.y > 0) {
                point3.y -= point2.y - point.y;
                if (point3.y < 0) {
                    point3.y = 0;
                }
            } else if (point.y >= ((Point)serializable).y && point3.y < dimension.height - ((Rectangle)serializable2).height) {
                point3.y = Math.min(point3.y + point.y - ((Point)serializable).y, dimension.height - ((Rectangle)serializable2).height);
            }
            this._pane.getScrollPane().getViewport().setViewPosition(point3);
        }
        this._dropAllowed = this.isDropAllowed(component, this._dropArea, this._dropSide, this._dropContainer);
        serializable2 = new Rectangle(n, n2, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
        Rectangle rectangle2 = new Rectangle(this._positionX, this._positionY, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
        this._pane.repaint(rectangle2.union((Rectangle)serializable2));
        if (rectangle != null) {
            this._pane.repaint(rectangle);
        }
        if (this._dropArea != null) {
            this._pane.repaint(this._dropArea);
        }
    }

    private void resetAll() {
        this._pane.setCursor(null);
        this.resetDropArea();
        this._positionX = 0;
        this._positionY = 0;
        this._deltaX = 0;
        this._deltaY = 0;
        this._startLocation = null;
        this._isAboutToDrag = false;
        this._isDragging = false;
    }

    private void resetDropArea() {
        this._dropArea = null;
        this._dropSide = -1;
        this._dropContainer = null;
    }

    private void cancelDragging() {
        if (this._shadow != null && this._image != null) {
            Rectangle rectangle = new Rectangle(this._positionX, this._positionY, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
            this._pane.repaint(rectangle);
        }
        if (this._dropArea != null) {
            this._pane.repaint(this._dropArea);
        }
        this.resetAll();
    }

    private void endDragging(Component component) {
        Object object;
        if (this._shadow != null && this._image != null) {
            object = new Rectangle(this._positionX, this._positionY, this._shadow.getWidth() + this._distanceX, this._shadow.getHeight() + this._distanceY);
            this._pane.repaint((Rectangle)object);
        }
        if (this._dropArea != null) {
            this._pane.repaint(this._dropArea);
        }
        if (!(component instanceof FieldBox) || this._shouldCancel || !this._dropAllowed) {
            this.resetAll();
            return;
        }
        if (this._dropContainer instanceof FieldBox) {
            object = (FieldBox)this._dropContainer;
            FieldBox fieldBox = (FieldBox)component;
            boolean bl = this._pane.getComponentOrientation().isLeftToRight();
            int n = this._dropSide;
            if (!bl) {
                n = this._dropSide == 3 ? 7 : 3;
            }
            switch (n) {
                case 3: {
                    if (!this._pane.validateFieldBoxDragging(fieldBox, (Component)object, false)) break;
                    this._pane.moveFieldBox(fieldBox, (FieldBox)object, false);
                    break;
                }
                case 7: {
                    if (!this._pane.validateFieldBoxDragging(fieldBox, (Component)object, true)) break;
                    this._pane.moveFieldBox(fieldBox, (FieldBox)object, true);
                }
            }
        } else {
            FieldBox fieldBox;
            object = this._pane.getPivotDataModel();
            if (this._dropContainer instanceof FieldArea) {
                FieldBox fieldBox2 = (FieldBox)component;
                FieldArea fieldArea = (FieldArea)this._dropContainer;
                if (this._pane.validateFieldBoxDragging(fieldBox2, fieldArea, false)) {
                    if (object instanceof PivotDataModel) {
                        if (fieldArea.getAreaType() == 3) {
                            fieldBox2.getField().setAreaType(-1);
                            PivotField pivotField = fieldBox2.getField();
                            if (this._pane.isDataFieldsDuplicationEnabled() && pivotField.getAreaType() != 3) {
                                pivotField = ((PivotDataModel)object).duplicateField(pivotField);
                            }
                            fieldBox2 = this._pane.createFieldBox(pivotField, fieldBox2.isSortArrowVisible(), fieldBox2.isFilterButtonVisible());
                        } else if (fieldBox2.getField().getAreaType() == 3 || fieldBox2.getField().getAreaType() == -1) {
                            PivotField pivotField = fieldBox2.getField();
                            int n = pivotField.getModelIndex();
                            while (((PivotDataModel)object).removeDuplicatedField(pivotField)) {
                                pivotField = object.getField(n);
                            }
                            fieldBox2 = this._pane._fieldBoxMap.get(pivotField);
                        }
                    }
                    this._pane.addFieldBox(fieldBox2, fieldArea.getAreaType());
                }
            } else if ((this._pane.isHideFieldOnDraggingOut() || this._dropContainer instanceof UnassignedFieldsArea) && this._pane.validateFieldBoxDragging(fieldBox = (FieldBox)component, null, false)) {
                if (fieldBox.getField().getAreaType() == 3 && object instanceof PivotDataModel) {
                    ((PivotDataModel)object).removeDuplicatedField(fieldBox.getField());
                }
                this._pane.hideFieldBox(fieldBox);
            }
        }
        this.resetAll();
    }

    public BufferedImage getImage() {
        return this._image;
    }

    public BufferedImage getShadow() {
        return this._shadow;
    }

    private void computeShadowPosition(double d) {
        double d2 = Math.toRadians(90.0);
        this._distanceX = (int)(Math.cos(d2) * d);
        this._distanceY = (int)(Math.sin(d2) * d);
    }

    public void drawItem(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this._dropAllowed) {
            if (this._dropArea != null) {
                graphics2D.setColor(Color.DARK_GRAY);
                graphics2D.drawRect(this._dropArea.x, this._dropArea.y, this._dropArea.width - 1, this._dropArea.height - 1);
                graphics2D.drawRect(this._dropArea.x + 1, this._dropArea.y + 1, this._dropArea.width - 3, this._dropArea.height - 3);
                this._pane.setCursor(null);
            } else if (!this._shouldCancel) {
                this._pane.setCursor(this._pane.getDragRemoveCursor());
            } else {
                this._pane.setCursor(null);
            }
        } else {
            this._pane.setCursor(this._pane.getDragNoDropCursor());
        }
        int n = this._shadow.getWidth();
        int n2 = this._shadow.getHeight();
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        int n3 = this._positionX;
        int n4 = this._positionY;
        this.computeShadowPosition(6.0);
        graphics.drawImage(this._shadow, n3 + this._distanceX, n4 + this._distanceY, n, n2, null);
        n = this._image.getWidth();
        n2 = this._image.getHeight();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.6f));
        graphics.drawImage(this._image, n3, n4, n, n2, null);
        graphics2D.setComposite(composite);
    }

    private static int sideOf(Point point, Rectangle rectangle) {
        if (rectangle.contains(point)) {
            if (point.x <= rectangle.x + rectangle.width / 2) {
                return 7;
            }
            if (point.x > rectangle.x + rectangle.width / 2) {
                return 3;
            }
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PivotField pivotField = ((FieldBox)actionEvent.getSource()).getField();
        if (pivotField.getAreaType() == -1) {
            this._pane.selectFieldBox((FieldBox)actionEvent.getSource());
        }
    }
}

