/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.comparator.ObjectComparatorManager;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.DefaultExpandableValue;
import com.jidesoft.pivot.ExpandableValue;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DefaultValues
implements Values,
Comparable {
    private List<Value> _values = new ArrayList<Value>();

    public DefaultValues(ExpandableValue expandableValue) {
        if (this._values != null) {
            while (true) {
                this._values.add(0, expandableValue);
                if (expandableValue.getParent() == null) break;
                expandableValue = (ExpandableValue)expandableValue.getParent();
            }
        }
    }

    public DefaultValues(Value[] valueArray) {
        if (valueArray != null) {
            this._values = new ArrayList<Value>(valueArray.length);
            this._values.addAll(Arrays.asList(valueArray));
        }
    }

    public DefaultValues(List<Value> list) {
        this._values = list;
    }

    public DefaultValues(Object[] objectArray) {
        if (objectArray != null) {
            this._values = new ArrayList<Value>(objectArray.length);
            for (Object object : objectArray) {
                this._values.add(new DefaultExpandableValue(object));
            }
        }
    }

    @Override
    public Value getValueAt(int n) {
        if (n >= 0 && n < this._values.size()) {
            return this._values.get(n);
        }
        return null;
    }

    @Override
    public int getCount() {
        return this._values.size();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DefaultValues defaultValues = (DefaultValues)object;
        return !(this._values == null ? defaultValues._values != null : !this._values.equals(defaultValues._values));
    }

    public int hashCode() {
        return this._values != null ? this._values.hashCode() : 0;
    }

    public CompoundKey toCompoundKey() {
        int n = this._values.size();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            Value value = this._values.get(i);
            Object object = value.getValue();
            objectArray[i] = object instanceof SummaryValue ? ((SummaryValue)object).getValue() : object;
        }
        return CompoundKey.newInstance(objectArray);
    }

    public String toString() {
        return "[DefaultValues] size: " + this._values.size();
    }

    public int compareTo(Object object) {
        if (object instanceof DefaultValues) {
            DefaultValues defaultValues = (DefaultValues)object;
            if (this.getCount() > defaultValues.getCount()) {
                return 1;
            }
            if (this.getCount() < defaultValues.getCount()) {
                return -1;
            }
            for (int i = 0; i < this.getCount(); ++i) {
                Value value;
                Value value2 = this.getValueAt(i);
                int n = ObjectComparatorManager.compare(value2, value = defaultValues.getValueAt(i));
                if (n == 0) continue;
                return n;
            }
        }
        return 0;
    }
}

