/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.PercentConverter;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.ColumnIdentifierTableModel;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.StyleModel;
import com.jidesoft.pivot.CalculatedPivotDataModel;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotCellStyleProvider;
import com.jidesoft.pivot.PivotConstants;
import com.jidesoft.pivot.PivotDataEditingProvider;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.Values;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class DataTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
StyleModel,
PivotConstants,
ColumnIdentifierTableModel {
    private final HeaderTableModel _rowTableModel;
    private final HeaderTableModel _columnTableModel;
    private final PivotDataModel _pivotDataModel;
    private static final long serialVersionUID = 5117913923717688505L;

    public DataTableModel(PivotDataModel pivotDataModel) {
        this._pivotDataModel = pivotDataModel;
        this._rowTableModel = pivotDataModel.getRowHeaderTableModel();
        this._columnTableModel = pivotDataModel.getColumnHeaderTableModel();
    }

    public IPivotDataModel getPivotDataModel() {
        return this._pivotDataModel;
    }

    @Override
    public int getRowCount() {
        return this._rowTableModel.getRowCount();
    }

    @Override
    public String getColumnName(int n) {
        PivotField pivotField = this.getDataFieldAt(this.getRowCount() - 1, n);
        return pivotField == null ? super.getColumnName(n) : pivotField.getTitle();
    }

    @Override
    public Object getColumnIdentifier(int n) {
        PivotField pivotField = this.getDataFieldAt(this.getRowCount() - 1, n);
        return (pivotField == null ? this.getColumnName(n) : pivotField.getName()) + ":::DATA:::" + n;
    }

    @Override
    public int getColumnCount() {
        return this._columnTableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.getPivotDataModel() instanceof CalculatedPivotDataModel) {
            if (this.needDisplayPercentageForGrandTotal(n, n2)) {
                return 1;
            }
            return ((CalculatedPivotDataModel)this.getPivotDataModel()).getValueAt(n, n2);
        }
        PivotField pivotField = this.getDataFieldAt(n, n2);
        if (this._pivotDataModel.shouldCalculateSummary(n, n2)) {
            int n3 = this.getSummaryTypeAt(n, n2, pivotField);
            Object[] objectArray = this._pivotDataModel.collectValuesForCell(pivotField, n, n2, n3);
            return this._pivotDataModel.calculateStatistics(pivotField, n, n2, n3, objectArray);
        }
        Object[] objectArray = this._pivotDataModel.collectValuesForCell(pivotField, n, n2, -1);
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length > 1) {
            int n4 = this.getSummaryTypeAt(n, n2, pivotField);
            return this._pivotDataModel.calculateStatistics(pivotField, n, n2, n4, objectArray);
        }
        return objectArray.length > 0 ? objectArray[0] : null;
    }

    protected boolean needDisplayPercentageForGrandTotal(int n, int n2) {
        List<RunningSummary> list;
        boolean bl = false;
        Values values = this.getPivotDataModel().getRowHeaderTableModel().getValuesAt(n);
        Values values2 = this.getPivotDataModel().getColumnHeaderTableModel().getValuesAt(n2);
        PivotField pivotField = ((DataTableModel)this.getPivotDataModel().getDataTableModel()).getDataFieldAt(n, n2);
        if (pivotField != null && pivotField.isHideOriginalData() && (values instanceof GrandTotalValues || values2 instanceof GrandTotalValues) && (list = pivotField.getRunningSummaryList()) != null && list.size() > 0) {
            for (RunningSummary runningSummary : list) {
                PivotField pivotField2 = runningSummary.getBaseOnField();
                if (runningSummary.getRunningType() != 4 || (pivotField2.getAreaType() != 1 || !(values2 instanceof GrandTotalValues)) && (pivotField2.getAreaType() != 0 || !(values instanceof GrandTotalValues))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public int getRunningTypeAt(int n, int n2) {
        return this.getRunningTypeAt(n, n2, this.getDataFieldAt(n, n2));
    }

    private int getRunningTypeAt(int n, int n2, PivotField pivotField) {
        if (pivotField == null) {
            return -1;
        }
        Values values = this._columnTableModel.getValuesAt(n2);
        if (values instanceof RunningSummaryValues) {
            return ((RunningSummaryValues)values).getRunningType();
        }
        Values values2 = this._rowTableModel.getValuesAt(n);
        if (values2 instanceof RunningSummaryValues) {
            return ((RunningSummaryValues)values2).getRunningType();
        }
        return -1;
    }

    public int getSummaryTypeAt(int n, int n2) {
        return this.getSummaryTypeAt(n, n2, this.getDataFieldAt(n, n2));
    }

    private int getSummaryTypeAt(int n, int n2, PivotField pivotField) {
        if (pivotField == null) {
            return -1;
        }
        Values values = this._rowTableModel.getValuesAt(n);
        Values values2 = this._columnTableModel.getValuesAt(n2);
        return this._pivotDataModel.getSummaryTypeAt(values, values2, pivotField);
    }

    @Override
    public ConverterContext getConverterContextAt(int n, int n2) {
        PivotField pivotField = this.getDataFieldAt(n, n2);
        if (pivotField == null) {
            return null;
        }
        if (this._pivotDataModel.shouldCalculateSummary(n, n2)) {
            Class<?> clazz;
            if (this.needDisplayPercentageForGrandTotal(n, n2)) {
                return PercentConverter.CONTEXT;
            }
            int n3 = this.getRunningTypeAt(n, n2);
            if (n3 == 2 || n3 == 1 || n3 == 4) {
                return PercentConverter.CONTEXT;
            }
            int n4 = this.getSummaryTypeAt(n, n2);
            if (n4 != 1 && n4 != 2 && (clazz = pivotField.getSummaryClass(n4)) != null) {
                return null;
            }
        } else {
            Class<?> clazz;
            int n5;
            Object[] objectArray = this._pivotDataModel.collectValuesForCell(pivotField, n, n2, -1);
            if (objectArray == null) {
                return null;
            }
            if (objectArray.length > 1 && (n5 = this.getSummaryTypeAt(n, n2, pivotField)) != 1 && n5 != 2 && (clazz = pivotField.getSummaryClass(n5)) != null) {
                return null;
            }
        }
        return pivotField.getConverterContext();
    }

    @Override
    public EditorContext getEditorContextAt(int n, int n2) {
        PivotField pivotField = this.getDataFieldAt(n, n2);
        if (pivotField == null) {
            return null;
        }
        if (this._pivotDataModel.shouldCalculateSummary(n, n2)) {
            Class<?> clazz;
            int n3 = this.getSummaryTypeAt(n, n2);
            if (n3 != 1 && n3 != 2 && (clazz = pivotField.getSummaryClass(n3)) != null) {
                return null;
            }
        } else {
            Class<?> clazz;
            int n4;
            Object[] objectArray = this._pivotDataModel.collectValuesForCell(pivotField, n, n2, -1);
            if (objectArray == null) {
                return null;
            }
            if (objectArray.length > 1 && (n4 = this.getSummaryTypeAt(n, n2, pivotField)) != 1 && n4 != 2 && (clazz = pivotField.getSummaryClass(n4)) != null) {
                return null;
            }
        }
        return pivotField.getEditorContext();
    }

    @Override
    public Class<?> getCellClassAt(int n, int n2) {
        PivotField pivotField = this.getDataFieldAt(n, n2);
        if (this._pivotDataModel.shouldCalculateSummary(n, n2)) {
            Class<?> clazz;
            if (pivotField == null) {
                return Long.class;
            }
            if (this.needDisplayPercentageForGrandTotal(n, n2)) {
                return Double.class;
            }
            int n3 = this.getRunningTypeAt(n, n2);
            if (n3 == 2 || n3 == 1 || n3 == 4) {
                return Double.class;
            }
            int n4 = this.getSummaryTypeAt(n, n2);
            if (n4 != 1 && n4 != 2 && (clazz = pivotField.getSummaryClass(n4)) != null) {
                return clazz;
            }
            if (n4 == -2 && this._pivotDataModel.isAggregateMode()) {
                return Object.class;
            }
        } else {
            Class<?> clazz;
            int n5;
            Object[] objectArray = this._pivotDataModel.collectValuesForCell(pivotField, n, n2, -1);
            if (objectArray == null) {
                return null;
            }
            if (objectArray.length > 1 && (n5 = this.getSummaryTypeAt(n, n2, pivotField)) != 1 && n5 != 2 && (clazz = pivotField.getSummaryClass(n5)) != null) {
                return clazz;
            }
        }
        return pivotField == null ? Long.class : pivotField.getType();
    }

    public PivotField getDataFieldAt(int n, int n2) {
        PivotField[] pivotFieldArray = this._pivotDataModel.getDataFields();
        boolean bl = this._pivotDataModel.isColumnDataFields();
        boolean bl2 = this._pivotDataModel.isRowDataFields();
        if (bl2) {
            if (pivotFieldArray.length == 0 || n < 0) {
                return null;
            }
            return pivotFieldArray[this._pivotDataModel.isLayoutDataFieldsFirst() ? n / (this.getRowCount() / pivotFieldArray.length) : n % pivotFieldArray.length];
        }
        if (bl) {
            if (pivotFieldArray.length == 0 || n2 < 0) {
                return null;
            }
            return pivotFieldArray[this._pivotDataModel.isLayoutDataFieldsFirst() ? n2 / (this.getColumnCount() / pivotFieldArray.length) : n2 % pivotFieldArray.length];
        }
        if (pivotFieldArray.length == 1) {
            return pivotFieldArray[0];
        }
        return null;
    }

    @Override
    public final CellStyle getCellStyleAt(int n, int n2) {
        PivotCellStyleProvider pivotCellStyleProvider = this._pivotDataModel.getCellStyleProvider();
        if (pivotCellStyleProvider != null) {
            return pivotCellStyleProvider.getDataTableCellStyleAt(this, this._rowTableModel, this._columnTableModel, n, n2);
        }
        return null;
    }

    @Override
    public final boolean isCellStyleOn() {
        return this._pivotDataModel.getCellStyleProvider() != null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        PivotDataEditingProvider pivotDataEditingProvider = this._pivotDataModel.getDataEditingProvider();
        if (pivotDataEditingProvider != null) {
            pivotDataEditingProvider.setValueAt(this._pivotDataModel, object, n, n2);
        } else {
            super.setValueAt(object, n, n2);
        }
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        PivotDataEditingProvider pivotDataEditingProvider = this._pivotDataModel.getDataEditingProvider();
        if (pivotDataEditingProvider != null) {
            return pivotDataEditingProvider.isCellEditable(this._pivotDataModel, n, n2);
        }
        return super.isCellEditable(n, n2);
    }
}

