/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.MultiValuedMap;
import com.jidesoft.pivot.CompoundKey;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class CompoundKeyMap
extends MultiValuedMap {
    private String[] _keyNames;
    private int _rowKeyLength;
    private int _columnKeyLength;
    private static final long serialVersionUID = 4363810057937825275L;
    private boolean _needLookBack = true;
    private Set<CompoundKey> _empty = new HashSet<CompoundKey>();

    public CompoundKeyMap(String[] stringArray) {
        this._keyNames = stringArray;
    }

    public String[] getKeyNames() {
        return this._keyNames;
    }

    public int getRowKeyLength() {
        return this._rowKeyLength;
    }

    public void setRowKeyLength(int n) {
        this._rowKeyLength = n;
    }

    public int getColumnKeyLength() {
        return this._columnKeyLength;
    }

    public void setColumnKeyLength(int n) {
        this._columnKeyLength = n;
    }

    public List<Integer> getValues(CompoundKey compoundKey, CompoundKey compoundKey2) {
        return this.getValues(compoundKey, compoundKey2, true);
    }

    @Override
    public void clear() {
        this.clearEmptyValues();
        super.clear();
    }

    public void clearEmptyValues() {
        if (this._empty != null) {
            this._empty.clear();
        }
    }

    List<Integer> getValues(CompoundKey compoundKey, CompoundKey compoundKey2, boolean bl) {
        CompoundKey compoundKey3 = CompoundKey.newInstance(new Object[]{compoundKey, compoundKey2});
        Set set = (Set)this.getSet(compoundKey3);
        if (set == null && (compoundKey.getKeyCount() < this.getRowKeyLength() || compoundKey2.getKeyCount() < this.getColumnKeyLength())) {
            boolean bl2;
            Object object;
            Serializable serializable;
            if (this._empty.contains(compoundKey3)) {
                return null;
            }
            Iterator iterator = this.keySet().iterator();
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            while (iterator.hasNext()) {
                CompoundKey compoundKey4;
                serializable = (CompoundKey)iterator.next();
                Object[] objectArray = ((CompoundKey)serializable).getKeys();
                if (objectArray.length != 2 || (compoundKey4 = (CompoundKey)objectArray[0]).getKeyCount() != this.getRowKeyLength() || ((CompoundKey)(object = (CompoundKey)objectArray[1])).getKeyCount() != this.getColumnKeyLength() || !compoundKey4.startsWith(compoundKey) || !((CompoundKey)object).startsWith(compoundKey2)) continue;
                arrayList.add(serializable);
            }
            serializable = new ArrayList();
            for (CompoundKey compoundKey4 : arrayList) {
                object = this.getRowIfEmpty(compoundKey4);
                if (object == null) continue;
                serializable.addAll(object);
            }
            boolean bl3 = bl2 = serializable.size() == 0;
            if (bl2) {
                serializable.add(-1);
            }
            if (bl2) {
                if (bl) {
                    this._empty.add(compoundKey3);
                }
                return null;
            }
            if (bl) {
                this.putValues(compoundKey, compoundKey2, (List)((Object)serializable));
            }
            return serializable;
        }
        List list = (List)this.getRaw(compoundKey3);
        if (list != null && list.size() == 1 && list.get(0).equals(-1)) {
            return null;
        }
        return list;
    }

    Set<Integer> getValuesAsSet(CompoundKey compoundKey, CompoundKey compoundKey2) {
        CompoundKey compoundKey3 = CompoundKey.newInstance(new Object[]{compoundKey, compoundKey2});
        Set set = (Set)this.getSet(compoundKey3);
        if (set == null && (compoundKey.getKeyCount() < this.getRowKeyLength() || compoundKey2.getKeyCount() < this.getColumnKeyLength())) {
            boolean bl;
            Object object;
            Serializable serializable;
            if (this._empty.contains(compoundKey3)) {
                return null;
            }
            Iterator iterator = this.keySet().iterator();
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
            while (iterator.hasNext()) {
                CompoundKey compoundKey4;
                serializable = (CompoundKey)iterator.next();
                Object[] objectArray = ((CompoundKey)serializable).getKeys();
                if (objectArray.length != 2 || (compoundKey4 = (CompoundKey)objectArray[0]).getKeyCount() != this.getRowKeyLength() || ((CompoundKey)(object = (CompoundKey)objectArray[1])).getKeyCount() != this.getColumnKeyLength() || !compoundKey4.startsWith(compoundKey) || !((CompoundKey)object).startsWith(compoundKey2)) continue;
                arrayList.add(serializable);
            }
            serializable = new HashSet();
            for (CompoundKey compoundKey4 : arrayList) {
                object = this.getRowIfEmpty(compoundKey4);
                if (object == null) continue;
                serializable.addAll(object);
            }
            boolean bl2 = bl = serializable.size() == 0;
            if (bl) {
                serializable.add(-1);
            }
            if (bl) {
                return null;
            }
            return serializable;
        }
        List list = (List)this.getRaw(compoundKey3);
        if (list != null && list.size() == 1 && list.get(0).equals(-1)) {
            return null;
        }
        return set;
    }

    protected List getRowIfEmpty(Object object) {
        List list = (List)this.getRaw(object);
        if (list == null || list.size() == 1 && list.get(0).equals(-1)) {
            return null;
        }
        return list;
    }

    public List addValue(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        List list = this.add(CompoundKey.newInstance(new Object[]{compoundKey, compoundKey2}), n);
        if (!this.isNeedLookBack()) {
            return list;
        }
        Object[] objectArray = compoundKey.getKeys();
        int n2 = objectArray.length;
        while (objectArray.length >= 0) {
            Object[] objectArray2;
            Object object;
            CompoundKey compoundKey3 = new CompoundKey(objectArray);
            if (objectArray.length != n2 && this.get(object = CompoundKey.newInstance(new Object[]{compoundKey3, compoundKey2})) != null) {
                this.add(object, n);
            }
            object = compoundKey2.getKeys();
            while (((Object[])object).length >= 1) {
                objectArray2 = new Object[((Object[])object).length - 1];
                System.arraycopy(object, 0, objectArray2, 0, ((Object[])object).length - 1);
                CompoundKey compoundKey4 = new CompoundKey(objectArray2);
                CompoundKey compoundKey5 = CompoundKey.newInstance(new Object[]{compoundKey3, compoundKey4});
                if (this.get(compoundKey5) != null) {
                    this.add(compoundKey5, n);
                }
                object = objectArray2;
            }
            if (objectArray.length <= 0) break;
            objectArray2 = new Object[objectArray.length - 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
            objectArray = objectArray2;
        }
        return list;
    }

    public void putValues(CompoundKey compoundKey, CompoundKey compoundKey2, List list) {
        this.putValues((Object)CompoundKey.newInstance(new Object[]{compoundKey, compoundKey2}), list);
    }

    private void putValuesForPrefixes(CompoundKey compoundKey, CompoundKey compoundKey2, List list) {
        CompoundKey[] compoundKeyArray = compoundKey.getCompoundKeyPrefixes();
        CompoundKey[] compoundKeyArray2 = compoundKey2.getCompoundKeyPrefixes();
        block0: for (CompoundKey compoundKey3 : compoundKeyArray) {
            for (CompoundKey compoundKey4 : compoundKeyArray2) {
                if (compoundKey3 == compoundKey && compoundKey4 == compoundKey2) continue block0;
                List<Integer> list2 = this.getValues(compoundKey3, compoundKey4);
                if (list2 == null) continue;
                for (Object e : list) {
                    if (!(e instanceof Integer)) continue;
                    this.add(CompoundKey.newInstance(new Object[]{compoundKey3, compoundKey4}), e);
                }
            }
        }
    }

    private void addValueForPrefixes(CompoundKey compoundKey, CompoundKey compoundKey2, int n) {
        CompoundKey[] compoundKeyArray = compoundKey.getCompoundKeyPrefixes();
        CompoundKey[] compoundKeyArray2 = compoundKey2.getCompoundKeyPrefixes();
        block0: for (CompoundKey compoundKey3 : compoundKeyArray) {
            for (CompoundKey compoundKey4 : compoundKeyArray2) {
                if (compoundKey3 == compoundKey && compoundKey4 == compoundKey2) continue block0;
                List<Integer> list = this.getValues(compoundKey3, compoundKey4);
                if (list == null) continue;
                this.add(CompoundKey.newInstance(new Object[]{compoundKey3, compoundKey4}), n);
            }
        }
    }

    CompoundKey[] removeValue(int n) {
        ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
        Set set = this.keySet();
        for (Object k : set) {
            List list = this.getRowIfEmpty(k);
            if (list == null || !list.contains(n)) continue;
            this.remove(k, n);
            arrayList.add((CompoundKey)k);
        }
        return arrayList.toArray(new CompoundKey[arrayList.size()]);
    }

    CompoundKey[] getValue(int n) {
        ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
        Set set = this.keySet();
        for (Object k : set) {
            List list = this.getRowIfEmpty(k);
            if (list == null || !list.contains(n)) continue;
            arrayList.add((CompoundKey)k);
        }
        return arrayList.toArray(new CompoundKey[arrayList.size()]);
    }

    CompoundKey[] removeValues(int n, int n2) {
        ArrayList<CompoundKey> arrayList = new ArrayList<CompoundKey>();
        int n3 = n2 - n + 1;
        Set set = this.keySet();
        for (Object k : set) {
            List list = this.getRowIfEmpty(k);
            if (list == null || list.size() == 0 || !(k instanceof CompoundKey)) continue;
            if (n + 5 >= n2 && list.size() > 1000) {
                for (int i = n; i <= n2; ++i) {
                    if (!list.contains(i)) continue;
                    this.remove(k, i);
                    arrayList.add((CompoundKey)k);
                }
            } else {
                Object[] objectArray;
                for (Object object : objectArray = list.toArray()) {
                    if (!(object instanceof Integer) || (Integer)object < n || (Integer)object > n2) continue;
                    this.remove(k, object);
                    arrayList.add((CompoundKey)k);
                }
            }
            if ((list = this.getRowIfEmpty(k)) == null || list.size() == 0) continue;
            for (Object e : list) {
                int n4 = (Integer)e;
                if (n4 <= n2) continue;
                this.change(k, n4, n4 - n3);
            }
        }
        return arrayList.toArray(new CompoundKey[arrayList.size()]);
    }

    void insertValues(int n, int n2) {
        int n3 = n2 - n + 1;
        Set set = this.keySet();
        for (Object k : set) {
            List list = this.getRowIfEmpty(k);
            if (list == null || list.size() == 0) continue;
            for (int i = list.size() - 1; i >= 0; --i) {
                int n4 = (Integer)list.get(i);
                if (n4 < n2) continue;
                this.change(k, n4, n4 + n3);
            }
        }
    }

    boolean isNeedLookBack() {
        return this._needLookBack;
    }

    void setNeedLookBack(boolean bl) {
        this._needLookBack = bl;
    }
}

