/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.grid.Expandable;
import com.jidesoft.pivot.CompoundKey;
import com.jidesoft.pivot.CopiedExpandableValue;
import com.jidesoft.pivot.DefaultExpandableValue;
import com.jidesoft.pivot.DummyValues;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.IPivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValue;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Values;
import com.jidesoft.swing.JideSwingUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CalculatedHeaderTableModel
extends HeaderTableModel {
    private static final long serialVersionUID = -312002961255209188L;
    private Map<PivotField, Set<Values>> _hiddenOriginalValues = new HashMap<PivotField, Set<Values>>();

    public CalculatedHeaderTableModel(IPivotDataModel iPivotDataModel, CompoundKey[] compoundKeyArray, boolean bl) {
        super(iPivotDataModel, compoundKeyArray, bl);
    }

    Map<PivotField, Set<Values>> getHiddenOriginalValues() {
        return this._hiddenOriginalValues;
    }

    @Override
    protected void setRows(CompoundKey[] compoundKeyArray) {
        if (this._hiddenOriginalValues != null) {
            this._hiddenOriginalValues.clear();
            this._hiddenOriginalValues = null;
        }
        super.setRows(compoundKeyArray);
    }

    @Override
    List<Values> flatten(List list) {
        List<Values> list2 = super.flatten(list);
        this.removeOriginalData(list2);
        return list2;
    }

    private void removeOriginalData(List<Values> list) {
        PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
        if (this._hiddenOriginalValues == null) {
            this._hiddenOriginalValues = new HashMap<PivotField, Set<Values>>();
        }
        this._hiddenOriginalValues.clear();
        if (this.isRowHeader()) {
            this.getPivotDataModel().clearHiddenRows();
        } else {
            this.getPivotDataModel().clearHiddenColumns();
        }
        for (PivotField pivotField : pivotFieldArray) {
            List<RunningSummary> list2 = pivotField.getRunningSummaryList();
            if (list2 == null || list2.size() <= 0 || !pivotField.isHideOriginalData()) continue;
            HashSet<Values> cloneable = new HashSet<Values>();
            this._hiddenOriginalValues.put(pivotField, cloneable);
            boolean list3 = false;
            boolean set = false;
            for (RunningSummary runningSummary : list2) {
                int n = runningSummary.getBaseOnField().getAreaType();
                if (n == 0) {
                    list3 = true;
                    continue;
                }
                if (n != 1) continue;
                set = true;
            }
            for (Values values : list) {
                if (this.isRowHeader() && list3) {
                    if (values instanceof SummaryValues || values instanceof GrandTotalValues || values instanceof RunningSummaryValues || values instanceof DummyValues || values.getCount() != this._fields.length || !this.getPivotDataModel().isRowVisible(values, pivotField)) continue;
                    this.getPivotDataModel().addHiddenRow(values, pivotField);
                    cloneable.add(values);
                    continue;
                }
                if (this.isRowHeader() || !set || values instanceof SummaryValues || values instanceof GrandTotalValues || values instanceof RunningSummaryValues || values instanceof DummyValues || values.getCount() != this._fields.length || !this.getPivotDataModel().isColumnVisible(values, pivotField)) continue;
                this.getPivotDataModel().addHiddenColumn(values, pivotField);
                cloneable.add(values);
            }
        }
        if (pivotFieldArray.length > 1) {
            for (Values values : list) {
                if (!(values instanceof RunningSummaryValues)) continue;
                for (PivotField pivotField : pivotFieldArray) {
                    Set<Values> set;
                    List<RunningSummary> list2 = pivotField.getRunningSummaryList();
                    if (this.isRowHeader()) {
                        if (list2 != null && list2.indexOf(((RunningSummaryValues)values).getRunningSummary()) >= 0 || !this.getPivotDataModel().isRowVisible(values, pivotField)) continue;
                        this.getPivotDataModel().addHiddenRow(values, pivotField);
                        set = this._hiddenOriginalValues.get(pivotField);
                        if (set == null) {
                            set = new HashSet<Values>();
                            this._hiddenOriginalValues.put(pivotField, set);
                        }
                        set.add(values);
                        continue;
                    }
                    if (list2 != null && list2.indexOf(((RunningSummaryValues)values).getRunningSummary()) >= 0 || !this.getPivotDataModel().isColumnVisible(values, pivotField)) continue;
                    this.getPivotDataModel().addHiddenColumn(values, pivotField);
                    set = this._hiddenOriginalValues.get(pivotField);
                    if (set == null) {
                        set = new HashSet<Values>();
                        this._hiddenOriginalValues.put(pivotField, set);
                    }
                    set.add(values);
                }
            }
        }
    }

    @Override
    void summarize(List list, List list2, Expandable expandable, int n) {
        super.summarize(list, list2, expandable, n);
        if (list2.size() <= 0) {
            return;
        }
        Object e = list2.get(0);
        if (!(e instanceof Expandable)) {
            return;
        }
        PivotField[] pivotFieldArray = this.getPivotDataModel().getDataFields();
        if (n >= this._fields.length) {
            return;
        }
        PivotField pivotField = this._fields[n];
        for (PivotField pivotField2 : pivotFieldArray) {
            List<RunningSummary> list3 = pivotField2.getRunningSummaryList();
            if (list3 == null || list3.size() <= 0) continue;
            for (RunningSummary runningSummary : list3) {
                if (runningSummary.getBaseOnField() != pivotField) continue;
                for (Object e2 : list2) {
                    Object e3;
                    int n2;
                    RunningSummaryValue runningSummaryValue = new RunningSummaryValue(e2, runningSummary);
                    e2 = e2 instanceof DefaultExpandableValue ? ((DefaultExpandableValue)e2).getValue() : null;
                    for (n2 = 0; !(n2 >= list.size() || (e3 = list.get(n2)) instanceof CopiedExpandableValue && JideSwingUtilities.equals(((CopiedExpandableValue)e3).getValue(), e2)); ++n2) {
                    }
                    ++n2;
                    while (n2 < list.size() && (e3 = list.get(n2)) instanceof RunningSummaryValue) {
                        ++n2;
                    }
                    list.add(n2, runningSummaryValue);
                    runningSummaryValue.setParent(expandable);
                }
            }
        }
    }
}

